package jp.co.sra.jun.system.support;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StCheckBoxMenuItem;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuBar;
import jp.co.sra.smalltalk.menu.StMenuItem;

import jp.co.sra.jun.goodies.display.JunDisplayModel;
import jp.co.sra.jun.goodies.display.JunDisplayViewAwt;
import jp.co.sra.jun.goodies.display.JunDisplayViewSwing;
import jp.co.sra.jun.opengl.support.JunOpenGLResource;
import jp.co.sra.jun.system.framework.JunDialog;

/**
 * JunTestExamples class
 * 
 *  @author    nisinaka
 *  @created   1998/09/28 (by nisinaka)
 *  @updated   1999/06/25 (by MATSUDA Ryouichi)
 *  @updated   2000/01/14 (by MATSUDA Ryouichi)
 *  @updated   2001/04/10 (by nisinaka)
 *  @updated   2002/11/21 (by nisinaka)
 *  @updated   2003/03/03 (by Mitsuhiro Asada)
 *  @updated   2003/03/19 (by nisinaka)
 *  @updated   2005/02/24 (by nisinaka)
 *  @updated   2007/06/28 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTestExamples.java,v 8.13 2008/02/20 06:32:59 nisinaka Exp $
 */
public abstract class JunTestExamples extends JunDisplayModel {

	protected boolean closeToExit = true;
	protected StMenuBar _menuBar;

	/**
	 * Creates a new JunTestExamples object.
	 * 
	 * @category Instance creation
	 */
	public JunTestExamples() {
		super();
		this.open();
	}

	/**
	 * Initialize the JunTestExamples when created.
	 * 
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		_scrollable = false;
	}

	/**
	 * Answer whether be elapsing or not.
	 * 
	 * @return boolean
	 * @category accessing
	 */
	public boolean isElapsing() {
		StCheckBoxMenuItem aMenuItem = (StCheckBoxMenuItem) this._menuBar().atNameKey_($("elapsing"));
		return aMenuItem.isSelected();
	}

	/**
	 * Set the status whether be elapsing or not.
	 * 
	 * @param aBoolean boolean
	 * @category accessing
	 */
	public void beElapsing(boolean aBoolean) {
		StCheckBoxMenuItem aMenuItem = (StCheckBoxMenuItem) this._menuBar().atNameKey_($("elapsing"));
		aMenuItem.beSelected(aBoolean);
	}

	/**
	 * Set whether exit or not when closing a window.
	 *
	 * @param aBoolean boolean
	 * @category accessing
	 */
	public void closeToExit(boolean aBoolean) {
		closeToExit = aBoolean;
	}

	/**
	 * Answer my visual object.
	 * 
	 * @return jp.co.sra.smalltalk.StDisplayable
	 * @category accessing
	 */
	public StDisplayable visual() {
		if (displayObject == null) {
			StImage logoImage = new StImage(JunSystem.LogoImage());
			int width = logoImage.width();
			int height = logoImage.height();
			height = (JunLauncher._DefaultWidth - 20) * height / width;
			width = (JunLauncher._DefaultWidth - 20);
			StImage image = new StImage(JunLauncher._DefaultWidth, height);
			Graphics aGraphics = null;
			try {
				aGraphics = image.image().getGraphics();
				aGraphics.drawImage(logoImage.image(), 10, 0, width, height, null);
			} finally {
				if (aGraphics != null) {
					aGraphics.dispose();
					aGraphics = null;
				}
			}
			displayObject = image;
		}
		return displayObject;
	}

	/**
	 * Answer a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @category interface opening
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunDisplayViewAwt(this) {
				protected void buildComponent() {
					super.buildComponent();
					this.canvas().setBackground(Color.white);
				}
			};
		} else {
			return new JunDisplayViewSwing(this) {
				protected void buildComponent() {
					super.buildComponent();
					this.canvas().setBackground(Color.white);
				}
			};
		}
	}

	/**
	 * Create a Frame for the application model.
	 * Do everything but open the frame.
	 *
	 * @return java.awt.Frame
	 * @param aView jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationModel#allButOpenView_(jp.co.sra.smalltalk.StView)
	 * @category interface opening
	 */
	protected Frame allButOpenView_(StView aView) {
		Frame aFrame = super.allButOpenView_(aView);
		aFrame.setSize(203, 167);
		return aFrame;
	}

	/**
	 * Answer the window title.
	 * 
	 * @return java.lang.String
	 * @category interface opening
	 */
	protected String windowTitle() {
		return this._className().toString();
	}

	/**
	 * Invoked when a window is in the process of being closed.
	 * 
	 * @param e java.awt.event.WindowEvent
	 * @category events
	 */
	public void noticeOfWindowClose(WindowEvent e) {
		if (closeToExit) {
			if (JunDialog.Confirm_(JunSystem.$String("Really quit?"), false)) {
				System.exit(0);
			} else {
				e.getWindow().setVisible(true);
			}
		} else {
			super.noticeOfWindowClose(e);
		}
	}

	/**
	 * Answer my menu bar.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StMenuBar
	 * @see jp.co.sra.smalltalk.StApplicationModel#_menuBar()
	 * @category resources
	 */
	public StMenuBar _menuBar() {
		if (_menuBar == null) {
			_menuBar = new StMenuBar();
			_menuBar.add(this._createExamplesMenu());
			_menuBar.add(this._createMiscMenu());
		}
		return _menuBar;
	}

	/**
	 * Create an "Examples" menu.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StMenu
	 * @category resources
	 */
	protected StMenu _createExamplesMenu() {
		StMenu aMenu = new StMenu(JunSystem.$String("Examples"));

		aMenu.add(new StMenuItem(JunSystem.$String("All"), new MenuPerformer(this, "executeAllMethods")));
		aMenu.addSeparator();

		String[] methodNames = GetStaticMethodNamesFor(this.getClass());
		if (methodNames.length > 20 && methodNames[0].indexOf('_') > 0) {
			Map groupMenus = new HashMap();
			for (int i = 0; i < methodNames.length; i++) {
				String methodName = methodNames[i];
				String groupName = methodName.substring(0, methodName.indexOf('_'));
				StMenu groupMenu = (StMenu) groupMenus.get(groupName);
				if (groupMenu == null) {
					groupMenu = new StMenu(groupName, $(groupName));
					aMenu.add(groupMenu);
					groupMenus.put(groupName, groupMenu);
				}
				groupMenu.add(new StMenuItem(methodName, new MenuPerformer(this, "executeMethod", methodName)));
			}
		} else {
			for (int i = 0; i < methodNames.length; i++) {
				aMenu.add(new StMenuItem(methodNames[i], new MenuPerformer(this, "executeMethod", methodNames[i])));
			}
		}

		return aMenu;
	}

	/**
	 * Create a "Misc" menu.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StMenu
	 * @category resources
	 */
	protected StMenu _createMiscMenu() {
		StMenu aMenu = new StMenu(JunSystem.$String("Misc"));
		aMenu.add(new StCheckBoxMenuItem(JunSystem.$String("Measure elapsing"), $("elapsing"), false));
		aMenu.addSeparator();
		aMenu.add(JunOpenGLResource.DefaultOpenGLViewMenu);
		aMenu.add(StApplicationModel.DefaultViewModeMenu);
		//aMenu.add(JunSystem.DefaultRenderingModeMenu);
		aMenu.add(JunSystem.DefaultLanguageModeMenu);
		return aMenu;
	}

	/**
	 * Execute all static methods.
	 * 
	 * @category utilities
	 */
	public void executeAllMethods() {
		String[] methodNames = GetStaticMethodNamesFor(this.getClass());
		for (int i = 0; i < methodNames.length; i++) {
			this.executeMethod(methodNames[i]);
		}
	}

	/**
	 * Execute the static method with the specified name.
	 * 
	 * @param methodName java.lang.String
	 * @category message handling
	 */
	public void executeMethod(String methodName) {
		System.out.println(methodName);

		try {
			long start = System.currentTimeMillis();
			Boolean result = (Boolean) StObject._Perform(this.getClass(), methodName);
			long end = System.currentTimeMillis();
			System.out.println("-> " + result);

			if (this.isElapsing()) {
				System.out.println("-> elapsed " + (end - start) + " msec");
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * Answer all static method names.
	 * 
	 * @param aClass java.lang.Class
	 * @return java.lang.String[]
	 * @category Utilities
	 */
	public static String[] GetStaticMethodNamesFor(Class aClass) {
		TreeSet aTreeSet = new TreeSet(new Comparator() {
			public int compare(Object arg0, Object arg1) {
				return arg0.toString().compareTo(arg1.toString());
			}
		});

		Method[] methods = aClass.getDeclaredMethods();
		for (int i = 0; i < methods.length; i++) {
			Method aMethod = methods[i];
			if (aMethod.getParameterTypes().length == 0) {
				int modifiers = aMethod.getModifiers();
				if (Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers)) {
					aTreeSet.add(aMethod.getName());
				}
			}
		}

		return (String[]) aTreeSet.toArray(new String[aTreeSet.size()]);
	}

}
