package jp.co.sra.jun.topology.abstracts;

import jp.co.sra.jun.topology.elements.JunBody;

/*
 * @(#)JunAbstractOperator.java        1.0 98/9/17
 */
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StValued;

/**
 * JunAbstractOperator class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunAbstractOperator.java,v 8.12 2008/02/20 06:33:01 nisinaka Exp $
 */
public abstract class JunAbstractOperator extends JunTopology implements StValued {
	/** A JunBody on which the receiver operate. */
	protected JunBody body = null;

	/**
	 * Create a new instance of <code>JunAbstractOperator</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunAbstractOperator() {
		body = null;
	}

	/**
	 * Create a new instance of JunAbstractOperator and initialize it with a JunBody.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 * @category Instance creation
	 */
	public JunAbstractOperator(JunBody aBody) {
		this();
		this.body_(aBody);
	}

	/**
	 * Answer the body.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunBody
	 * @category accessing
	 */
	public final JunBody body() {
		return body;
	}

	/**
	 * Set a body.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 * @category accessing
	 */
	public final void body_(JunBody aBody) {
		body = aBody;
	}

	/**
	 * Do the operation.     - In Smalltalk, the method name is "do".
	 * 
	 * @category executing
	 */
	public void doOperation() {
		this.preExecute();
		this.execute();
		this.postExecute();
	}

	/**
	 * Execute the operation.
	 * 
	 * @category executing
	 */
	public abstract void execute();

	/**
	 * Answer the topological element of the receiver.
	 * 
	 * @param aTopologicalElementOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @return jp.co.sra.jun.topology.abstracts.JunTopologicalElement
	 * @category accessing
	 */
	public JunTopologicalElement getTopologicalElement_(JunTopologicalElementOrProxy aTopologicalElementOrProxy) {
		if (aTopologicalElementOrProxy == null) {
			return null;
		}

		if (aTopologicalElementOrProxy.isTopologicalProxy()) {
			return ((JunTopologicalElementProxy) aTopologicalElementOrProxy).value_(this.body);
		} else {
			return (JunTopologicalElement) aTopologicalElementOrProxy;
		}
	}

	/**
	 * Answer the topological element proxy of the receiver.
	 * 
	 * @param aTopologicalElementOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @return jp.co.sra.jun.topology.abstracts.JunTopologicalElementProxy
	 * @category accessing
	 */
	public JunTopologicalElementProxy getTopologicalElementProxy_(JunTopologicalElementOrProxy aTopologicalElementOrProxy) {
		return this.getTopologicalElementProxy_advise_(aTopologicalElementOrProxy, null);
	}

	/**
	 * Answer the topological element proxy of the receiver with advise.
	 * 
	 * @param aTopologicalElementOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aTopologicalElementProxyOrNull
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementProxy
	 * @return jp.co.sra.jun.topology.abstracts.JunTopologicalElementProxy
	 * @category accessing
	 */
	public JunTopologicalElementProxy getTopologicalElementProxy_advise_(JunTopologicalElementOrProxy aTopologicalElementOrProxy, JunTopologicalElementProxy aTopologicalElementProxyOrNull) {
		if (aTopologicalElementOrProxy == null) {
			return null;
		}

		return aTopologicalElementOrProxy.asProxyIn_advise_(this.body(), aTopologicalElementProxyOrNull);
	}

	/**
	 * Answer the inverse operation of the receiver.
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunAbstractOperator
	 * @category inverting
	 */
	public abstract JunAbstractOperator inverse();

	/**
	 * Answer true if the receiver is a kind of Euler Operator.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isEulerOperator() {
		return false;
	}

	/**
	 * Answer true if the receiver is a kind of Geometric Operator.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isGeometricOperator() {
		return false;
	}

	/**
	 * Answer true if the receiver is a kind of Global Operator.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isGlobalOperator() {
		return false;
	}

	/**
	 * Answer true if the receiver can be inverted.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public abstract boolean isInversable();

	/**
	 * Answer true if the post-condition is valid.
	 * 
	 * @return boolean
	 * @category executing
	 */
	public boolean postcondition() {
		return true;
	}

	/**
	 * Do something after the execution.
	 * 
	 * @category executing
	 */
	public void postExecute() {
		if (!postcondition()) {
			throw SmalltalkException.Error("Invalid operation");
		}
	}

	/**
	 * Answer true if the pre-condition is valid.
	 * 
	 * @return boolean
	 * @category executing
	 */
	public boolean precondition() {
		return true;
	}

	/**
	 * Do something before the execution.
	 * 
	 * @category executing
	 */
	public void preExecute() {
		if (!precondition()) {
			throw SmalltalkException.Error("Invalid operation");
		}
	}

	/**
	 * Undo the operation.     - In Smalltalk, the method name is "undo".
	 * 
	 * @category executing
	 */
	public void undoOperation() {
		this.inverse().doOperation();
	}

	/**
	 * Answer the value of the operator.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunBody
	 * @see jp.co.sra.smalltalk.StValued#value()
	 * @category executing
	 */
	public Object value() {
		this.doOperation();
		return this.body();
	}
}
