package jp.co.sra.jun.topology.abstracts;

import jp.co.sra.jun.topology.elements.JunBody;

/**
 * JunEulerOperator class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunEulerOperator.java,v 8.10 2008/02/20 06:33:01 nisinaka Exp $
 */
public abstract class JunEulerOperator extends JunAbstractOperator {

	/**
	 * Default constructor.
	 */
	public JunEulerOperator() {
		super();
	}

	/**
	 * Create a new instance of JunEulerOperator and initialize it with a
	 * JunBody.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 */
	public JunEulerOperator(JunBody aBody) {
		super(aBody);
	}

	/**
	 * Answer true if the receiver is a kind of Euler Operator.
	 * 
	 * @return boolean
	 */
	public boolean isEulerOperator() {
		return true;
	}

	/**
	 * Answer true if the receiver can be inverted.
	 * 
	 * @return boolean
	 */
	public boolean isInversable() {
		return true;
	}
}
