package jp.co.sra.jun.topology.abstracts;

import jp.co.sra.jun.topology.elements.JunBody;

/*
 * @(#)JunTopologicalElementProxy.java        1.0 98/9/15
 */
import jp.co.sra.smalltalk.SmalltalkException;

/**
 * JunTopologicalElementProxy class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTopologicalElementProxy.java,v 8.10 2008/02/20 06:33:01 nisinaka Exp $
 */
public abstract class JunTopologicalElementProxy extends JunTopology implements JunTopologicalElementOrProxy {

	/**
	 * Convert the receiver as a proxy in aBody.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunTopologicalElementProxy
	 */
	public JunTopologicalElementProxy asProxyIn_(JunBody aBody) {
		return this.asProxyIn_advise_(aBody, this);
	}

	/**
	 * Convert the receiver as a proxy in aBody.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aTopologicalElementProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementProxy
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunTopologicalElementProxy
	 */
	public JunTopologicalElementProxy asProxyIn_advise_(JunBody aBody, JunTopologicalElementProxy aTopologicalElementProxy) {
		return this;
	}

	/**
	 * Answer true if the receiver is a kind of geometry, otherwise false.
	 * 
	 * @return boolean
	 */
	public boolean isTopologicalProxy() {
		return true;
	}

	/**
	 * Answer the JunTopologicalElement of aBody corresponds to the receiver.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunTopologicalElement
	 */
	public JunTopologicalElement value_(JunBody aBody) {
		throw SmalltalkException.SubclassResponsibility();
	}
}
