package jp.co.sra.jun.topology.euleroperators;

import jp.co.sra.jun.topology.abstracts.*;
import jp.co.sra.jun.topology.elements.*;
import jp.co.sra.smalltalk.*;

/**
 * JunKEL class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   1999/08/04 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunKEL.java,v 8.10 2008/02/20 06:33:01 nisinaka Exp $
 */
public class JunKEL extends JunEulerOperator {
	protected JunEdgeProxy edgeProxy;
	protected JunLoopProxy loopProxy1;
	protected JunLoopProxy loopProxy2;
	protected JunVertexProxy vertexProxy1;
	protected JunVertexProxy vertexProxy2;
	protected JunEdgeProxy edgeProxy2;
	protected JunEdgeProxy edgeProxy3;

	/**
	 * Create a new instance of JunKEL and initialize it.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunKEL
	 */
	public static final JunKEL Body_edge_(JunBody aBody, JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		JunKEL anOperator = new JunKEL();
		anOperator.body_(aBody);
		anOperator.edge_(aJunEdgeOrProxy);

		return anOperator;
	}

	/**
	 * Create a new instance of JunKEL and initialize it.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunLoopOrProxy1
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunLoopOrProxy2
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunVertexOrProxy1
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunVertexOrProxy2
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunKEL
	 */
	public static final JunKEL Body_edge_adviseLoop_loop_vertex_vertex_(
		JunBody aBody,
		JunTopologicalElementOrProxy aJunEdgeOrProxy,
		JunTopologicalElementOrProxy aJunLoopOrProxy1,
		JunTopologicalElementOrProxy aJunLoopOrProxy2,
		JunTopologicalElementOrProxy aJunVertexOrProxy1,
		JunTopologicalElementOrProxy aJunVertexOrProxy2) {
		JunKEL anOperator = new JunKEL();
		anOperator.body_(aBody);
		anOperator.edge_(aJunEdgeOrProxy);
		anOperator.loop1_(aJunLoopOrProxy1);
		anOperator.loop2_(aJunLoopOrProxy2);
		anOperator.vertex1_(aJunVertexOrProxy1);
		anOperator.vertex2_(aJunVertexOrProxy2);

		return anOperator;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJunEdge jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunLoop jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunKEL
	 */
	public static final JunKEL Body_edge_aliveLoop_(JunBody aJunBody, JunEdge aJunEdge, JunLoop aJunLoop) {
		JunKEL anOperator;
		anOperator = new JunKEL();
		anOperator.body_(aJunBody);
		anOperator.edge_(aJunEdge);
		anOperator.loop2_(aJunLoop);
		anOperator.loop1_((aJunEdge.oppositeLoopOfLoop_(aJunLoop)));

		return anOperator;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunLoopOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunKEL
	 */
	public static final JunKEL Body_edge_killLoop_(JunBody aBody, JunTopologicalElementOrProxy aJunEdgeOrProxy, JunTopologicalElementOrProxy aJunLoopOrProxy) {
		JunKEL anOperator;
		anOperator = new JunKEL();
		anOperator.body_(aBody);
		anOperator.edge_(aJunEdgeOrProxy);
		anOperator.loop1_(aJunLoopOrProxy);

		return anOperator;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunLoop
	 */
	public JunLoop aliveLoop() {
		return this.loop2();
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge edge() {
		return (JunEdge) this.getTopologicalElement_(this.edgeProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void edge_(JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		this.edgeProxy = (JunEdgeProxy) this.getTopologicalElementProxy_advise_(aJunEdgeOrProxy, this.edgeProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge edge2() {
		return (JunEdge) this.getTopologicalElement_(this.edgeProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void edge2_(JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		this.edgeProxy2 = (JunEdgeProxy) this.getTopologicalElementProxy_advise_(aJunEdgeOrProxy, this.edgeProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge edge3() {
		return (JunEdge) this.getTopologicalElement_(this.edgeProxy3);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void edge3_(JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		this.edgeProxy3 = (JunEdgeProxy) this.getTopologicalElementProxy_advise_(aJunEdgeOrProxy, this.edgeProxy3);
	}

	/**
	 * Execute the operation.
	 */
	public void execute() {
		if (this.loop1() == null) {
			this.loop1_(this.edge().leftLoop());
		}

		if (this.loop2() == null) {
			if (this.loop1() == this.edge().leftLoop()) {
				this.loop2_(this.edge().rightLoop());
			} else {
				this.loop2_(this.edge().leftLoop());
			}
		}

		if (this.vertex1() == null) {
			this.vertex1_(this.edge().directionVertexOnLoop_(this.loop2()));
		}

		if (this.vertex2() == null) {
			this.vertex2_(this.edge().oppositeVertexOfVertex_(this.vertex1()));
		}

		JunEdge[] edges = this.loop1().edges();
		JunEdge fromEdge1 = this.edge().prevEdgeWithVertex_(this.vertex1());
		JunEdge toEdge1 = this.edge().nextEdgeWithVertex_(this.vertex1());
		JunEdge fromEdge2 = this.edge().prevEdgeWithVertex_(this.vertex2());
		JunEdge toEdge2 = this.edge().nextEdgeWithVertex_(this.vertex2());
		this.edge2_(fromEdge1);
		this.edge3_(fromEdge2);
		fromEdge1.setNextEdge_withVertex_(toEdge1, this.vertex1());
		fromEdge2.setNextEdge_withVertex_(toEdge2, this.vertex2());

		for (int i = 0; i < edges.length; i++) {
			edges[i].setLoop_insteadOf_(this.loop2(), this.loop1());
		}

		if (this.loop2().edge() == this.edge()) {
			this.loop2().edge_(fromEdge1);
		}

		if (this.vertex1().edge() == this.edge()) {
			this.vertex1().edge_(fromEdge1);
		}

		if (this.vertex2().edge() == this.edge()) {
			this.vertex2().edge_(fromEdge2);
		}

		this.loop1().forget();
		this.edge().forget();
		this.body().removeLoop_(this.loop1());
		this.body().removeEdge_(this.edge());

		if ((fromEdge1.loopToVertex_(this.vertex1())) != this.loop2()) {
			throw SmalltalkException.Error("internal error");
		}

		if ((fromEdge2.loopToVertex_(this.vertex2()) != this.loop2())) {
			throw SmalltalkException.Error("internal error");
		}

		if ((fromEdge1.nextEdgeWithVertex_(this.vertex1())) != toEdge1) {
			throw SmalltalkException.Error("internal error");
		}

		if (fromEdge2.nextEdgeWithVertex_(this.vertex2()) != toEdge2) {
			throw SmalltalkException.Error("internal error");
		}
	}

	/**
	 * Answer the inverse operation of the receiver.
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunAbstractOperator
	 */
	public JunAbstractOperator inverse() {
		return JunMEL.Body_loop_vertex_vertex_adviseEdge_loop_edge_edge_(this.body(), this.loopProxy2, this.vertexProxy1, this.vertexProxy2, this.edgeProxy, this.loopProxy1, this.edgeProxy2, this.edgeProxy3);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunLoop
	 */
	public JunLoop killedLoop() {
		return this.loop1();
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunLoop
	 */
	public JunLoop loop1() {
		return (JunLoop) this.getTopologicalElement_(this.loopProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunLoopOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void loop1_(JunTopologicalElementOrProxy aJunLoopOrProxy) {
		this.loopProxy1 = (JunLoopProxy) this.getTopologicalElementProxy_advise_(aJunLoopOrProxy, this.loopProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunLoop
	 */
	public JunLoop loop2() {
		return (JunLoop) this.getTopologicalElement_(this.loopProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunLoopOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void loop2_(JunTopologicalElementOrProxy aJunLoopOrProxy) {
		this.loopProxy2 = (JunLoopProxy) this.getTopologicalElementProxy_advise_(aJunLoopOrProxy, this.loopProxy2);
	}

	/**
	 * Answer true if the pre-condition is valid.
	 * 
	 * @return boolean
	 */
	public boolean precondition() {
		if (super.precondition() == false) {
			return false;
		}

		if (this.edge() == null) {
			return false;
		}

		if (this.edge().leftLoop() == this.edge().rightLoop()) {
			return false;
		}

		return true;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunVertex
	 */
	public JunVertex vertex1() {
		return (JunVertex) getTopologicalElement_(this.vertexProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void vertex1_(JunTopologicalElementOrProxy aJunVertexOrProxy) {
		this.vertexProxy1 = (JunVertexProxy) this.getTopologicalElementProxy_advise_(aJunVertexOrProxy, this.vertexProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunVertex
	 */
	public JunVertex vertex2() {
		return (JunVertex) getTopologicalElement_(this.vertexProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void vertex2_(JunTopologicalElementOrProxy aJunVertexOrProxy) {
		this.vertexProxy2 = (JunVertexProxy) this.getTopologicalElementProxy_advise_(aJunVertexOrProxy, this.vertexProxy2);
	}
}
