package jp.co.sra.jun.topology.euleroperators;

import jp.co.sra.jun.topology.abstracts.*;

/*
 * @ (#) JunKEML.java 1.0 98/9/26
 */
import jp.co.sra.jun.topology.elements.*;
import jp.co.sra.smalltalk.*;

/**
 * JunKEML class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunKEML.java,v 8.10 2008/02/20 06:33:01 nisinaka Exp $
 */
public class JunKEML extends JunEulerOperator {
	protected JunEdgeProxy edgeProxy;
	protected JunLoopProxy loopProxy1;
	protected JunLoopProxy loopProxy2;
	protected JunVertexProxy vertexProxy1;
	protected JunVertexProxy vertexProxy2;
	protected JunEdgeProxy edgeProxy2;
	protected JunEdgeProxy edgeProxy3;

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunKEML
	 */
	public static JunKEML Body_edge_(JunBody aBody, JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		return Body_edge_adviseLoop_vertex_vertex_edge_edge_(aBody, aJunEdgeOrProxy, null, null, null, null, null);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunLoopOrProxy1
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunVertexOrProxy1
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunVertexOrProxy2
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunEdgeOrProxy2
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunEdgeOrProxy3
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunKEML
	 */
	public static final JunKEML Body_edge_adviseLoop_vertex_vertex_edge_edge_(
		JunBody aJunBody,
		JunTopologicalElementOrProxy aJunEdgeOrProxy,
		JunTopologicalElementOrProxy aJunLoopOrProxy1,
		JunTopologicalElementOrProxy aJunVertexOrProxy1,
		JunTopologicalElementOrProxy aJunVertexOrProxy2,
		JunTopologicalElementOrProxy aJunEdgeOrProxy2,
		JunTopologicalElementOrProxy aJunEdgeOrProxy3) {
		JunKEML anOperator;
		anOperator = new JunKEML();
		anOperator.body_(aJunBody);
		anOperator.edge_(aJunEdgeOrProxy);
		anOperator.edge2_(aJunEdgeOrProxy2);
		anOperator.edge3_(aJunEdgeOrProxy3);
		anOperator.loop1_(aJunLoopOrProxy1);
		anOperator.vertex1_(aJunVertexOrProxy1);
		anOperator.vertex2_(aJunVertexOrProxy2);

		return anOperator;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge edge() {
		return (JunEdge) this.getTopologicalElement_(this.edgeProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void edge_(JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		edgeProxy = (JunEdgeProxy) this.getTopologicalElementProxy_advise_(aJunEdgeOrProxy, this.edgeProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge edge2() {
		return (JunEdge) this.getTopologicalElement_(this.edgeProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void edge2_(JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		this.edgeProxy2 = (JunEdgeProxy) this.getTopologicalElementProxy_advise_(aJunEdgeOrProxy, this.edgeProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge edge3() {
		return (JunEdge) this.getTopologicalElement_(this.edgeProxy3);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void edge3_(JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		this.edgeProxy3 = (JunEdgeProxy) this.getTopologicalElementProxy_advise_(aJunEdgeOrProxy, this.edgeProxy3);
	}

	/**
	 * Execute the operation.
	 */
	public void execute() {
		if (this.vertex1() == null) {
			this.vertex1_(this.edge().startVertex());
		}

		if (this.vertex2() == null) {
			this.vertex2_(this.edge().endVertex());
		}

		this.loop2_(this.edge().leftLoop());

		JunEdge fromEdge1;

		if (this.edge2() == null) {
			fromEdge1 = this.edge().prevEdgeWithVertex_(this.vertex1());
			this.edge2_(fromEdge1);
		} else {
			fromEdge1 = this.edge2();
		}

		JunEdge toEdge1 = this.edge().nextEdgeWithVertex_(this.vertex1());
		JunEdge fromEdge2;

		if (this.edge3() == null) {
			fromEdge2 = this.edge().prevEdgeWithVertex_(this.vertex2());
			this.edge3_(fromEdge2);
		} else {
			fromEdge2 = this.edge3();
		}

		JunEdge toEdge2 = this.edge().nextEdgeWithVertex_(this.vertex2());
		this.loop1_(JunLoop.Edge_(toEdge1));
		this.loop2().edge_(toEdge2);
		fromEdge1.setNextEdge_withVertex_(toEdge1, this.vertex1());
		fromEdge2.setNextEdge_withVertex_(toEdge2, this.vertex2());

		final JunKEML self = this;
		fromEdge1.directionVertex_vertexEdgeVertexDo_(this.vertex1(), new StBlockClosure() {
			public Object value_value_value_(Object v1, Object e, Object v2) {
				((JunEdge) e).setLoop_toVertex_(self.loop1(), (JunVertex) v2);

				return null;
			}
		});

		if (this.vertex1().edge() == this.edge()) {
			this.vertex1().edge_(fromEdge1);
		}

		if (this.vertex2().edge() == this.edge()) {
			this.vertex2().edge_(fromEdge2);
		}

		this.edge().forget();
		this.body().removeEdge_(this.edge());
		this.body().addLoop_(this.loop1());
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunAbstractOperator
	 */
	public JunAbstractOperator inverse() {
		return (JunAbstractOperator) (JunMEKL.Body_loop_loop_vertex_vertex_adviseEdge_edge_edge_(this.body(), this.loopProxy1, this.loopProxy2, this.vertexProxy1, this.vertexProxy2, this.edgeProxy, this.edgeProxy2, this.edgeProxy3));
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge killedEdge() {
		return this.edge();
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunLoop
	 */
	public JunLoop loop1() {
		return (JunLoop) this.getTopologicalElement_(this.loopProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunLoopOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void loop1_(JunTopologicalElementOrProxy aJunLoopOrProxy) {
		loopProxy1 = (JunLoopProxy) this.getTopologicalElementProxy_advise_(aJunLoopOrProxy, this.loopProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunLoop
	 */
	public JunLoop loop2() {
		return (JunLoop) this.getTopologicalElement_(this.loopProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunLoopOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void loop2_(JunTopologicalElementOrProxy aJunLoopOrProxy) {
		loopProxy2 = (JunLoopProxy) this.getTopologicalElementProxy_advise_(aJunLoopOrProxy, this.loopProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunLoop
	 */
	public JunLoop newLoop() {
		return this.loop1();
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunLoop
	 */
	public JunLoop originalLoop() {
		return this.loop2();
	}

	/**
	 * Answer true if the pre-condition is valid.
	 * 
	 * @return boolean
	 */
	public boolean precondition() {
		if (super.precondition() == false) {
			return false;
		}

		JunEdge edge = this.edge();

		if (edge == null) {
			return false;
		}

		if (this.loop1() != null) {
			return false;
		}

		if (edge.leftLoop() != edge.rightLoop()) {
			return false;
		}

		return true;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunVertex
	 */
	public JunVertex vertex1() {
		return (JunVertex) this.getTopologicalElement_(this.vertexProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void vertex1_(JunTopologicalElementOrProxy aJunVertexOrProxy) {
		this.vertexProxy1 = (JunVertexProxy) this.getTopologicalElementProxy_advise_(aJunVertexOrProxy, this.vertexProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunVertex
	 */
	public JunVertex vertex2() {
		return (JunVertex) this.getTopologicalElement_(this.vertexProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void vertex2_(JunTopologicalElementOrProxy aJunVertexOrProxy) {
		this.vertexProxy2 = (JunVertexProxy) this.getTopologicalElementProxy_advise_(aJunVertexOrProxy, this.vertexProxy2);
	}
}
