package jp.co.sra.jun.topology.euleroperators;

import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.system.support.*;
import jp.co.sra.jun.topology.elements.*;

/**
 * JunKEVTestExamples class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunKEVTestExamples.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunKEVTestExamples extends JunTestExamples {

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static boolean example1() {
		JunMEVVL mevvl;
		JunMEV mev;
		int i;

		mevvl = JunMEVVL.Body_point_point_(new JunBody(), new Jun3dPoint(0, 0, 0), new Jun3dPoint(1, 0, 0));
		mevvl.doOperation();

		mev = JunMEV.Body_vertex_loop_point_(mevvl.body(), mevvl.vertex2(), mevvl.loop(), new Jun3dPoint(0, 1, 0));
		mev.doOperation();

		for (i = 0; i < 10; i++) {
			mev.undoOperation();
			mev.doOperation();
		}

		mev.body().show();

		//	return mev;
		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static boolean example2() {
		/*        "JunKEV example2."
		*
		*        | mevvl mel mev1 mev2 |
		*        mevvl := JunMEVVL
		*                                body: JunBody new
		*                                point: 0 , 0 , 0
		*                                point: 1 , 0 , 0.
		*        mevvl do.
		*        mel := JunMEL
		*                                body: mevvl body
		*                                loop: mevvl loop
		*                                vertex: mevvl vertex1
		*                                vertex: mevvl vertex2.
		*        mel do.
		*        mev1 := JunMEV
		*                                 body: mevvl body
		*                                vertex: mevvl vertex1
		*                                loop: mel loop1
		*                                point: 0 , 1 , 0.
		*        mev1 do.
		*        mev2 := JunMEV
		*                                body: mevvl body
		*                                vertex: mevvl vertex2
		*                                loop: mel loop2
		*                                point: 0 , 0 , 1.
		*        mev2 do.
		*
		*        10 timesRepeat:
		*                        [mev2 undo.
		*                        mev1 undo.
		*                        mev1 do.
		*                        mev2 do].
		*        ^mev2! !
		*/
		JunMEVVL mevvl;
		JunMEL mel;
		JunMEV mev1;
		JunMEV mev2;
		int i;
		mevvl = JunMEVVL.Body_point_point_(new JunBody(), new Jun3dPoint(0, 0, 0), new Jun3dPoint(1, 0, 0));
		mevvl.doOperation();

		mel = JunMEL.Body_loop_vertex_vertex_(mevvl.body(), mevvl.loop(), mevvl.vertex1(), mevvl.vertex2());
		mel.doOperation();

		mev1 = JunMEV.Body_vertex_loop_point_(mevvl.body(), mevvl.vertex1(), mel.loop1(), new Jun3dPoint(0, 1, 0));
		mev1.doOperation();

		mev2 = JunMEV.Body_vertex_loop_point_(mevvl.body(), mevvl.vertex2(), mel.loop2(), new Jun3dPoint(0, 0, 1));
		mev2.doOperation();

		for (i = 0; i < 10; i++) {
			mev2.undoOperation();
			mev1.undoOperation();
			mev1.doOperation();
			mev2.doOperation();
		}

		mev2.body().show();

		//	return mev2;
		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunKEVTestExamples();
	}
}
