package jp.co.sra.jun.topology.geometricoperators;

/*
 * @(#)JunMCV.java        1.0 98/9/17
 */
import jp.co.sra.jun.geometry.abstracts.JunCurve;
import jp.co.sra.jun.topology.abstracts.*;
import jp.co.sra.jun.topology.elements.*;

/**
 * JunMCV class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMCV.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunMCV extends JunGeometricOperator {
	protected JunEdgeProxy edgeProxy;
	protected JunCurve curve;

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 * @param anEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aCurve jp.co.sra.jun.geometry.abstracts.JunCurve
	 * 
	 * @return jp.co.sra.jun.topology.geometricoperators.JunMCV
	 */
	public static final JunMCV Body_edge_curve_(JunBody aBody, JunTopologicalElementOrProxy anEdgeOrProxy, JunCurve aCurve) {
		JunMCV anOperator = new JunMCV();
		anOperator.body_(aBody);
		anOperator.edge_(anEdgeOrProxy);
		anOperator.curve_(aCurve);

		return anOperator;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.geometry.curves.JunCurve
	 */
	public JunCurve curve() {
		return curve;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aCurve jp.co.sra.jun.geometry.abstracts.JunCurve
	 */
	public void curve_(JunCurve aCurve) {
		curve = aCurve;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge edge() {
		return (JunEdge) this.getTopologicalElement_(edgeProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param anEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void edge_(JunTopologicalElementOrProxy anEdgeOrProxy) {
		edgeProxy = (JunEdgeProxy) this.getTopologicalElementProxy_advise_(anEdgeOrProxy, edgeProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public void execute() {
		this.edge().curve_(this.curve());
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunAbstractOperator
	 */
	public JunAbstractOperator inverse() {
		return JunKCV.Body_edge_(this.body(), edgeProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return boolean
	 */
	public boolean precondition() {
		JunEdge edge = this.edge();

		if (edge == null) {
			return false;
		}

		if (edge.basicCurve() != null) {
			return false;
		}

		return super.precondition();
	}
}
