package jp.co.sra.jun.topology.globaloperators;

import jp.co.sra.jun.topology.abstracts.*;
import jp.co.sra.jun.topology.elements.*;
import jp.co.sra.smalltalk.StBlockClosure;

/**
 * JunADD class
 * 
 *  @author    nisinaka
 *  @created   1998/11/06 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunADD.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunADD extends JunGlobalOperator {
	/** Another body to add. */
	protected JunBody body2 = null;

	/**
	 * Create a new instance of JunADD and initialize it with two bodies.
	 * 
	 * @param aBody1 jp.co.sra.jun.topology.elements.JunBody
	 * @param aBody2 jp.co.sra.jun.topology.elements.JunBody
	 */
	public JunADD(JunBody aBody1, JunBody aBody2) {
		this.body_(aBody1);
		this.body2_(aBody2);
	}

	/**
	 * Create an JunADD operator with two bodies.
	 * 
	 * @param aBody1 jp.co.sra.jun.topology.elements.JunBody
	 * @param aBody2 jp.co.sra.jun.topology.elements.JunBody
	 * 
	 * @return jp.co.sra.jun.topology.globaloperators.JunADD
	 */
	public static final JunADD Body_body_(JunBody aBody1, JunBody aBody2) {
		return new JunADD(aBody1, aBody2);
	}

	/**
	 * Answer another body.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunBody
	 */
	public final JunBody body2() {
		return body2;
	}

	/**
	 * Set another body.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 */
	public final void body2_(JunBody aBody) {
		body2 = aBody;
	}

	/**
	 * Execute the receiver.
	 */
	public void execute() {
		final JunBody body_ = this.body();
		body2.proxiesAndLoopsDo_(new StBlockClosure() {
			public Object value_value_(Object proxy, Object loop) {
				return body_.addLoop_as_((JunLoop) loop, (JunLoopProxy) proxy);
			}
		});
		body2.proxiesAndEdgesDo_(new StBlockClosure() {
			public Object value_value_(Object proxy, Object edge) {
				return body_.addEdge_as_((JunEdge) edge, (JunEdgeProxy) proxy);
			}
		});
		body2.proxiesAndVertexesDo_(new StBlockClosure() {
			public Object value_value_(Object proxy, Object vertex) {
				return body_.addVertex_as_((JunVertex) vertex, (JunVertexProxy) proxy);
			}
		});
	}

	/**
	 * Answer the inverse operator of the receiver.
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunAbstractOperator
	 */
	public JunAbstractOperator inverse() {
		return new JunSEPARATE(this.body(), this.body2());
	}
}
