package jp.co.sra.jun.topology.globaloperators;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.topology.elements.JunBody;

/**
 * JunLineSCALETestExamples class
 * 
 *  @author    UNKNOWN
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunLineSCALETestExamples.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunLineSCALETestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static boolean Example1() {
		JunBody body;
		JunLineSCALE scale;
		Jun3dPoint point1 = new Jun3dPoint(0, 0, 0);
		Jun3dPoint point2 = new Jun3dPoint(1, 0, 0);
		Jun3dPoint point3 = new Jun3dPoint(0, 1, 0);
		Jun3dPoint point4 = new Jun3dPoint(0, 0, 1);
		Jun3dPoint vector = new Jun3dPoint(1, 0, 0);
		Jun3dPoint[] a3dPoint = new Jun3dPoint[4];
		a3dPoint[0] = point1;
		a3dPoint[1] = point2;
		a3dPoint[2] = point3;
		a3dPoint[3] = point4;
		body = JunBody.Tetrahedron_(a3dPoint);
		body.show();
		scale = JunLineSCALE.Body_point_vector_factor_(body, point1, vector, 0.5d);
		scale.doOperation();
		scale.body().show();

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static boolean Example2() {
		JunBody body;
		JunLineSCALE scale;
		Jun3dPoint point1 = new Jun3dPoint(0, 0, 0);
		Jun3dPoint point2 = new Jun3dPoint(1, 0, 0);
		Jun3dPoint point3 = new Jun3dPoint(0, 1, 0);
		Jun3dPoint point4 = new Jun3dPoint(0, 0, 1);
		Jun3dPoint vector = new Jun3dPoint(1, 0, 0);
		Jun3dPoint[] a3dPoint = new Jun3dPoint[4];
		a3dPoint[0] = point1;
		a3dPoint[1] = point2;
		a3dPoint[2] = point3;
		a3dPoint[3] = point4;
		body = JunBody.Tetrahedron_(a3dPoint);
		scale = JunLineSCALE.Body_point_vector_factor_(body, point1, vector, 2.0d);
		body.show();
		scale.doOperation();
		body.show();
		scale.inverse().doOperation();
		body.show();

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static boolean Example3() {
		System.out.println("\nJunLineSCALETestExamples Example3");

		JunBody body;
		JunLineSCALE scale;
		Jun3dPoint point1 = new Jun3dPoint(10, 10, 10);
		Jun3dPoint point2 = new Jun3dPoint(11, 10, 10);
		Jun3dPoint point3 = new Jun3dPoint(10, 11, 10);
		Jun3dPoint point4 = new Jun3dPoint(10, 10, 11);
		Jun3dPoint vector = new Jun3dPoint(1, 0, 0);
		Jun3dPoint[] a3dPoint = new Jun3dPoint[4];
		a3dPoint[0] = point1;
		a3dPoint[1] = point2;
		a3dPoint[2] = point3;
		a3dPoint[3] = point4;
		body = JunBody.Tetrahedron_(a3dPoint);
		scale = JunLineSCALE.Body_point_vector_factor_(body, point1, vector, 2.0d);
		body.show();
		scale.doOperation();
		body.show();
		scale.inverse().doOperation();
		body.show();
		System.out.println("-------- #vertexes");
		System.out.println(body.vertexes());

		//   ?? body.vertexes() does not work, just shows class name
		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 */
	public static void main(java.lang.String[] args) {
		new JunLineSCALETestExamples();
	}
}
