package jp.co.sra.jun.topology.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;

import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StBlockValue;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.WindowSpecLayout;

/**
 * JunElementalGraphSettingsViewSwing class
 * 
 *  @author    nisinaka
 *  @created   2006/04/20 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun593 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunElementalGraphSettingsViewSwing.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunElementalGraphSettingsViewSwing extends JunElementalStuffSettingsViewSwing implements JunElementalGraphSettingsView {

	protected JTextField labelStringField;
	protected JButton selectionBorderColorButton;
	protected JSlider selectionBorderWidthSlider;
	protected JRadioButton arrangeNoneButton;
	protected JRadioButton arrangeForestButton;
	protected JSlider arrangeForestIntervalSlider;
	protected JSlider arrangeForestMarginSlider;
	protected JRadioButton arrangeConcentricButton;
	protected JSlider arrangeConcentricRadiusSlider;
	protected JSlider arrangeConcentricSpiralSlider;
	protected JRadioButton arrangeConcentricGradationOnButton;
	protected JRadioButton arrangeConcentricGradationOffButton;
	protected JTextField arrangeAttributeSymbolField;
	protected JButton allDefaultsButton;

	private HashMap _blockValues;
	private ButtonGroup _arrangeFormatButtonGroup;
	private ButtonGroup _arrangeConcentricGradationButtonGroup;

	/**
	 * Create a new instance of JunElementalGraphSettingsViewSwing and initialize it.
	 *
	 * @param anElementalGraphSettings jp.co.sra.jun.topology.graph.JunElementalGraphSettings
	 * @category Instance creation
	 */
	public JunElementalGraphSettingsViewSwing(JunElementalGraphSettings anElementalGraphSettings) {
		super(anElementalGraphSettings);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		_blockValues = new HashMap();
		_arrangeFormatButtonGroup = new ButtonGroup();
		_arrangeConcentricGradationButtonGroup = new ButtonGroup();
	}

	/**
	 * Build the component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(new JLabel($String("Label") + " :"), WindowSpecLayout.Position(0f, 16, 0f, 16));
		this.add(this.labelStringField(), WindowSpecLayout.Position(0f, 88, 0f, 16, 0f, 248, 0f, 40));
		this.add(new JLabel($String("Selection Border Color") + " :"), WindowSpecLayout.Position(0f, 16, 0f, 48));
		this.add(this.selectionBorderColorButton(), WindowSpecLayout.Position(0f, 168, 0f, 48, 0f, 248, 0f, 72));
		this.add(new JLabel($String("Selection Border Width") + " :"), WindowSpecLayout.Position(0f, 16, 0f, 80));
		this.add(this.selectionBorderWidthSlider(), WindowSpecLayout.Position(0f, 168, 0f, 80, 0f, 248, 0f, 104));
		this.add(new JLabel($String("Arrange Format") + " :"), WindowSpecLayout.Position(0f, 16, 0f, 112));
		this.add(this.arrangeNoneButton(), WindowSpecLayout.Position(0f, 24, 0f, 144));
		this.add(this.arrangeForestButton(), WindowSpecLayout.Position(0f, 24, 0f, 176));
		this.add(new JLabel($String("Interval") + " :"), WindowSpecLayout.Position(0f, 48, 0f, 208));
		this.add(this.arrangeForestIntervalSlider(), WindowSpecLayout.Position(0f, 144, 0f, 208, 0f, 248, 0f, 232));
		this.add(new JLabel($String("Margin") + " :"), WindowSpecLayout.Position(0f, 48, 0f, 240));
		this.add(this.arrangeForestMarginSlider(), WindowSpecLayout.Position(0f, 168, 0f, 240, 0f, 248, 0f, 264));
		this.add(this.arrangeConcentricButton(), WindowSpecLayout.Position(0f, 24, 0f, 272));
		this.add(new JLabel($String("Radius") + " :"), WindowSpecLayout.Position(0f, 48, 0f, 304));
		this.add(this.arrangeConcentricRadiusSlider(), WindowSpecLayout.Position(0f, 144, 0f, 304, 0f, 248, 0f, 328));
		this.add(new JLabel($String("Spiral") + " :"), WindowSpecLayout.Position(0f, 48, 0f, 336));
		this.add(this.arrangeConcentricSpiralSlider(), WindowSpecLayout.Position(0f, 168, 0f, 336, 0f, 248, 0f, 360));
		this.add(new JLabel($String("Gradation") + " :"), WindowSpecLayout.Position(0f, 48, 0f, 368));
		this.add(this.arrangeConcentricGradationOnButton(), WindowSpecLayout.Position(0f, 152, 0f, 368));
		this.add(this.arrangeConcentricGradationOffButton(), WindowSpecLayout.Position(0f, 200, 0f, 368));
		this.add(new JLabel($String("Attribute") + " :"), WindowSpecLayout.Position(0f, 48, 0f, 400));
		this.add(this.arrangeAttributeSymbolField(), WindowSpecLayout.Position(0f, 144, 0f, 400, 0f, 248, 0f, 424));
		this.add(this.allDefaultsButton(), WindowSpecLayout.Position(0.5f, -52, 0f, 440, 0.5f, 52, 0f, 464));
		this.setPreferredSize(DefaultBounds.getSize());
	}

	/**
	 * Answer my model as JunElementalGraphSettings.
	 * 
	 * @return jp.co.sra.jun.topology.graph.JunElementalGraphSettings
	 * @see jp.co.sra.jun.topology.graph.JunElementalGraphSettingsView#getElementalGraphSettings()
	 * @category model accessing
	 */
	public JunElementalGraphSettings getElementalGraphSettings() {
		return (JunElementalGraphSettings) this.model();
	}

	/**
	 * Answer the label string field.
	 * 
	 * @return javax.swing.JTextField
	 * @category user interface
	 */
	protected JTextField labelStringField() {
		if (labelStringField == null) {
			labelStringField = new JTextField() {
				public void removeNotify() {
					((StBlockValue) _blockValues.get(labelStringField)).release();
					super.removeNotify();
				}

			};
			labelStringField.getDocument().addDocumentListener(new DocumentListener() {
				public void insertUpdate(DocumentEvent e) {
					getElementalGraphSettings().labelStringHolder().value_(labelStringField.getText());
				}

				public void removeUpdate(DocumentEvent e) {
					getElementalGraphSettings().labelStringHolder().value_(labelStringField.getText());
				}

				public void changedUpdate(DocumentEvent e) {
					// nothing to do
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					String aString = (String) anObject;
					if (labelStringField.getText().equals(aString) == false) {
						labelStringField.setText(aString);
					}
					return null;
				}
			};
			StBlockValue blockValue = this.getElementalGraphSettings().labelStringHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(labelStringField, blockValue);
		}
		return labelStringField;
	}

	/**
	 * Answer the selection border color button.
	 * 
	 * @return javax.swing.JButton
	 * @category user interface
	 */
	protected JButton selectionBorderColorButton() {
		if (selectionBorderColorButton == null) {
			selectionBorderColorButton = new JButton() {
				public void paint(Graphics g) {
					super.paint(g);

					Dimension size = this.getSize();
					int x = (size.width - ButtonColorImageSize.width) / 2;
					int y = (size.height - ButtonColorImageSize.height) / 2;
					g.setColor((Color) getElementalGraphSettings().selectionBorderColorHolder().value());
					g.fillRect(x, y, ButtonColorImageSize.width, ButtonColorImageSize.height);
				}

				public void removeNotify() {
					((StBlockValue) _blockValues.get(selectionBorderColorButton)).release();
					super.removeNotify();
				}
			};
			selectionBorderColorButton.setAction(new AbstractAction() {
				public void actionPerformed(ActionEvent e) {
					getElementalGraphSettings().selectionBorderColorButtonPressed();
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					selectionBorderColorButton.repaint();
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalGraphSettings().selectionBorderColorHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(selectionBorderColorButton, blockValue);
		}
		return selectionBorderColorButton;
	}

	/**
	 * Answer the selection border width slider.
	 * 
	 * @return javax.swing.JSlider
	 * @category user interface
	 */
	protected JSlider selectionBorderWidthSlider() {
		if (selectionBorderWidthSlider == null) {
			selectionBorderWidthSlider = new JSlider(JSlider.HORIZONTAL, 1, 5, 1) {
				public void removeNotify() {
					((StBlockValue) _blockValues.get(selectionBorderWidthSlider)).release();
					super.removeNotify();
				}
			};
			selectionBorderWidthSlider.setMajorTickSpacing(1);
			selectionBorderWidthSlider.setPaintTicks(true);
			selectionBorderWidthSlider.setSnapToTicks(true);
			selectionBorderWidthSlider.addChangeListener(new ChangeListener() {
				public void stateChanged(ChangeEvent e) {
					int value = selectionBorderWidthSlider.getValue();
					getElementalGraphSettings().selectionBorderWidthHolder().value_(new Integer(value));
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					int value = ((Number) anObject).intValue();
					if (value != selectionBorderWidthSlider.getValue()) {
						selectionBorderWidthSlider.setValue(value);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalGraphSettings().selectionBorderWidthHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(selectionBorderWidthSlider, blockValue);
		}
		return selectionBorderWidthSlider;
	}

	/**
	 * Answer the arrange none button.
	 * 
	 * @return javax.swing.JRadioButton
	 * @category user interface
	 */
	protected JRadioButton arrangeNoneButton() {
		if (arrangeNoneButton == null) {
			arrangeNoneButton = new JRadioButton($String("None"));
			arrangeNoneButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalGraphSettings().arrangeFormatHolder().value_($("none"));
				}
			});
			_arrangeFormatButtonGroup.add(arrangeNoneButton);

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("none") && arrangeNoneButton.isSelected() == false) {
						arrangeNoneButton.setSelected(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalGraphSettings().arrangeFormatHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(arrangeNoneButton, blockValue);
		}
		return arrangeNoneButton;
	}

	/**
	 * Answer the arrange forest button.
	 * 
	 * @return javax.swing.JRadioButton
	 * @category user interface
	 */
	protected JRadioButton arrangeForestButton() {
		if (arrangeForestButton == null) {
			arrangeForestButton = new JRadioButton($String("Forest"));
			arrangeForestButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalGraphSettings().arrangeFormatHolder().value_($("forest"));
				}
			});
			_arrangeFormatButtonGroup.add(arrangeForestButton);

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("forest") && arrangeForestButton.isSelected() == false) {
						arrangeForestButton.setSelected(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalGraphSettings().arrangeFormatHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(arrangeForestButton, blockValue);
		}
		return arrangeForestButton;
	}

	/**
	 * Answer the arrange forest interval slider.
	 * 
	 * @return javax.swing.JSlider
	 * @category user interface
	 */
	protected JSlider arrangeForestIntervalSlider() {
		if (arrangeForestIntervalSlider == null) {
			arrangeForestIntervalSlider = new JSlider(JSlider.HORIZONTAL, 0 / 5, 250 / 5, 0 / 5) {
				public void removeNotify() {
					((StBlockValue) _blockValues.get(arrangeForestIntervalSlider)).release();
					super.removeNotify();
				}
			};
			arrangeForestIntervalSlider.setMajorTickSpacing(1);
			arrangeForestIntervalSlider.setPaintTicks(true);
			arrangeForestIntervalSlider.setSnapToTicks(true);
			arrangeForestIntervalSlider.addChangeListener(new ChangeListener() {
				public void stateChanged(ChangeEvent e) {
					int value = arrangeForestIntervalSlider.getValue();
					getElementalGraphSettings().arrangeForestIntervalHolder().value_(new Integer(value * 5));
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					int value = ((Number) anObject).intValue() / 5;
					if (value != arrangeForestIntervalSlider.getValue()) {
						arrangeForestIntervalSlider.setValue(value);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalGraphSettings().arrangeForestIntervalHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(arrangeForestIntervalSlider, blockValue);
		}
		return arrangeForestIntervalSlider;
	}

	/**
	 * Answer the arrange forest margin slider.
	 * 
	 * @return javax.swing.JSlider
	 * @category user interface
	 */
	protected JSlider arrangeForestMarginSlider() {
		if (arrangeForestMarginSlider == null) {
			arrangeForestMarginSlider = new JSlider(JSlider.HORIZONTAL, 0, 75, 0) {
				public void removeNotify() {
					((StBlockValue) _blockValues.get(arrangeForestMarginSlider)).release();
					super.removeNotify();
				}
			};
			arrangeForestMarginSlider.setMajorTickSpacing(1);
			arrangeForestMarginSlider.setPaintTicks(true);
			arrangeForestMarginSlider.setSnapToTicks(true);
			arrangeForestMarginSlider.addChangeListener(new ChangeListener() {
				public void stateChanged(ChangeEvent e) {
					int value = arrangeForestMarginSlider.getValue();
					getElementalGraphSettings().arrangeForestMarginHolder().value_(new Integer(value));
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					int value = ((Number) anObject).intValue();
					if (value != arrangeForestMarginSlider.getValue()) {
						arrangeForestMarginSlider.setValue(value);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalGraphSettings().arrangeForestMarginHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(arrangeForestMarginSlider, blockValue);
		}
		return arrangeForestMarginSlider;
	}

	/**
	 * Answer the arrange concentric button.
	 * 
	 * @return javax.swing.JRadioButton
	 * @category user interface
	 */
	protected JRadioButton arrangeConcentricButton() {
		if (arrangeConcentricButton == null) {
			arrangeConcentricButton = new JRadioButton($String("Concentric"));
			arrangeConcentricButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalGraphSettings().arrangeFormatHolder().value_($("concentric"));
				}
			});
			_arrangeFormatButtonGroup.add(arrangeConcentricButton);

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("concentric") && arrangeConcentricButton.isSelected() == false) {
						arrangeConcentricButton.setSelected(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalGraphSettings().arrangeFormatHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(arrangeConcentricButton, blockValue);
		}
		return arrangeConcentricButton;
	}

	/**
	 * Answer the arrange concentric radius slider.
	 * 
	 * @return javax.swing.JSlider
	 * @category user interface
	 */
	protected JSlider arrangeConcentricRadiusSlider() {
		if (arrangeConcentricRadiusSlider == null) {
			arrangeConcentricRadiusSlider = new JSlider(JSlider.HORIZONTAL, 100 / 20, 1000 / 20, 100 / 20) {
				public void removeNotify() {
					((StBlockValue) _blockValues.get(arrangeConcentricRadiusSlider)).release();
					super.removeNotify();
				}
			};
			arrangeConcentricRadiusSlider.setMajorTickSpacing(1);
			arrangeConcentricRadiusSlider.setPaintTicks(true);
			arrangeConcentricRadiusSlider.setSnapToTicks(true);
			arrangeConcentricRadiusSlider.addChangeListener(new ChangeListener() {
				public void stateChanged(ChangeEvent e) {
					int value = arrangeConcentricRadiusSlider.getValue();
					getElementalGraphSettings().arrangeConcentricRadiusHolder().value_(new Integer(value * 20));
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					int value = ((Number) anObject).intValue() / 20;
					if (value != arrangeConcentricRadiusSlider.getValue()) {
						arrangeConcentricRadiusSlider.setValue(value);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalGraphSettings().arrangeConcentricRadiusHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(arrangeConcentricRadiusSlider, blockValue);
		}
		return arrangeConcentricRadiusSlider;
	}

	/**
	 * Answer the arrange concentric spiral slider.
	 * 
	 * @return javax.swing.JSlider
	 * @category user interface
	 */
	protected JSlider arrangeConcentricSpiralSlider() {
		if (arrangeConcentricSpiralSlider == null) {
			arrangeConcentricSpiralSlider = new JSlider(JSlider.HORIZONTAL, 1 * 4, 10 * 4, 1 * 4) {
				public void removeNotify() {
					((StBlockValue) _blockValues.get(arrangeConcentricSpiralSlider)).release();
					super.removeNotify();
				}
			};
			arrangeConcentricSpiralSlider.setMajorTickSpacing(1);
			arrangeConcentricSpiralSlider.setPaintTicks(true);
			arrangeConcentricSpiralSlider.setSnapToTicks(true);
			arrangeConcentricSpiralSlider.addChangeListener(new ChangeListener() {
				public void stateChanged(ChangeEvent e) {
					int value = arrangeConcentricSpiralSlider.getValue();
					getElementalGraphSettings().arrangeConcentricSpiralHolder().value_(new Float(value / 4.0f));
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					int value = (int) (((Number) anObject).floatValue() * 4);
					if (value != arrangeConcentricSpiralSlider.getValue()) {
						arrangeConcentricSpiralSlider.setValue(value);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalGraphSettings().arrangeConcentricSpiralHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(arrangeConcentricSpiralSlider, blockValue);
		}
		return arrangeConcentricSpiralSlider;
	}

	/**
	 * Answer the arrange concentric gradation on button.
	 * 
	 * @return javax.swing.JRadioButton
	 * @category user interface
	 */
	protected JRadioButton arrangeConcentricGradationOnButton() {
		if (arrangeConcentricGradationOnButton == null) {
			arrangeConcentricGradationOnButton = new JRadioButton("on");
			arrangeConcentricGradationOnButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalGraphSettings().arrangeConcentricGradationHolder().value_(Boolean.TRUE);
				}
			});
			_arrangeConcentricGradationButtonGroup.add(arrangeConcentricGradationOnButton);

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == Boolean.TRUE && arrangeConcentricGradationOnButton.isSelected() == false) {
						arrangeConcentricGradationOnButton.setSelected(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalGraphSettings().arrangeConcentricGradationHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(arrangeConcentricGradationOnButton, blockValue);

		}
		return arrangeConcentricGradationOnButton;
	}

	/**
	 * Answer the arrange concentric gradation off button.
	 * 
	 * @return javax.swing.JRadioButton
	 * @category user interface
	 */
	protected JRadioButton arrangeConcentricGradationOffButton() {
		if (arrangeConcentricGradationOffButton == null) {
			arrangeConcentricGradationOffButton = new JRadioButton("off");
			arrangeConcentricGradationOffButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalGraphSettings().arrangeConcentricGradationHolder().value_(Boolean.FALSE);
				}
			});
			_arrangeConcentricGradationButtonGroup.add(arrangeConcentricGradationOffButton);

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == Boolean.FALSE && arrangeConcentricGradationOffButton.isSelected() == false) {
						arrangeConcentricGradationOffButton.setSelected(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalGraphSettings().arrangeConcentricGradationHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(arrangeConcentricGradationOffButton, blockValue);
		}
		return arrangeConcentricGradationOffButton;
	}

	/**
	 * Answer the arrange attribute symbol field.
	 * 
	 * @return javax.swing.JTextField
	 * @category user interface
	 */
	protected JTextField arrangeAttributeSymbolField() {
		if (arrangeAttributeSymbolField == null) {
			arrangeAttributeSymbolField = new JTextField() {
				public void removeNotify() {
					((StBlockValue) _blockValues.get(arrangeAttributeSymbolField)).release();
					super.removeNotify();
				}

			};
			arrangeAttributeSymbolField.getDocument().addDocumentListener(new DocumentListener() {
				public void insertUpdate(DocumentEvent e) {
					getElementalGraphSettings().arrangeAttributeSymbolHolder().value_($(arrangeAttributeSymbolField.getText()));
				}

				public void removeUpdate(DocumentEvent e) {
					getElementalGraphSettings().arrangeAttributeSymbolHolder().value_($(arrangeAttributeSymbolField.getText()));
				}

				public void changedUpdate(DocumentEvent e) {
					// nothing to do
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					String aString = ((StSymbol) anObject).toString();
					if (arrangeAttributeSymbolField.getText().equals(aString) == false) {
						arrangeAttributeSymbolField.setText(aString);
					}
					return null;
				}
			};
			StBlockValue blockValue = this.getElementalGraphSettings().arrangeAttributeSymbolHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(arrangeAttributeSymbolField, blockValue);
		}
		return arrangeAttributeSymbolField;
	}

	/**
	 * Answer the all defaults button.
	 * 
	 * @return javax.swing.JButton
	 * @category user interface
	 */
	protected JButton allDefaultsButton() {
		if (allDefaultsButton == null) {
			allDefaultsButton = new JButton(new AbstractAction($String("Default")) {
				public void actionPerformed(ActionEvent e) {
					getElementalGraphSettings().defaultButtonPressed();
				}
			});
		}
		return allDefaultsButton;
	}

	/**
	 * Update for the change notice from the model.
	 * 
	 * @param e jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.DependentListener#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent e) {
		if (e.getAspect() == $("widgets")) {
			Iterator i = _blockValues.values().iterator();
			while (i.hasNext()) {
				((StBlockValue) i.next()).computeValue();
			}

			if (this.arrangeForestButton().isSelected()) {
				this.arrangeForestIntervalSlider().setVisible(true);
				this.arrangeForestMarginSlider().setVisible(true);
				this.arrangeConcentricRadiusSlider().setVisible(false);
				this.arrangeConcentricSpiralSlider().setVisible(false);
				this.arrangeConcentricGradationOnButton().setVisible(false);
				this.arrangeConcentricGradationOffButton().setVisible(false);
				this.arrangeAttributeSymbolField().setVisible(false);
			} else if (this.arrangeConcentricButton().isSelected()) {
				this.arrangeForestIntervalSlider().setVisible(false);
				this.arrangeForestMarginSlider().setVisible(false);
				this.arrangeConcentricRadiusSlider().setVisible(true);
				this.arrangeConcentricSpiralSlider().setVisible(true);
				this.arrangeConcentricGradationOnButton().setVisible(true);
				this.arrangeConcentricGradationOffButton().setVisible(true);
				this.arrangeAttributeSymbolField().setVisible(true);
			} else {
				this.arrangeForestIntervalSlider().setVisible(false);
				this.arrangeForestMarginSlider().setVisible(false);
				this.arrangeConcentricRadiusSlider().setVisible(false);
				this.arrangeConcentricSpiralSlider().setVisible(false);
				this.arrangeConcentricGradationOnButton().setVisible(false);
				this.arrangeConcentricGradationOffButton().setVisible(false);
				this.arrangeAttributeSymbolField().setVisible(false);
			}
		} else {
			super.update_(e);
		}
	}

}
