package jp.co.sra.jun.topology.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StBlockValue;
import jp.co.sra.smalltalk.WindowSpecLayout;

/**
 * JunElementalNodeSettingsViewSwing class
 * 
 *  @author    nisinaka
 *  @created   2006/04/17 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun593 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunElementalNodeSettingsViewSwing.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunElementalNodeSettingsViewSwing extends JunElementalStuffSettingsViewSwing implements JunElementalNodeSettingsView {

	protected JTextField labelStringField;
	protected JTextField xLocationStringField;
	protected JTextField yLocationStringField;
	protected JButton foregroundColorButton;
	protected JButton backgroundColorButton;
	protected JButton borderColorButton;
	protected JSlider borderWidthSlider;
	protected JButton allDefaultsButton;

	private HashMap _blockValues;

	/**
	 * Create a new instance of JunElementalNodeSettingsViewSwing and initialize it.
	 *
	 * @param anElementalNodeSettings
	 * @category Instance creation
	 */
	public JunElementalNodeSettingsViewSwing(JunElementalNodeSettings anElementalNodeSettings) {
		super(anElementalNodeSettings);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		_blockValues = new HashMap();
	}

	/**
	 * Build the component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(new JLabel($String("Label") + " :"), WindowSpecLayout.Position(0f, 16, 0f, 16));
		this.add(this.labelStringField(), WindowSpecLayout.Position(0f, 88, 0f, 16, 0f, 248, 0f, 40));
		this.add(new JLabel($String("Location") + " :"), WindowSpecLayout.Position(0f, 16, 0f, 48));
		this.add(new JLabel("x"), WindowSpecLayout.Position(0f, 96, 0f, 48));
		this.add(this.xLocationStringField(), WindowSpecLayout.Position(0f, 112, 0f, 48, 0f, 168, 0f, 72));
		this.add(new JLabel("y"), WindowSpecLayout.Position(0f, 176, 0f, 48));
		this.add(this.yLocationStringField(), WindowSpecLayout.Position(0f, 192, 0f, 48, 0f, 248, 0f, 72));
		this.add(new JLabel($String("Foreground Color") + " :"), WindowSpecLayout.Position(0f, 16, 0f, 80));
		this.add(this.foregroundColorButton(), WindowSpecLayout.Position(0f, 168, 0f, 80, 0f, 248, 0f, 104));
		this.add(new JLabel($String("Background Color") + " :"), WindowSpecLayout.Position(0f, 16, 0f, 112));
		this.add(this.backgroundColorButton(), WindowSpecLayout.Position(0f, 168, 0f, 112, 0f, 248, 0f, 136));
		this.add(new JLabel($String("Border Color") + " :"), WindowSpecLayout.Position(0f, 16, 0f, 144));
		this.add(this.borderColorButton(), WindowSpecLayout.Position(0f, 168, 0f, 144, 0f, 248, 0f, 168));
		this.add(new JLabel($String("Border Width") + " :"), WindowSpecLayout.Position(0f, 16, 0f, 176));
		this.add(this.borderWidthSlider(), WindowSpecLayout.Position(0f, 168, 0f, 176, 0f, 248, 0f, 200));
		this.add(this.allDefaultsButton(), WindowSpecLayout.Position(0.5f, -52, 0f, 216, 0.5f, 52, 0f, 240));
		this.setPreferredSize(DefaultBounds.getSize());
	}

	/**
	 * Answer my model as JunElementalNodeSettings.
	 * 
	 * @return jp.co.sra.jun.topology.graph.JunElementalNodeSettings
	 * @see jp.co.sra.jun.topology.graph.JunElementalNodeSettingsView#getElementalNodeSettings()
	 * @category model accessing
	 */
	public JunElementalNodeSettings getElementalNodeSettings() {
		return (JunElementalNodeSettings) this.model();
	}

	/**
	 * Answer the label string field.
	 * 
	 * @return javax.swing.JTextField
	 * @category user interface
	 */
	protected JTextField labelStringField() {
		if (labelStringField == null) {
			labelStringField = new JTextField() {
				public void removeNotify() {
					((StBlockValue) _blockValues.get(labelStringField)).release();
					super.removeNotify();
				}

			};
			labelStringField.getDocument().addDocumentListener(new DocumentListener() {
				public void insertUpdate(DocumentEvent e) {
					getElementalNodeSettings().labelStringHolder().value_(labelStringField.getText());
				}

				public void removeUpdate(DocumentEvent e) {
					getElementalNodeSettings().labelStringHolder().value_(labelStringField.getText());
				}

				public void changedUpdate(DocumentEvent e) {
					// nothing to do
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					String aString = (String) anObject;
					if (labelStringField.getText().equals(aString) == false) {
						labelStringField.setText(aString);
					}
					return null;
				}
			};
			StBlockValue blockValue = this.getElementalNodeSettings().labelStringHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(labelStringField, blockValue);
		}
		return labelStringField;
	}

	/**
	 * Answer the x-location string field.
	 * 
	 * @return javax.swing.JTextField
	 * @category user interface
	 */
	protected JTextField xLocationStringField() {
		if (xLocationStringField == null) {
			xLocationStringField = new JTextField() {
				public void removeNotify() {
					((StBlockValue) _blockValues.get(xLocationStringField)).release();
					super.removeNotify();
				}
			};
			xLocationStringField.getDocument().addDocumentListener(new DocumentListener() {
				public void insertUpdate(DocumentEvent e) {
					getElementalNodeSettings().xLocationStringHolder().setValue_(xLocationStringField.getText());
				}

				public void removeUpdate(DocumentEvent e) {
					getElementalNodeSettings().xLocationStringHolder().setValue_(xLocationStringField.getText());
				}

				public void changedUpdate(DocumentEvent e) {
					// nothing to do
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					String aString = (String) anObject;
					if (xLocationStringField.getText().equals(aString) == false) {
						xLocationStringField.setText(aString);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalNodeSettings().xLocationStringHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(xLocationStringField, blockValue);
		}
		return xLocationStringField;
	}

	/**
	 * Answer the y-location string field.
	 * 
	 * @return javax.swing.JTextField
	 * @category user interface
	 */
	protected JTextField yLocationStringField() {
		if (yLocationStringField == null) {
			yLocationStringField = new JTextField() {
				public void removeNotify() {
					((StBlockValue) _blockValues.get(yLocationStringField)).release();
					super.removeNotify();
				}
			};
			yLocationStringField.getDocument().addDocumentListener(new DocumentListener() {
				public void insertUpdate(DocumentEvent e) {
					getElementalNodeSettings().yLocationStringHolder().setValue_(yLocationStringField.getText());
				}

				public void removeUpdate(DocumentEvent e) {
					getElementalNodeSettings().yLocationStringHolder().setValue_(yLocationStringField.getText());
				}

				public void changedUpdate(DocumentEvent e) {
					// nothing to do
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					String aString = (String) anObject;
					if (yLocationStringField.getText().equals(aString) == false) {
						yLocationStringField.setText(aString);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalNodeSettings().yLocationStringHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(yLocationStringField, blockValue);
		}
		return yLocationStringField;
	}

	/**
	 * Answer the foreground color button.
	 * 
	 * @return javax.swing.JButton
	 * @category user interface
	 */
	protected JButton foregroundColorButton() {
		if (foregroundColorButton == null) {
			foregroundColorButton = new JButton() {
				public void paint(Graphics g) {
					super.paint(g);

					Dimension size = this.getSize();
					int x = (size.width - ButtonColorImageSize.width) / 2;
					int y = (size.height - ButtonColorImageSize.height) / 2;
					g.setColor((Color) getElementalNodeSettings().foregroundColorHolder().value());
					g.fillRect(x, y, ButtonColorImageSize.width, ButtonColorImageSize.height);
				}

				public void removeNotify() {
					((StBlockValue) _blockValues.get(foregroundColorButton)).release();
					super.removeNotify();
				}
			};
			foregroundColorButton.setAction(new AbstractAction() {
				public void actionPerformed(ActionEvent e) {
					getElementalNodeSettings().foregroundColorButtonPressed();
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					foregroundColorButton.repaint();
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalNodeSettings().foregroundColorHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(foregroundColorButton, blockValue);
		}
		return foregroundColorButton;
	}

	/**
	 * Answer the background color button.
	 * 
	 * @return javax.swing.JButton
	 * @category user interface
	 */
	protected JButton backgroundColorButton() {
		if (backgroundColorButton == null) {
			backgroundColorButton = new JButton() {
				public void paint(Graphics g) {
					super.paint(g);

					Dimension size = this.getSize();
					int x = (size.width - ButtonColorImageSize.width) / 2;
					int y = (size.height - ButtonColorImageSize.height) / 2;
					g.setColor((Color) getElementalNodeSettings().backgroundColorHolder().value());
					g.fillRect(x, y, ButtonColorImageSize.width, ButtonColorImageSize.height);
				}

				public void removeNotify() {
					((StBlockValue) _blockValues.get(backgroundColorButton)).release();
					super.removeNotify();
				}
			};
			backgroundColorButton.setAction(new AbstractAction() {
				public void actionPerformed(ActionEvent e) {
					getElementalNodeSettings().backgroundColorButtonPressed();
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					backgroundColorButton.repaint();
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalNodeSettings().backgroundColorHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(backgroundColorButton, blockValue);
		}
		return backgroundColorButton;
	}

	/**
	 * Answer the border color button.
	 * 
	 * @return javax.swing.JButton
	 * @category user interface
	 */
	protected JButton borderColorButton() {
		if (borderColorButton == null) {
			borderColorButton = new JButton() {
				public void paint(Graphics g) {
					super.paint(g);

					Dimension size = this.getSize();
					int x = (size.width - ButtonColorImageSize.width) / 2;
					int y = (size.height - ButtonColorImageSize.height) / 2;
					g.setColor((Color) getElementalNodeSettings().borderColorHolder().value());
					g.fillRect(x, y, ButtonColorImageSize.width, ButtonColorImageSize.height);
				}

				public void removeNotify() {
					((StBlockValue) _blockValues.get(borderColorButton)).release();
					super.removeNotify();
				}
			};
			borderColorButton.setAction(new AbstractAction() {
				public void actionPerformed(ActionEvent e) {
					getElementalNodeSettings().borderColorButtonPressed();
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					borderColorButton.repaint();
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalNodeSettings().borderColorHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(borderColorButton, blockValue);
		}
		return borderColorButton;
	}

	/**
	 * Answer the border width slider.
	 * 
	 * @return javax.swing.JSlider
	 * @category user interface
	 */
	protected JSlider borderWidthSlider() {
		if (borderWidthSlider == null) {
			borderWidthSlider = new JSlider(JSlider.HORIZONTAL, 1, 5, 1) {
				public void removeNotify() {
					((StBlockValue) _blockValues.get(borderWidthSlider)).release();
					super.removeNotify();
				}
			};
			borderWidthSlider.setMajorTickSpacing(1);
			borderWidthSlider.setPaintTicks(true);
			borderWidthSlider.setSnapToTicks(true);
			borderWidthSlider.addChangeListener(new ChangeListener() {
				public void stateChanged(ChangeEvent e) {
					int value = borderWidthSlider.getValue();
					getElementalNodeSettings().borderWidthHolder().value_(new Integer(value));
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					int value = ((Number) anObject).intValue();
					if (value != borderWidthSlider.getValue()) {
						borderWidthSlider.setValue(value);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalNodeSettings().borderWidthHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(borderWidthSlider, blockValue);
		}
		return borderWidthSlider;
	}

	/**
	 * Answer the all defaults button.
	 * 
	 * @return javax.swing.JButton
	 * @category user interface
	 */
	protected JButton allDefaultsButton() {
		if (allDefaultsButton == null) {
			allDefaultsButton = new JButton(new AbstractAction($String("Default")) {
				public void actionPerformed(ActionEvent e) {
					getElementalNodeSettings().defaultButtonPressed();
				}
			});
		}
		return allDefaultsButton;
	}

	/**
	 * Update for the change notice from the model.
	 * 
	 * @param e jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.DependentListener#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent e) {
		if (e.getAspect() == $("widgets")) {
			Iterator i = _blockValues.values().iterator();
			while (i.hasNext()) {
				((StBlockValue) i.next()).computeValue();
			}
		} else {
			super.update_(e);
		}
	}

}
