package jp.co.sra.jun.topology.graph;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StValueHolder;

import jp.co.sra.jun.goodies.colors.JunColorChoiceDialog;
import jp.co.sra.jun.goodies.colors.JunColorChoiceHBS;
import jp.co.sra.jun.goodies.colors.JunColorChoiceModel;
import jp.co.sra.jun.goodies.tables.JunAttributeTable;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.jun.system.framework.JunDialog;

/**
 * JunElementalStuffSettings class
 * 
 *  @author    nisinaka
 *  @created   2006/04/17 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun598 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunElementalStuffSettings.java,v 8.11 2008/02/20 06:33:02 nisinaka Exp $
 */
public abstract class JunElementalStuffSettings extends JunApplicationModel {

	protected JunElementalStuff elementalStuff;
	protected StValueHolder settingsHolder;
	protected StBlockClosure computeBlock;

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StApplicationModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		elementalStuff = null;
		settingsHolder = new StValueHolder(new HashMap());
		computeBlock = null;
	}

	/**
	 * Answer my current elemental stuff.
	 * 
	 * @return jp.co.sra.jun.topology.graph.JunElementalStuff
	 * @category accessing
	 */
	public JunElementalStuff stuff() {
		return elementalStuff;
	}

	/**
	 * Set my new elemental stuff.
	 * 
	 * @param aStuff jp.co.sra.jun.topology.graph.JunElementalStuff
	 * @category accessing
	 */
	public void stuff_(JunElementalStuff aStuff) {
		elementalStuff = aStuff;

		this.settingsFromStuffToCurrent();
		this.updateWindowTitle();
	}

	/**
	 * Answer the current settings.
	 * 
	 * @return java.util.Map
	 * @category accessing
	 */
	public Map currentSettings() {
		return new HashMap();
	}

	/**
	 * Answer the stuff settings.
	 * 
	 * @return java.util.Map
	 * @category accessing
	 */
	public Map stuffSettings() {
		return new HashMap();
	}

	/**
	 * Set the compute block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category constructing
	 */
	public void compute_(StBlockClosure aBlock) {
		computeBlock = aBlock;
	}

	/**
	 * Answer the default attribute table.
	 * 
	 * @return jp.co.sra.jun.goodies.tables.JunAttributeTable
	 * @category defaults
	 */
	protected abstract JunAttributeTable defaultAttributes();

	/**
	 * Action for the default button.
	 * 
	 * @category actions
	 */
	protected void defaultButtonPressed() {
		if (JunDialog.Confirm_($String("Really default?"), true) == false) {
			return;
		}

		if (this.stuff() != null) {
			this.stuff().resetAttributesByDefaults();
		} else {
			this.resetDefaultAttributes();
		}
		this.settingsFromStuffToCurrent();
		this.updateSettings();
	}

	/**
	 * Update the settings.
	 * 
	 * @category private
	 */
	protected void updateSettings() {
		Map newSettings = this.currentSettings();
		Map oldSettings = (Map) settingsHolder.value();
		if (newSettings.equals(oldSettings)) {
			return;
		}

		settingsHolder.value_(newSettings);
		this.updateWidgets();
		this.settingsFromCurrentToStuff();
		if (computeBlock != null) {
			int numArgs = computeBlock.numArgs();
			switch (numArgs) {
				case 0:
					computeBlock.value();
					break;
				case 1:
					computeBlock.value_(settingsHolder.value());
					break;
				case 2:
					computeBlock.value_value_(settingsHolder.value(), this.stuff());
					break;
			}
		}
	}

	/**
	 * Update the widgets.
	 * 
	 * @category private
	 */
	protected void updateWidgets() {
		this.changed_($("widgets"));
	}

	/**
	 * Copy settings from current to stuff.
	 * 
	 * @category private
	 */
	protected abstract void settingsFromCurrentToStuff();

	/**
	 * Copy settings from stuff to current.
	 * 
	 * @category private
	 */
	protected abstract void settingsFromStuffToCurrent();

	/**
	 * Reset the default attributes.
	 * 
	 * @category private
	 */
	protected abstract void resetDefaultAttributes();

	/**
	 * Choose a color.
	 * 
	 * @param colorHolder jp.co.sra.smalltalk.StValueHolder
	 * @category private
	 */
	protected void _chooseColorFor(StValueHolder colorHolder) {
		Color oldColor = (Color) colorHolder.value();

		JunColorChoiceModel colorChoiceModel = new JunColorChoiceHBS();
		colorChoiceModel.color_(oldColor);
		Color newColor = JunColorChoiceDialog.Request_colorChoice_($String("Select a color."), colorChoiceModel);
		if (newColor == null || newColor.equals(oldColor)) {
			return;
		}

		colorHolder.value_(newColor);
	}

}
