package jp.co.sra.jun.voronoi.twoD.diagram;

import java.awt.Point;
import java.io.IOException;
import java.io.Writer;

import jp.co.sra.smalltalk.SmalltalkException;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;

/**
 * JunVoronoi2dDot class
 * 
 *  @author    NISHIHARA Satoshi
 *  @created   2000/01/25 (by NISHIHARA Satoshi)
 *  @updated   2006/11/07 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVoronoi2dDot.java,v 8.11 2008/02/20 06:33:14 nisinaka Exp $
 */
public class JunVoronoi2dDot extends JunVoronoi2dObject {

	protected double x;
	protected double y;

	/**
	 * Create a new instance of JunVoronoi2dDot and initialize it.
	 *
	 * @param x double
	 * @param y double
	 * @category Instance creation
	 */
	public JunVoronoi2dDot(double x, double y) {
		this.x_(x);
		this.y_(y);
	}

	/**
	 * Create a new instance of JunVoronoi2dDot and initialize it.
	 *
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @category Instance creation
	 */
	public JunVoronoi2dDot(Jun2dPoint aPoint) {
		this(aPoint.x(), aPoint.y());
	}

	/**
	 * Create a new instance of JunVoronoi2dDot and initialize it.
	 *
	 * @param aPoint java.awt.Point
	 * @category Instance creation
	 */
	public JunVoronoi2dDot(Point aPoint) {
		this(aPoint.x, aPoint.y);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dObject#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		x = Double.NaN;
		y = Double.NaN;
	}

	/**
	 * Answer my current x value.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double x() {
		return x;
	}

	/**
	 * Set my new x value.
	 * 
	 * @param aNumber double
	 * @category accessing
	 */
	public void x_(double aNumber) {
		x = aNumber;
	}

	/**
	 * Answer my current y value.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double y() {
		return y;
	}

	/**
	 * Set my new y value.
	 * 
	 * @param aNumber double
	 * @category accessing
	 */
	public void y_(double aNumber) {
		y = aNumber;
	}

	/**
	 * Answer the distance between the receiver and the specified dot.
	 * 
	 * @param voronoi2dDot jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dDot
	 * @return double
	 * @category functions 
	 */
	public double distance_(JunVoronoi2dDot voronoi2dDot) {
		double x1 = this.x();
		double y1 = this.y();
		double x2 = voronoi2dDot.x();
		double y2 = voronoi2dDot.y();
		double x12 = x1 - x2;
		double y12 = y1 - y2;
		return Math.sqrt(x12 * x12 + y12 * y12);
	}

	/**
	 * Answer the bisector between the receiver and the specified dot.
	 * 
	 * @param voronoi2dDot jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dDot
	 * @return jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dLine
	 * @category functions 
	 */
	public JunVoronoi2dLine bisector_(JunVoronoi2dDot voronoi2dDot) {
		double x1 = this.x();
		double y1 = this.y();
		double x2 = voronoi2dDot.x();
		double y2 = voronoi2dDot.y();
		double a = x2 - x1;
		double b = y2 - y1;
		double c = ((x2 * x2 + y2 * y2) - (x1 * x1 + y1 * y1)) * 0.5 * -1;
		if (Math.abs(a) < this.accuracy() && Math.abs(b) < this.accuracy()) {
			throw SmalltalkException.Error("two points are the same.");
		}

		return new JunVoronoi2dLine(a, b, c);
	}

	/**
	 * Print my string representation on the writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws java.io.IOException
	 * @see jp.co.sra.smalltalk.StObject#printOn_(java.io.Writer)
	 * @category printing
	 */
	public void printOn_(Writer aWriter) throws IOException {
		aWriter.write("dot ( ");
		aWriter.write(String.valueOf(x));
		aWriter.write(" , ");
		aWriter.write(String.valueOf(y));
		aWriter.write(" )");
	}

}
