package jp.co.sra.jun.voronoi.twoD.diagram;

import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunVoronoi2dPointTestExamples class
 * 
 *  @author    NISHIHARA Satoshi
 *  @created   2000/01/25 (by NISHIHARA Satoshi)
 *  @updated   2006/11/07 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVoronoi2dPointTestExamples.java,v 8.10 2008/02/20 06:33:14 nisinaka Exp $
 */
public class JunVoronoi2dPointTestExamples extends JunTestExamples {

	/**
	 * Example1:
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		JunVoronoi2dPoint point = new JunVoronoi2dPoint(1, 1);
		System.out.println(point);

		return true;
	}

	/**
	 * Example2:
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		JunVoronoi2dPoint point1 = new JunVoronoi2dPoint(0, 0);
		JunVoronoi2dPoint point2 = new JunVoronoi2dPoint(1, 1);
		double distance = point1.distance_(point2);
		System.out.println(distance);

		return true;
	}

	/**
	 * Example3:
	 * 
	 * @return boolean
	 */
	public static boolean Example3() {
		JunVoronoi2dPoint point1 = new JunVoronoi2dPoint(0, 0);
		JunVoronoi2dPoint point2 = new JunVoronoi2dPoint(1, 1);
		JunVoronoi2dLine bisector = point1.bisector_(point2);
		System.out.println(bisector);

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunVoronoi2dPointTestExamples();
	}

}
