package jp.co.sra.jun.voronoi.twoD.diagram;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;

import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StRectangle;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunVoronoi2dProcessorTestExamples class
 * 
 *  @author    NISHIHARA Satoshi
 *  @created   2000/01/6 (by NISHIHARA Satoshi)
 *  @updated   2006/11/07 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun668 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVoronoi2dProcessorTestExamples.java,v 8.11 2008/02/20 06:33:14 nisinaka Exp $
 */
public class JunVoronoi2dProcessorTestExamples extends JunTestExamples {

	/**
	 * Example1:
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		Jun2dPoint[] points = new Jun2dPoint[4];
		points[0] = new Jun2dPoint(0.0, 0.0);
		points[1] = new Jun2dPoint(0.1, 1.0);
		points[2] = new Jun2dPoint(1.0, 0.1);
		points[3] = new Jun2dPoint(1.0, 1.0);
		JunVoronoi2dProcessor voronoi = new JunVoronoi2dProcessor(points);
		voronoi.trace_(true);
		voronoi.compute();
		System.out.println("area: " + voronoi.area());

		return true;
	}

	/**
	 * Example2:
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		Jun2dPoint[] points = new Jun2dPoint[16];
		points[0] = new Jun2dPoint(-1.0709950047146d, -1.0d);
		points[1] = new Jun2dPoint(-1.3616787517522d, -0.55623057513983d);
		points[2] = new Jun2dPoint(-1.4749357023933d, 1.1021456892432e-16d);
		points[3] = new Jun2dPoint(-1.3616787517522d, 0.55623057513983d);
		points[4] = new Jun2dPoint(-1.0329942792654d, 1.0580134260987d);
		points[5] = new Jun2dPoint(-0.83909963117728d, 1.2088366880644d);
		points[6] = new Jun2dPoint(-0.3639702342662d, 1.4500662049207d);
		points[7] = new Jun2dPoint(-0.3290104887271d, 1.456230551298d);
		points[8] = new Jun2dPoint(0.0d, 1.4857898683076d);
		points[9] = new Jun2dPoint(0.3290104887271d, 1.456230551298d);
		points[10] = new Jun2dPoint(0.3639702342662d, 1.4500662049207d);
		points[11] = new Jun2dPoint(0.83909963117728d, 1.2088366880644d);
		points[12] = new Jun2dPoint(1.0d, 1.0836784193003d);
		points[13] = new Jun2dPoint(1.0d, 3.0d);
		points[14] = new Jun2dPoint(-3.0d, 3.0d);
		points[15] = new Jun2dPoint(-3.0d, -1.0d);
		JunVoronoi2dProcessor voronoi = new JunVoronoi2dProcessor(points);
		voronoi.trace_(true);
		voronoi.compute();
		System.out.println("area: " + voronoi.area());

		ShowTriangles(voronoi, new Jun2dPoint(50, 50), new Jun2dPoint(200, 100), StRectangle.Origin_extent_(new Point(-3, -1), new Point(4, 4)));

		return true;
	}

	/**
	 * Example3:
	 * 
	 * @return boolean
	 */
	public static boolean Example3() {
		Jun2dPoint[] points = new Jun2dPoint[50];
		for (int i = 0; i < points.length; i++) {
			points[i] = new Jun2dPoint(Math.random(), Math.random());
		}
		JunVoronoi2dProcessor voronoi = new JunVoronoi2dProcessor(points);
		voronoi.trace_(true);
		voronoi.compute();
		System.out.println("area: " + voronoi.area());

		ShowTriangles(voronoi, new Jun2dPoint(200, 200), new Jun2dPoint(50, 50), StRectangle.Origin_extent_(new Point(0, 0), new Point(1, 1)));

		return true;
	}

	/**
	 * Example4:
	 * 
	 * @return boolean
	 */
	public static boolean Example4() {
		ArrayList aList = new ArrayList();
		aList.add(new Jun2dPoint(0, 0));
		for (int degrees = 0; degrees <= 360; degrees += 10) {
			JunAngle angle = JunAngle.FromDeg_(degrees);
			aList.add(new Jun2dPoint(angle.cos(), angle.sin()));
		}
		Jun2dPoint[] points = (Jun2dPoint[]) aList.toArray(new Jun2dPoint[aList.size()]);
		JunVoronoi2dProcessor voronoi = new JunVoronoi2dProcessor(points);
		voronoi.trace_(true);
		voronoi.compute();
		System.out.println("area: " + voronoi.area());

		ShowTriangles(voronoi, new Jun2dPoint(100, 100), new Jun2dPoint(150, 150), StRectangle.Origin_corner_(new Point(-1, -1), new Point(1, 1)));

		return true;
	}

	/**
	 * Example5:
	 * 
	 * @return boolean
	 */
	public static boolean Example5() {
		Jun2dPoint[] points = new Jun2dPoint[] {
				new Jun2dPoint(0.20254893600941d, 0.30189919471741d),
				new Jun2dPoint(0.90037482976913d, 0.97756767272949d),
				new Jun2dPoint(0.37021240592003d, 0.7721865773201d),
				new Jun2dPoint(0.73451060056686d, 0.66534775495529d),
				new Jun2dPoint(0.83000415563583d, 0.35092878341675d),
				new Jun2dPoint(0.20771345496178d, 0.23709288239479d),
				new Jun2dPoint(0.13294461369514d, 0.44628903269768d),
				new Jun2dPoint(0.585289478302d, 0.81525200605392d),
				new Jun2dPoint(0.25862556695938d, 0.89500206708908d),
				new Jun2dPoint(0.56111621856689d, 0.95084547996521d),
				new Jun2dPoint(0.61521035432816d, 0.96237403154373d),
				new Jun2dPoint(0.25764265656471d, 0.62346524000168d),
				new Jun2dPoint(0.039433568716049d, 0.34228238463402d),
				new Jun2dPoint(0.22588920593262d, 0.24127447605133d),
				new Jun2dPoint(0.79660141468048d, 0.157176181674d),
				new Jun2dPoint(0.445447742939d, 0.64100790023804d),
				new Jun2dPoint(0.58059144020081d, 0.95807582139969d),
				new Jun2dPoint(0.32448145747185d, 0.087971679866314d),
				new Jun2dPoint(0.51385253667831d, 0.72457307577133d),
				new Jun2dPoint(0.69972509145737d, 0.27604332566261d),
				new Jun2dPoint(0.14740525186062d, 0.86483132839203d),
				new Jun2dPoint(0.83648478984833d, 0.32767179608345d),
				new Jun2dPoint(0.46084132790565d, 0.21558517217636d),
				new Jun2dPoint(0.42863807082176d, 0.79387754201889d),
				new Jun2dPoint(0.86232405900955d, 0.042140774428844d),
				new Jun2dPoint(0.59863388538361d, 0.654252409935d),
				new Jun2dPoint(0.18858808279037d, 0.038375675678253d),
				new Jun2dPoint(0.89749270677567d, 0.31695958971977d),
				new Jun2dPoint(0.70493960380554d, 0.32673886418343d),
				new Jun2dPoint(0.30480632185936d, 0.61873388290405d),
				new Jun2dPoint(0.10525614023209d, 0.45825073122978d),
				new Jun2dPoint(0.22873802483082d, 0.82488131523132d),
				new Jun2dPoint(0.51198667287827d, 0.41250312328339d),
				new Jun2dPoint(0.50602251291275d, 0.62927949428558d),
				new Jun2dPoint(0.47615161538124d, 0.59765928983688d),
				new Jun2dPoint(0.40196585655212d, 0.15437734127045d),
				new Jun2dPoint(0.97734278440475d, 0.85045397281647d),
				new Jun2dPoint(0.61044561862946d, 0.95119535923004d),
				new Jun2dPoint(0.42372345924377d, 0.43619325757027d),
				new Jun2dPoint(0.25391086935997d, 0.99932527542114d),
				new Jun2dPoint(0.65202832221985d, 0.048754684627056d),
				new Jun2dPoint(0.88338190317154d, 0.70693045854568d),
				new Jun2dPoint(0.92756348848343d, 0.81058722734451d),
				new Jun2dPoint(0.47845065593719d, 0.91074550151825d),
				new Jun2dPoint(0.94420659542084d, 0.27271136641502d),
				new Jun2dPoint(0.44728028774261d, 0.87607663869858d),
				new Jun2dPoint(0.82440650463104d, 0.41471886634827d),
				new Jun2dPoint(0.62660557031631d, 0.29680132865906d),
				new Jun2dPoint(0.11918367445469d, 0.64477300643921d),
				new Jun2dPoint(0.28173261880875d, 0.29536858201027d),
				new Jun2dPoint(0.808129966259d, 0.7996084690094d),
				new Jun2dPoint(0.10653894394636d, 0.4227988421917d),
				new Jun2dPoint(0.29940858483315d, 0.1445314437151d),
				new Jun2dPoint(0.22347354888916d, 0.65868389606476d),
				new Jun2dPoint(0.42975425720215d, 0.37341940402985d),
				new Jun2dPoint(0.18355685472488d, 0.4111869931221d),
				new Jun2dPoint(0.46447312831879d, 0.60872137546539d),
				new Jun2dPoint(0.96638065576553d, 0.51704287528992d),
				new Jun2dPoint(0.097442731261253d, 0.40145772695541d),
				new Jun2dPoint(0.9801082611084d, 0.24155768752098d),
				new Jun2dPoint(0.45111203193665d, 0.73122030496597d),
				new Jun2dPoint(0.06147438660264d, 0.27860891819d),
				new Jun2dPoint(0.076501458883286d, 0.0061724283732474d),
				new Jun2dPoint(0.47578507661819d, 0.75064557790756d),
				new Jun2dPoint(0.95320284366608d, 0.063048727810383d),
				new Jun2dPoint(0.91691797971725d, 0.2086880505085d),
				new Jun2dPoint(0.48937943577766d, 0.16715535521507d),
				new Jun2dPoint(0.5073219537735d, 0.6323282122612d),
				new Jun2dPoint(0.52176594734192d, 0.012369845993817d),
				new Jun2dPoint(0.79801750183105d, 0.42972928285599d),
				new Jun2dPoint(0.31566846370697d, 0.7211412191391d),
				new Jun2dPoint(0.76859641075134d, 0.43762597441673d),
				new Jun2dPoint(0.56496459245682d, 0.84448981285095d),
				new Jun2dPoint(0.82722198963165d, 0.92132443189621d),
				new Jun2dPoint(0.3921032845974d, 0.36200749874115d),
				new Jun2dPoint(0.81062889099121d, 0.57470220327377d),
				new Jun2dPoint(0.34810495376587d, 0.68185758590698d),
				new Jun2dPoint(0.98412328958511d, 0.52020823955536d),
				new Jun2dPoint(0.4125614464283d, 0.64077466726303d),
				new Jun2dPoint(0.041582673788071d, 0.30886298418045d),
				new Jun2dPoint(0.99363601207733d, 0.50406497716904d),
				new Jun2dPoint(0.10545606166124d, 0.92025822401047d),
				new Jun2dPoint(0.92806333303452d, 0.96560597419739d),
				new Jun2dPoint(0.72676384449005d, 0.7625572681427d),
				new Jun2dPoint(0.4811495244503d, 0.14784672856331d),
				new Jun2dPoint(0.88509786128998d, 0.67249476909637d),
				new Jun2dPoint(0.34677216410637d, 0.60180759429932d),
				new Jun2dPoint(0.98862141370773d, 0.91537690162659d),
				new Jun2dPoint(0.64738023281097d, 0.30708038806915d),
				new Jun2dPoint(0.87406915426254d, 0.18508121371269d),
				new Jun2dPoint(0.9339941740036d, 0.67182838916779d),
				new Jun2dPoint(0.80674719810486d, 0.60405665636063d),
				new Jun2dPoint(0.18620574474335d, 0.53278630971909d),
				new Jun2dPoint(0.48053312301636d, 0.72332364320755d),
				new Jun2dPoint(0.8121782541275d, 0.15526030957699d),
				new Jun2dPoint(0.017875885590911d, 0.52247399091721d),
				new Jun2dPoint(0.64864641427994d, 0.23312786221504d),
				new Jun2dPoint(0.96979594230652d, 0.40967097878456d),
				new Jun2dPoint(0.96091628074646d, 0.88883799314499d),
				new Jun2dPoint(0.31588503718376d, 0.22164931893349d),
				new Jun2dPoint(0.44286546111107d, 0.67341107130051d),
				new Jun2dPoint(0.46430653333664d, 0.22371511161327d),
				new Jun2dPoint(0.21694293618202d, 0.56643897294998d),
				new Jun2dPoint(0.25179508328438d, 0.10974594205618d),
				new Jun2dPoint(0.83416908979416d, 0.97608494758606d),
				new Jun2dPoint(0.94365680217743d, 0.0021907538175583d),
				new Jun2dPoint(0.27413576841354d, 0.73908370733261d),
				new Jun2dPoint(0.23376926779747d, 0.45206996798515d),
				new Jun2dPoint(0.94500625133514d, 0.12074135988951d),
				new Jun2dPoint(0.24458143115044d, 0.43897542357445d),
				new Jun2dPoint(0.68351519107819d, 0.81493544578552d),
				new Jun2dPoint(0.52711367607117d, 0.37107038497925d),
				new Jun2dPoint(0.75496876239777d, 0.94411492347717d),
				new Jun2dPoint(0.060957934707403d, 0.085089549422264d),
				new Jun2dPoint(0.85324448347092d, 0.059300292283297d),
				new Jun2dPoint(0.25427737832069d, 0.84633904695511d),
				new Jun2dPoint(0.1007913351059d, 0.14008329808712d),
				new Jun2dPoint(0.94380676746368d, 0.34869638085365d),
				new Jun2dPoint(0.048629738390446d, 0.5946272611618d),
				new Jun2dPoint(0.39485213160515d, 0.71461057662964d),
				new Jun2dPoint(0.67635154724121d, 0.25966680049896d),
				new Jun2dPoint(0.30129113793373d, 0.49510204792023d),
				new Jun2dPoint(0.39211994409561d, 0.40050813555717d),
				new Jun2dPoint(0.78557270765305d, 0.66976261138916d),
				new Jun2dPoint(0.032669719308615d, 0.71102875471115d),
				new Jun2dPoint(0.39871719479561d, 0.64675551652908d),
				new Jun2dPoint(0.8633069396019d, 0.31367763876915d),
				new Jun2dPoint(0.12031653523445d, 0.26281550526619d),
				new Jun2dPoint(0.57790923118591d, 0.75947523117065d),
				new Jun2dPoint(0.3585339486599d, 0.78324866294861d),
				new Jun2dPoint(0.29892545938492d, 0.02801332809031d),
				new Jun2dPoint(0.95010411739349d, 0.90193253755569d),
				new Jun2dPoint(0.5773760676384d, 0.52745521068573d),
				new Jun2dPoint(0.16033320128918d, 0.74131613969803d),
				new Jun2dPoint(0.39285299181938d, 0.094535611569881d),
				new Jun2dPoint(0.68309873342514d, 0.85241985321045d),
				new Jun2dPoint(0.15351936221123d, 0.99456059932709d),
				new Jun2dPoint(0.64084964990616d, 0.21483547985554d),
				new Jun2dPoint(0.69610995054245d, 0.92140775918961d),
				new Jun2dPoint(0.58460640907288d, 0.23672635853291d),
				new Jun2dPoint(0.2859308719635d, 0.99752604961395d),
				new Jun2dPoint(0.49396085739136d, 0.75482714176178d),
				new Jun2dPoint(0.61685961484909d, 0.77393585443497d),
				new Jun2dPoint(0.77707624435425d, 0.034443981945515d),
				new Jun2dPoint(0.81134527921677d, 0.2302290648222d),
				new Jun2dPoint(0.27068722248077d, 0.76945441961288d),
				new Jun2dPoint(0.4204081594944d, 0.77456891536713d),
				new Jun2dPoint(0.24009995162487d, 0.082307368516922d),
				new Jun2dPoint(0.4236401617527d, 0.24369013309479d),
				new Jun2dPoint(0.37919199466705d, 0.52402329444885d),
				new Jun2dPoint(0.22920449078083d, 0.90289878845215d),
				new Jun2dPoint(0.81041234731674d, 0.074194088578224d),
				new Jun2dPoint(0.67383587360382d, 0.44607245922089d),
				new Jun2dPoint(0.084781341254711d, 0.14098292589188d),
				new Jun2dPoint(0.022840483114123d, 0.99566012620926d),
				new Jun2dPoint(0.18189087510109d, 0.56112450361252d),
				new Jun2dPoint(0.97009581327438d, 0.10268221795559d),
				new Jun2dPoint(0.5099042057991d, 0.59992504119873d),
				new Jun2dPoint(0.63805079460144d, 0.74673050642014d),
				new Jun2dPoint(0.90555602312088d, 0.9512619972229d),
				new Jun2dPoint(0.57772594690323d, 0.33596834540367d),
				new Jun2dPoint(0.63415241241455d, 0.73758435249329d),
				new Jun2dPoint(0.76871305704117d, 0.70713037252426d),
				new Jun2dPoint(0.38957101106644d, 0.50991255044937d),
				new Jun2dPoint(0.61917531490326d, 0.12552270293236d),
				new Jun2dPoint(0.29426071047783d, 0.2478384077549d),
				new Jun2dPoint(0.96584755182266d, 0.28502291440964d),
				new Jun2dPoint(0.89924198389053d, 0.35952520370483d),
				new Jun2dPoint(0.074035815894604d, 0.30807995796204d),
				new Jun2dPoint(0.18410661816597d, 0.68170762062073d),
				new Jun2dPoint(0.63761764764786d, 0.74571430683136d),
				new Jun2dPoint(0.55701792240143d, 0.47969180345535d),
				new Jun2dPoint(0.77904206514359d, 0.57751768827438d),
				new Jun2dPoint(0.85471051931381d, 0.44735527038574d),
				new Jun2dPoint(0.049329444766045d, 0.21165347099304d),
				new Jun2dPoint(0.34249064326286d, 0.70714700222015d),
				new Jun2dPoint(0.42807164788246d, 0.48485630750656d),
				new Jun2dPoint(0.71423572301865d, 0.81008744239807d),
				new Jun2dPoint(0.32343190908432d, 0.66243231296539d),
				new Jun2dPoint(0.092394836246967d, 0.73576843738556d),
				new Jun2dPoint(0.57214492559433d, 0.43825906515121d),
				new Jun2dPoint(0.027988338842988d, 0.89235317707062d),
				new Jun2dPoint(0.43951687216759d, 0.93478548526764d),
				new Jun2dPoint(0.500608086586d, 0.11657642573118d),
				new Jun2dPoint(0.6194252371788d, 0.7030320763588d),
				new Jun2dPoint(0.91841733455658d, 0.6737442612648d),
				new Jun2dPoint(0.23431903123856d, 0.72259056568146d),
				new Jun2dPoint(0.11815077066422d, 0.25773426890373d),
				new Jun2dPoint(0.83521866798401d, 0.40162432193756d),
				new Jun2dPoint(0.36511453986168d, 0.99099540710449d),
				new Jun2dPoint(0.4017159640789d, 0.57686799764633d),
				new Jun2dPoint(0.353186160326d, 0.42454811930656d),
				new Jun2dPoint(0.34197416901588d, 0.51362764835358d),
				new Jun2dPoint(0.20481465756893d, 0.53798419237137d),
				new Jun2dPoint(0.49272802472115d, 0.90578091144562d),
				new Jun2dPoint(0.47102040052414d, 0.73946690559387d),
				new Jun2dPoint(0.11928363144398d, 0.87577676773071d),
				new Jun2dPoint(0.13139525055885d, 0.86573094129562d),
				new Jun2dPoint(0.91551852226257d, 0.97463554143906d),
				new Jun2dPoint(0.59410244226456d, 0.18208245933056d),
				new Jun2dPoint(0.0038817159365863d, 0.18194918334484d),
				new Jun2dPoint(0.69587671756744d, 0.38239899277687d),
				new Jun2dPoint(0.93539357185364d, 0.90588086843491d),
				new Jun2dPoint(0.70202416181564d, 0.58912950754166d),
				new Jun2dPoint(0.68964600563049d, 0.98316532373428d),
				new Jun2dPoint(0.30642232298851d, 0.35329446196556d),
				new Jun2dPoint(0.67480218410492d, 0.67910867929459d),
				new Jun2dPoint(0.63152021169662d, 0.65448564291d),
				new Jun2dPoint(0.72759681940079d, 0.68758851289749d),
				new Jun2dPoint(0.22833819687366d, 0.90086632966995d),
				new Jun2dPoint(0.11333610862494d, 0.13105373084545d),
				new Jun2dPoint(0.076468139886856d, 0.92917120456696d),
				new Jun2dPoint(0.52589756250381d, 0.56052476167679d),
				new Jun2dPoint(0.58407330513d, 0.0047063725069165d),
				new Jun2dPoint(0.08773010969162d, 0.95559352636337d),
				new Jun2dPoint(0.5878883600235d, 0.82134944200516d),
				new Jun2dPoint(0.34985423088074d, 0.72442317008972d),
				new Jun2dPoint(0.35321947932243d, 0.50154936313629d),
				new Jun2dPoint(0.29186171293259d, 0.70374846458435d),
				new Jun2dPoint(0.57394421100616d, 0.59632652997971d),
				new Jun2dPoint(0.32191586494446d, 0.15887546539307d),
				new Jun2dPoint(0.37251144647598d, 0.085272803902626d),
				new Jun2dPoint(0.27675133943558d, 0.78368180990219d),
				new Jun2dPoint(0.29994168877602d, 0.37655144929886d),
				new Jun2dPoint(0.42167431116104d, 0.70061641931534d),
				new Jun2dPoint(0.33582672476768d, 0.30689713358879d),
				new Jun2dPoint(0.45056226849556d, 0.46069970726967d),
				new Jun2dPoint(0.88832986354828d, 0.14161598682404d),
				new Jun2dPoint(0.48586422204971d, 0.043523531407118d),
				new Jun2dPoint(0.79418575763702d, 0.57458561658859d),
				new Jun2dPoint(0.078600585460663d, 0.85725116729736d),
				new Jun2dPoint(0.31870055198669d, 0.72825491428375d),
				new Jun2dPoint(0.20836317539215d, 0.7386172413826d),
				new Jun2dPoint(0.15575176477432d, 0.15364430844784d),
				new Jun2dPoint(0.28331527113914d, 0.95292794704437d),
				new Jun2dPoint(0.42778840661049d, 0.8303456902504d),
				new Jun2dPoint(0.14019158482552d, 0.19406080245972d),
				new Jun2dPoint(0.68583089113235d, 0.16652227938175d),
				new Jun2dPoint(0.044298209249973d, 0.58446478843689d),
				new Jun2dPoint(0.90947103500366d, 0.9989088177681d),
				new Jun2dPoint(0.68951272964478d, 0.67516034841537d),
				new Jun2dPoint(0.50687211751938d, 0.59281134605408d),
				new Jun2dPoint(0.19828404486179d, 0.44573926925659d),
				new Jun2dPoint(0.31476885080338d, 0.64210742712021d),
				new Jun2dPoint(0.12163265049458d, 0.30436486005783d),
				new Jun2dPoint(0.59846729040146d, 0.26924616098404d),
				new Jun2dPoint(0.43915036320686d, 0.087771758437157d),
				new Jun2dPoint(0.051845066249371d, 0.025247814133763d),
				new Jun2dPoint(0.5590004324913d, 0.061266139149666d),
				new Jun2dPoint(0.79735112190247d, 0.88970428705215d),
				new Jun2dPoint(0.31791752576828d, 0.91872555017471d),
				new Jun2dPoint(0.38600581884384d, 0.27077883481979d),
				new Jun2dPoint(0.98120784759521d, 0.78259891271591d),
				new Jun2dPoint(0.79740107059479d, 0.0052061639726162d),
				new Jun2dPoint(0.24274885654449d, 0.20390670001507d),
				new Jun2dPoint(0.43970012664795d, 0.35829237103462d),
				new Jun2dPoint(0.22498959302902d, 0.16224072873592d),
				new Jun2dPoint(0.14963765442371d, 0.023915035650134d),
				new Jun2dPoint(0.47895044088364d, 0.065764263272285d),
				new Jun2dPoint(0.19251978397369d, 0.12452311813831d),
				new Jun2dPoint(0.9842232465744d, 0.75121200084686d),
				new Jun2dPoint(0.26222407817841d, 0.21113702654839d),
				new Jun2dPoint(0.14897125959396d, 0.48389005661011d),
				new Jun2dPoint(0.48119950294495d, 0.26334860920906d),
				new Jun2dPoint(0.80992919206619d, 0.95767599344254d),
				new Jun2dPoint(0.40046647191048d, 0.68932110071182d),
				new Jun2dPoint(0.23240315914154d, 0.29501873254776d),
				new Jun2dPoint(0.99961680173874d, 0.32578924298286d),
				new Jun2dPoint(0.11027072370052d, 0.04693877696991d),
				new Jun2dPoint(0.68681383132935d, 0.43805915117264d),
				new Jun2dPoint(0.56598085165024d, 0.19302789866924d),
				new Jun2dPoint(0.2987921833992d, 0.72000831365585d),
				new Jun2dPoint(0.15055394172668d, 0.14144939184189d),
				new Jun2dPoint(0.10085797309875d, 0.29408580064774d),
				new Jun2dPoint(0.84358185529709d, 0.72893792390823d),
				new Jun2dPoint(0.78688877820969d, 0.71131193637848d),
				new Jun2dPoint(0.053227823227644d, 0.22079966962337d),
				new Jun2dPoint(0.47933360934258d, 0.95127862691879d),
				new Jun2dPoint(0.61622655391693d, 0.31091213226318d),
				new Jun2dPoint(0.72921282052994d, 0.422149091959d),
				new Jun2dPoint(0.79788422584534d, 0.12172428518534d),
				new Jun2dPoint(0.51611828804016d, 0.96065807342529d),
				new Jun2dPoint(0.29207828640938d, 0.20425656437874d),
				new Jun2dPoint(0.24821324646473d, 0.83211159706116d),
				new Jun2dPoint(0.22125780582428d, 0.53810077905655d),
				new Jun2dPoint(0.76223242282867d, 0.73038733005524d),
				new Jun2dPoint(0.13644315302372d, 0.53142023086548d),
				new Jun2dPoint(0.32348188757896d, 0.77793419361114d),
				new Jun2dPoint(0.017226155847311d, 0.02094960398972d),
				new Jun2dPoint(0.62583923339844d, 0.52577257156372d),
				new Jun2dPoint(0.27177008986473d, 0.27199500799179d),
				new Jun2dPoint(0.79175341129303d, 0.95349436998367d),
				new Jun2dPoint(0.73680967092514d, 0.97843396663666d),
				new Jun2dPoint(0.37224489450455d, 0.46926280856133d),
				new Jun2dPoint(0.67765098810196d, 0.2627155482769d),
				new Jun2dPoint(0.34690546989441d, 0.90981256961823d),
				new Jun2dPoint(0.78817158937454d, 0.67586004734039d),
				new Jun2dPoint(0.1238983720541d, 0.54044979810715d),
				new Jun2dPoint(0.19082048535347d, 0.197459384799d),
				new Jun2dPoint(0.53995835781097d, 0.055052060633898d),
				new Jun2dPoint(0.4366180896759d, 0.23567679524422d),
				new Jun2dPoint(0.860391497612d, 0.57606828212738d),
				new Jun2dPoint(0.50515615940094d, 0.62724697589874d),
				new Jun2dPoint(0.77907538414001d, 0.65451896190643d),
				new Jun2dPoint(0.80459809303284d, 0.63747602701187d),
				new Jun2dPoint(0.41845896840096d, 0.2699958384037d),
				new Jun2dPoint(0.17167846858501d, 0.9602415561676d),
				new Jun2dPoint(0.3295626938343d, 0.8306622505188d),
				new Jun2dPoint(0.87170344591141d, 0.71799248456955d),
				new Jun2dPoint(0.49197834730148d, 0.17325280606747d),
				new Jun2dPoint(0.59855061769485d, 0.46174928545952d),
				new Jun2dPoint(0.31386920809746d, 0.56307369470596d),
				new Jun2dPoint(0.47466889023781d, 0.17110370099545d),
				new Jun2dPoint(0.6319699883461d, 0.69400250911713d),
				new Jun2dPoint(0.051078718155622d, 0.2542190849781d),
				new Jun2dPoint(0.71158683300018d, 0.68848812580109d),
				new Jun2dPoint(0.30737191438675d, 0.54783004522324d),
				new Jun2dPoint(0.24659724533558d, 0.097551017999649d),
				new Jun2dPoint(0.65171176195145d, 0.31724280118942d),
				new Jun2dPoint(0.35945022106171d, 0.90078300237656d),
				new Jun2dPoint(0.92083299160004d, 0.2563348710537d),
				new Jun2dPoint(0.60116618871689d, 0.50634735822678d),
				new Jun2dPoint(0.38004165887833d, 0.48755517601967d),
				new Jun2dPoint(0.95133692026138d, 0.75097876787186d),
				new Jun2dPoint(0.72321534156799d, 0.56192421913147d),
				new Jun2dPoint(0.81812578439713d, 0.89998334646225d),
				new Jun2dPoint(0.072802998125553d, 0.45903372764587d),
				new Jun2dPoint(0.038267388939857d, 0.64723867177963d),
				new Jun2dPoint(0.97982507944107d, 0.58704704046249d),
				new Jun2dPoint(0.87706786394119d, 0.1151936724782d),
				new Jun2dPoint(0.42387339472771d, 0.7826988697052d),
				new Jun2dPoint(0.028404831886292d, 0.85486882925034d),
				new Jun2dPoint(0.81311118602753d, 0.31129530072212d),
				new Jun2dPoint(0.61472719907761d, 0.84585589170456d),
				new Jun2dPoint(0.98427319526672d, 0.86671388149261d),
				new Jun2dPoint(0.18705539405346d, 0.4963181912899d),
				new Jun2dPoint(0.20266555249691d, 0.57140356302261d),
				new Jun2dPoint(0.72498124837875d, 0.64299041032791d),
				new Jun2dPoint(0.16216576099396d, 0.97638481855392d),
				new Jun2dPoint(0.6366680264473d, 0.55117869377136d),
				new Jun2dPoint(0.98522281646729d, 0.061249479651451d),
				new Jun2dPoint(0.75885045528412d, 0.91476052999496d),
				new Jun2dPoint(0.22285714745522d, 0.23416076600552d),
				new Jun2dPoint(0.35683465003967d, 0.85618489980698d),
				new Jun2dPoint(0.85466057062149d, 0.33185338973999d),
				new Jun2dPoint(0.12449812889099d, 0.92647230625153d),
				new Jun2dPoint(0.28879633545876d, 0.61963349580765d),
				new Jun2dPoint(0.18428987264633d, 0.10521449148655d),
				new Jun2dPoint(0.36199915409088d, 0.79137861728668d),
				new Jun2dPoint(0.087230317294598d, 0.8005747795105d),
				new Jun2dPoint(0.33957517147064d, 0.96953767538071d),
				new Jun2dPoint(0.81291127204895d, 0.84928780794144d),
				new Jun2dPoint(0.91540193557739d, 0.70513117313385d),
				new Jun2dPoint(0.76949602365494d, 0.5166597366333d),
				new Jun2dPoint(0.21192836761475d, 0.97775095701218d),
				new Jun2dPoint(0.79371929168701d, 0.49656808376312d),
				new Jun2dPoint(0.78017491102219d, 0.19556018710136d),
				new Jun2dPoint(0.15088713169098d, 0.9114618897438d),
				new Jun2dPoint(0.59973347187042d, 0.19529362022877d),
				new Jun2dPoint(0.53487712144852d, 0.31236150860786d),
				new Jun2dPoint(0.07876718044281d, 0.242257386446d),
				new Jun2dPoint(0.068138279020786d, 0.67885881662369d),
				new Jun2dPoint(0.054010827094316d, 0.030329030007124d),
				new Jun2dPoint(0.30169096589088d, 0.4191170334816d),
				new Jun2dPoint(0.79077053070068d, 0.68195754289627d),
				new Jun2dPoint(0.21512703597546d, 0.36987090110779d),
				new Jun2dPoint(0.98292380571365d, 0.74816328287125d),
				new Jun2dPoint(0.21660974621773d, 0.79642647504807d),
				new Jun2dPoint(0.75291961431503d, 0.20853811502457d),
				new Jun2dPoint(0.14287380874157d, 0.39266139268875d),
				new Jun2dPoint(0.65177839994431d, 0.4712453186512d),
				new Jun2dPoint(0.25922530889511d, 0.28102457523346d),
				new Jun2dPoint(0.65909206867218d, 0.37301957607269d),
				new Jun2dPoint(0.25954186916351d, 0.012536442838609d),
				new Jun2dPoint(0.18302373588085d, 0.17916701734066d),
				new Jun2dPoint(0.26627239584923d, 0.56678885221481d),
				new Jun2dPoint(0.060308203101158d, 0.58356517553329d),
				new Jun2dPoint(0.83043730258942d, 0.35194501280785d),
				new Jun2dPoint(0.55625158548355d, 0.70866304636002d),
				new Jun2dPoint(0.93162846565247d, 0.20473968982697d),
				new Jun2dPoint(0.36473137140274d, 0.10548105090857d),
				new Jun2dPoint(0.97800916433334d, 0.3904789686203d),
				new Jun2dPoint(0.60819655656815d, 0.75361096858978d),
				new Jun2dPoint(0.80631405115128d, 0.60304039716721d),
				new Jun2dPoint(0.8376676440239d, 0.061216160655022d),
				new Jun2dPoint(0.68184924125671d, 0.96487295627594d),
				new Jun2dPoint(0.032736361026764d, 0.86503124237061d),
				new Jun2dPoint(0.29849228262901d, 0.026997083798051d),
				new Jun2dPoint(0.60156601667404d, 0.43036234378815d),
				new Jun2dPoint(0.77869218587875d, 0.76900458335876d),
				new Jun2dPoint(0.38089129328728d, 0.45108705759048d),
				new Jun2dPoint(0.6734693646431d, 0.59905874729156d),
				new Jun2dPoint(0.63601833581924d, 0.049654312431812d),
				new Jun2dPoint(0.96241563558578d, 0.35389420390129d),
				new Jun2dPoint(0.060824654996395d, 0.77708452939987d),
				new Jun2dPoint(0.053694292902946d, 0.29881715774536d),
				new Jun2dPoint(0.77775925397873d, 0.61296957731247d),
				new Jun2dPoint(0.78403997421265d, 0.12770512700081d),
				new Jun2dPoint(0.33784255385399d, 0.96547269821167d),
				new Jun2dPoint(0.41875883936882d, 0.96300709247589d),
				new Jun2dPoint(0.72066640853882d, 0.67132860422134d),
				new Jun2dPoint(0.65172845125198d, 0.35574343800545d),
				new Jun2dPoint(0.33439400792122d, 0.99584341049194d),
				new Jun2dPoint(0.60539776086807d, 0.28550603985786d),
				new Jun2dPoint(0.015760099515319d, 0.6328946352005d),
				new Jun2dPoint(0.83078718185425d, 0.16045814752579d),
				new Jun2dPoint(0.030070804059505d, 0.70493125915527d),
				new Jun2dPoint(0.30748856067657d, 0.81733447313309d),
				new Jun2dPoint(0.071203663945198d, 0.76297378540039d),
				new Jun2dPoint(0.4436651468277d, 0.52144104242325d),
				new Jun2dPoint(0.26160767674446d, 0.78661388158798d),
				new Jun2dPoint(0.076051644980907d, 0.96665555238724d),
				new Jun2dPoint(0.15230320394039d, 0.18401499092579d),
				new Jun2dPoint(0.4699541926384d, 0.27542689442635d),
				new Jun2dPoint(0.7228821516037d, 0.79191172122955d),
				new Jun2dPoint(0.31925031542778d, 0.99877548217773d),
				new Jun2dPoint(0.38150769472122d, 0.87561017274857d),
				new Jun2dPoint(0.74638903141022d, 0.11629321426153d),
				new Jun2dPoint(0.96491461992264d, 0.1289879232645d),
				new Jun2dPoint(0.3023906648159d, 0.036143273115158d),
				new Jun2dPoint(0.73840898275375d, 0.67449396848679d),
				new Jun2dPoint(0.96684712171555d, 0.59506040811539d),
				new Jun2dPoint(0.39586839079857d, 0.063148684799671d),
				new Jun2dPoint(0.14792169630527d, 0.058350685983896d),
				new Jun2dPoint(0.059741772711277d, 0.27454394102097d),
				new Jun2dPoint(0.68234902620316d, 0.1198917105794d),
				new Jun2dPoint(0.28104954957962d, 0.71684300899506d),
				new Jun2dPoint(0.83543521165848d, 0.90213245153427d),
				new Jun2dPoint(0.039383590221405d, 0.22678050398827d),
				new Jun2dPoint(0.30105790495872d, 0.95609331130981d),
				new Jun2dPoint(0.74290710687637d, 0.069662638008595d),
				new Jun2dPoint(0.20166596770287d, 0.26136609911919d),
				new Jun2dPoint(0.22835485637188d, 0.93936693668365d),
				new Jun2dPoint(0.088279880583286d, 0.22611412405968d),
				new Jun2dPoint(0.76103287935257d, 0.95834237337112d),
				new Jun2dPoint(0.94049143791199d, 0.68707203865051d),
				new Jun2dPoint(0.034818824380636d, 0.67760932445526d),
				new Jun2dPoint(0.166463971138d, 0.90954601764679d),
				new Jun2dPoint(0.17216159403324d, 0.076759681105614d),
				new Jun2dPoint(0.60293209552765d, 0.58741354942322d),
				new Jun2dPoint(0.72408163547516d, 0.56395667791367d),
				new Jun2dPoint(0.51520198583603d, 0.8431236743927d),
				new Jun2dPoint(0.67017078399658d, 0.97593504190445d),
				new Jun2dPoint(0.59715116024017d, 0.22769679129124d),
				new Jun2dPoint(0.41859224438667d, 0.57800084352493d),
				new Jun2dPoint(0.97122865915298d, 0.72072470188141d),
				new Jun2dPoint(0.80608081817627d, 0.064031653106213d),
				new Jun2dPoint(0.18845480680466d, 0.73037070035934d),
				new Jun2dPoint(0.097942523658276d, 0.55647647380829d),
				new Jun2dPoint(0.22842149436474d, 0.09336943179369d),
				new Jun2dPoint(0.98805499076843d, 0.60635566711426d),
				new Jun2dPoint(0.49929195642471d, 0.075027070939541d),
				new Jun2dPoint(0.59886711835861d, 0.19326114654541d),
				new Jun2dPoint(0.83780092000961d, 0.36922115087509d),
				new Jun2dPoint(0.48139941692352d, 0.72535610198975d),
				new Jun2dPoint(0.50925445556641d, 0.098400667309761d),
				new Jun2dPoint(0.61524367332458d, 0.039375260472298d),
				new Jun2dPoint(0.20753020048141d, 0.81358599662781d),
				new Jun2dPoint(0.40856310725212d, 0.40062475204468d),
				new Jun2dPoint(0.05507704988122d, 0.49436900019646d),
				new Jun2dPoint(0.69809246063232d, 0.50298207998276d),
				new Jun2dPoint(0.60291546583176d, 0.54891294240952d),
				new Jun2dPoint(0.74913787841797d, 0.4688962996006d),
				new Jun2dPoint(0.83063721656799d, 0.81395250558853d),
				new Jun2dPoint(0.25557684898376d, 0.84938776493073d),
				new Jun2dPoint(0.14640566706657d, 0.55479383468628d),
				new Jun2dPoint(0.33985838294029d, 0.62404829263687d),
				new Jun2dPoint(0.3869554400444d, 0.46531444787979d),
				new Jun2dPoint(0.55300289392471d, 0.20104123651981d),
				new Jun2dPoint(0.81759268045425d, 0.66796332597733d),
				new Jun2dPoint(0.87460225820541d, 0.41710120439529d),
				new Jun2dPoint(0.13219492137432d, 0.71376091241837d),
				new Jun2dPoint(0.71281963586807d, 0.53753435611725d),
				new Jun2dPoint(0.45321115851402d, 0.58229905366898d),
				new Jun2dPoint(0.90438985824585d, 0.25621825456619d),
				new Jun2dPoint(0.33166182041168d, 0.68174093961716d),
				new Jun2dPoint(0.71461892127991d, 0.69560182094574d),
				new Jun2dPoint(0.74713867902756d, 0.84882134199142d),
				new Jun2dPoint(0.83738440275192d, 0.4067055284977d),
				new Jun2dPoint(0.10780508071184d, 0.34884631633759d),
				new Jun2dPoint(0.39513537287712d, 0.3691211938858d),
				new Jun2dPoint(0.25039565563202d, 0.87569344043732d),
				new Jun2dPoint(0.93889212608337d, 0.99101209640503d),
				new Jun2dPoint(0.44021657109261d, 0.55181175470352d),
				new Jun2dPoint(0.44824656844139d, 0.10911286622286d),
				new Jun2dPoint(0.37114536762238d, 0.92822158336639d),
				new Jun2dPoint(0.33136191964149d, 0.98872971534729d),
				new Jun2dPoint(0.1656309813261d, 0.984514772892d),
				new Jun2dPoint(0.42497292160988d, 0.32374009490013d),
				new Jun2dPoint(0.37469387054443d, 0.12885464727879d),
				new Jun2dPoint(0.99438565969467d, 0.23659308254719d),
				new Jun2dPoint(0.97792583703995d, 0.19797584414482d),
				new Jun2dPoint(0.73347771167755d, 0.27830904722214d),
				new Jun2dPoint(0.3834902048111d, 0.45718449354172d),
				new Jun2dPoint(0.76469802856445d, 0.42847979068756d),
				new Jun2dPoint(0.42812162637711d, 0.60035818815231d),
				new Jun2dPoint(0.63906705379486d, 0.09526863694191d),
				new Jun2dPoint(0.37712618708611d, 0.74994587898254d),
				new Jun2dPoint(0.33617660403252d, 0.11541024595499d),
				new Jun2dPoint(0.92438149452209d, 0.45696792006493d) };
		JunVoronoi2dProcessor voronoi = new JunVoronoi2dProcessor(points);
		voronoi.trace_(true);
		voronoi.compute();
		System.out.println("area: " + voronoi.area());

		StImage anImage = new StImage(300, 300);
		Graphics aGraphics = null;
		try {
			aGraphics = anImage.image().getGraphics();
			aGraphics.setColor(Color.white);
			aGraphics.fillRect(0, 0, anImage.width(), anImage.height());

			Jun2dPoint scale = new Jun2dPoint(200, 200);
			Jun2dPoint translation = new Jun2dPoint(50, 50);
			StRectangle box = StRectangle.Origin_extent_(new Point(0, 0), new Point(1, 1));
			box = box.scaledBy_(scale.x(), scale.y());
			box = box.translatedBy_((int) translation.x(), (int) translation.y());
			aGraphics.setColor(Color.red);
			aGraphics.drawRect(box.x(), box.y(), box.width(), box.height());

			Jun2dPoint[][] triangles = voronoi.triangles();
			for (int i = 0; i < triangles.length; i++) {
				Jun2dPoint[] triangle = triangles[i];
				points = new Jun2dPoint[] { triangle[0], triangle[1], triangle[2], triangle[0] };
				int[] xPoints = new int[points.length];
				int[] yPoints = new int[points.length];
				for (int j = 0; j < points.length; j++) {
					points[j] = points[j].scaledBy_(scale).translatedBy_(translation);
					xPoints[j] = (int) points[j].x();
					yPoints[j] = (int) points[j].y();
				}
				aGraphics.setColor(Color.black);
				aGraphics.drawPolyline(xPoints, yPoints, points.length);
			}

		} finally {
			if (aGraphics != null) {
				aGraphics.dispose();
			}
		}

		anImage._display();

		return true;
	}

	/**
	 * Example6: Low precision
	 * 
	 * @return boolean
	 */
	public static boolean Example6() {
		Jun2dPoint[] points = new Jun2dPoint[9];
		points[0] = new Jun2dPoint(0.1d, 0.1d);
		points[1] = new Jun2dPoint(0.1d, 0.9d);
		points[2] = new Jun2dPoint(0.9d, 0.1d);
		points[3] = new Jun2dPoint(0.9d, 0.9d);
		points[4] = new Jun2dPoint(0.5d, 0.5d);
		points[5] = new Jun2dPoint(0.1d, 0.5d);
		points[6] = new Jun2dPoint(0.9d, 0.5d);
		points[7] = new Jun2dPoint(0.5d, 0.1d);
		points[8] = new Jun2dPoint(0.5d, 0.9d);
		JunVoronoi2dProcessor voronoi = new JunVoronoi2dProcessor(points);
		voronoi.trace_(true);
		voronoi.compute();
		System.out.println("area: " + voronoi.area());

		ShowTriangles(voronoi, new Jun2dPoint(200, 200), new Jun2dPoint(50, 50), StRectangle.Origin_extent_(new Point(0, 0), new Point(1, 1)));

		return true;
	}

	/**
	 * Example7: Low precision
	 * 
	 * @return boolean
	 */
	public static boolean Example7() {
		ArrayList aList = new ArrayList();
		int count = 0;
		for (int y = 0; y <= 10; y++) {
			for (int x = 0; x <= 10; x++) {
				if (count % 2 == 0) {
					aList.add(new Jun2dPoint(x / 10.0, y / 10.0));
				}
				count++;
			}
		}
		Jun2dPoint[] points = (Jun2dPoint[]) aList.toArray(new Jun2dPoint[aList.size()]);
		JunVoronoi2dProcessor voronoi = new JunVoronoi2dProcessor(points);
		voronoi.trace_(true);
		voronoi.compute();
		System.out.println("area: " + voronoi.area());

		ShowTriangles(voronoi, new Jun2dPoint(200, 200), new Jun2dPoint(50, 50), StRectangle.Origin_extent_(new Point(0, 0), new Point(1, 1)));

		return true;
	}

	/**
	 * Example8: Low precision
	 * 
	 * @return boolean
	 */
	public static boolean Example8() {
		ArrayList aList = new ArrayList();
		aList.add(new Jun2dPoint(0, 0));
		int step = 10;
		for (int degrees = 0; degrees <= 360; degrees += step) {
			JunAngle angle = JunAngle.FromDeg_(degrees);
			aList.add(new Jun2dPoint(angle.cos(), angle.sin()));
			angle = JunAngle.FromDeg_(degrees + step / 2);
			aList.add(new Jun2dPoint(angle.cos() * 0.5, angle.sin() * 0.5));
		}
		Jun2dPoint[] points = (Jun2dPoint[]) aList.toArray(new Jun2dPoint[aList.size()]);
		JunVoronoi2dProcessor voronoi = new JunVoronoi2dProcessor(points);
		voronoi.trace_(true);
		voronoi.compute();
		System.out.println("area: " + voronoi.area());

		ShowTriangles(voronoi, new Jun2dPoint(100, 100), new Jun2dPoint(150, 150), StRectangle.Origin_corner_(new Point(-1, -1), new Point(1, 1)));

		return true;
	}

	/**
	 * Example9: Low precision
	 * 
	 * @return boolean
	 */
	public static boolean Example9() {
		Jun2dPoint[] points = new Jun2dPoint[] {
				new Jun2dPoint(0.0, 0.0d),
				new Jun2dPoint(0.5, 0.0d),
				new Jun2dPoint(0.43301270189222, 0.25d),
				new Jun2dPoint(0.86602540378444, 0.0d),
				new Jun2dPoint(0.75, 0.43301270189222d),
				new Jun2dPoint(1.0, 0.0d),
				new Jun2dPoint(0.86602540378444, 0.5d),
				new Jun2dPoint(0.25, 0.43301270189222d),
				new Jun2dPoint(0.43301270189222, 0.75d),
				new Jun2dPoint(0.5, 0.86602540378444d),
				new Jun2dPoint(0.0, 0.5d),
				new Jun2dPoint(0.0, 0.86602540378444d),
				new Jun2dPoint(0.0, 1.0d),
				new Jun2dPoint(-0.25, 0.43301270189222d),
				new Jun2dPoint(-0.43301270189222, 0.75d),
				new Jun2dPoint(-0.5, 0.86602540378444d),
				new Jun2dPoint(-0.43301270189222, 0.25d),
				new Jun2dPoint(-0.75, 0.43301270189222d),
				new Jun2dPoint(-0.86602540378444, 0.5d),
				new Jun2dPoint(-0.5, 0.0d),
				new Jun2dPoint(-0.86602540378444, 0.0d),
				new Jun2dPoint(-1.0, 0.0d),
				new Jun2dPoint(-0.43301270189222, -0.25d),
				new Jun2dPoint(-0.75, -0.43301270189222d),
				new Jun2dPoint(-0.86602540378444, -0.5d),
				new Jun2dPoint(-0.25, -0.43301270189222d),
				new Jun2dPoint(-0.43301270189222, -0.75d),
				new Jun2dPoint(-0.5, -0.86602540378444d),
				new Jun2dPoint(0.0, -0.5d),
				new Jun2dPoint(0.0, -0.86602540378444d),
				new Jun2dPoint(0.0, -1.0d),
				new Jun2dPoint(0.25, -0.43301270189222d),
				new Jun2dPoint(0.43301270189222, -0.75d),
				new Jun2dPoint(0.5, -0.86602540378444d),
				new Jun2dPoint(0.43301270189222, -0.25d),
				new Jun2dPoint(0.75, -0.43301270189222d),
				new Jun2dPoint(0.86602540378444, -0.5d) };
		JunVoronoi2dProcessor voronoi = new JunVoronoi2dProcessor(points);
		voronoi.trace_(true);
		voronoi.compute();
		System.out.println("area: " + voronoi.area());

		ShowTriangles(voronoi, new Jun2dPoint(100, 100), new Jun2dPoint(150, 150), StRectangle.Origin_corner_(new Point(-1, -1), new Point(1, 1)));

		return true;
	}

	/**
	 * Show the triangles.
	 * 
	 * @param voronoi
	 * @param scale
	 * @param translation
	 * @param box
	 * @category
	 */
	protected static void ShowTriangles(JunVoronoi2dProcessor voronoi, Jun2dPoint scale, Jun2dPoint translation, StRectangle box) {
		box = box.scaledBy_(scale.x(), scale.y());
		box = box.translatedBy_((int) translation.x(), (int) translation.y());

		StImage anImage = new StImage(300, 300);
		Graphics aGraphics = null;
		try {
			aGraphics = anImage.image().getGraphics();
			aGraphics.setColor(Color.white);
			aGraphics.fillRect(0, 0, anImage.width(), anImage.height());
			aGraphics.setColor(Color.red);
			aGraphics.drawRect(box.x(), box.y(), box.width(), box.height());

			Jun2dPoint[][] triangles = voronoi.triangles();
			for (int i = 0; i < triangles.length; i++) {
				Jun2dPoint[] triangle = triangles[i];
				Jun2dPoint[] points = new Jun2dPoint[] { triangle[0], triangle[1], triangle[2], triangle[0] };
				int[] xPoints = new int[points.length];
				int[] yPoints = new int[points.length];
				for (int j = 0; j < points.length; j++) {
					points[j] = points[j].scaledBy_(scale).translatedBy_(translation);
					xPoints[j] = (int) points[j].x();
					yPoints[j] = (int) points[j].y();
				}
				aGraphics.setColor(Color.black);
				aGraphics.drawPolyline(xPoints, yPoints, points.length);
			}

		} finally {
			if (aGraphics != null) {
				aGraphics.dispose();
			}
		}

		anImage._display();
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunVoronoi2dProcessorTestExamples();
	}

}
