package jp.co.sra.jun.voronoi.twoD.diagram;

import java.io.IOException;
import java.io.Writer;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;

/**
 * JunVoronoi2dTriangle class
 * 
 *  @author    NISHIHARA Satoshi
 *  @created   2000/01/25 (by NISHIHARA Satoshi)
 *  @updated   2006/11/07 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVoronoi2dTriangle.java,v 8.10 2008/02/20 06:33:14 nisinaka Exp $
 */
public class JunVoronoi2dTriangle extends JunVoronoi2dObject {

	protected JunVoronoi2dDot dot1;
	protected JunVoronoi2dDot dot2;
	protected JunVoronoi2dDot dot3;

	/**
	 * Create a new instance of JunVoronoi2dTriangle and initialize it.
	 *
	 * @param dot1 jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dDot
	 * @param dot2 jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dDot
	 * @param dot3 jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dDot
	 * @category Instance creation
	 */
	public JunVoronoi2dTriangle(JunVoronoi2dDot dot1, JunVoronoi2dDot dot2, JunVoronoi2dDot dot3) {
		this.dot1_(dot1);
		this.dot2_(dot2);
		this.dot3_(dot3);
	}

	/**
	 * Create a new instance of JunVoronoi2dTriangle and initialize it.
	 *
	 * @param point1 jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @param point2 jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @param point3 jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @category Instance creation
	 */
	public JunVoronoi2dTriangle(Jun2dPoint point1, Jun2dPoint point2, Jun2dPoint point3) {
		this(new JunVoronoi2dDot(point1), new JunVoronoi2dDot(point2), new JunVoronoi2dDot(point3));
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dObject#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		dot1 = null;
		dot2 = null;
		dot3 = null;
	}

	/**
	 * Answer my current dot1.
	 * 
	 * @return jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dDot
	 * @category accessing
	 */
	public JunVoronoi2dDot dot1() {
		return dot1;
	}

	/**
	 * Set my new dot1.
	 * 
	 * @param voronoi2dDot jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dDot
	 * @category accessing
	 */
	public void dot1_(JunVoronoi2dDot voronoi2dDot) {
		dot1 = voronoi2dDot;
	}

	/**
	 * Answer my current dot2.
	 * 
	 * @return jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dDot
	 * @category accessing
	 */
	public JunVoronoi2dDot dot2() {
		return dot2;
	}

	/**
	 * Set my new dot2.
	 * 
	 * @param voronoi2dDot jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dDot
	 * @category accessing
	 */
	public void dot2_(JunVoronoi2dDot voronoi2dDot) {
		dot2 = voronoi2dDot;
	}

	/**
	 * Answer my current dot3.
	 * 
	 * @return jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dDot
	 * @category accessing
	 */
	public JunVoronoi2dDot dot3() {
		return dot3;
	}

	/**
	 * Set my new dot3.
	 * 
	 * @param voronoi2dDot jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dDot
	 * @category accessing
	 */
	public void dot3_(JunVoronoi2dDot voronoi2dDot) {
		dot3 = voronoi2dDot;
	}

	/**
	 * Answer my area.
	 * 
	 * @return double
	 * @category functions
	 */
	public double area() {
		return Math.abs(this.areaWithSign());
	}

	/**
	 * Answer my area with sign.
	 * 
	 * @return double
	 * @category functions
	 */
	public double areaWithSign() {
		double x1 = dot1.x();
		double y1 = dot1.y();
		double x2 = dot2.x();
		double y2 = dot2.y();
		double x3 = dot3.x();
		double y3 = dot3.y();
		return ((x1 - x2) * (y1 + y2) + (x2 - x3) * (y2 + y3) + (x3 - x1) * (y3 + y1)) * 0.5;
	}

	/**
	 * Print my string representation on the writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws java.io.IOException
	 * @see jp.co.sra.smalltalk.StObject#printOn_(java.io.Writer)
	 * @category printing
	 */
	public void printOn_(Writer aWriter) throws IOException {
		aWriter.write("triangle ( ");
		dot1.printOn_(aWriter);
		aWriter.write(" , ");
		dot2.printOn_(aWriter);
		aWriter.write(" , ");
		dot3.printOn_(aWriter);
		aWriter.write(" )");
	}

}
