package jp.co.sra.jun.voronoi.twoD.diagram;

import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunVoronoi2dTriangleTestExamples class
 * 
 *  @author    NISHIHARA Satoshi
 *  @created   2000/01/25 (by NISHIHARA Satoshi)
 *  @updated   2006/11/07 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVoronoi2dTriangleTestExamples.java,v 8.10 2008/02/20 06:33:14 nisinaka Exp $
 */
public class JunVoronoi2dTriangleTestExamples extends JunTestExamples {

	/**
	 * Example1:
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		JunVoronoi2dTriangle triangle = new JunVoronoi2dTriangle(new JunVoronoi2dDot(0, 0), new JunVoronoi2dDot(1, 1), new JunVoronoi2dDot(1, -1));
		System.out.println(triangle);

		return true;
	}

	/**
	 * Example2:
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		JunVoronoi2dTriangle triangle = new JunVoronoi2dTriangle(new JunVoronoi2dDot(0, 0), new JunVoronoi2dDot(2, 2), new JunVoronoi2dDot(2, -2));
		double areaWithSign = triangle.areaWithSign();
		if (areaWithSign > 0) {
			System.out.println(areaWithSign + " --- counterclockwise (ccw)");
		} else {
			System.out.println(areaWithSign + " --- clockwise (cw)");
		}

		triangle = new JunVoronoi2dTriangle(new JunVoronoi2dDot(0, 0), new JunVoronoi2dDot(2, -2), new JunVoronoi2dDot(2, 2));
		areaWithSign = triangle.areaWithSign();
		if (areaWithSign > 0) {
			System.out.println(areaWithSign + " --- counterclockwise (ccw)");
		} else {
			System.out.println(areaWithSign + " --- clockwise (cw)");
		}

		System.out.println(triangle.area());

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunVoronoi2dTriangleTestExamples();
	}

}
