package jp.co.sra.jun.vrml.node.geometry10;

import java.util.Hashtable;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.vrml.field.sf.JunVrmlSFFloatField;
import jp.co.sra.jun.vrml.node.abstracts.*;
import jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor;

/**
 * JunVrmlCubeNode class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   2000/03/27 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlCubeNode.java,v 8.10 2008/02/20 06:33:15 nisinaka Exp $
 */
public class JunVrmlCubeNode extends JunVrmlAbstractGeometryNode {
	protected JunVrmlSFFloatField widthField;
	protected JunVrmlSFFloatField heightField;
	protected JunVrmlSFFloatField depthField;

	/**
	 * Create a new instance of JunVrmlCubeNode and initialize it.
	 * 
	 * @param aDictionary java.util.Hashtable
	 */
	public JunVrmlCubeNode(Hashtable aDictionary) {
		if (aDictionary.containsKey($("depth"))) {
			depthField = new JunVrmlSFFloatField(aDictionary.get($("depth")));
		}

		if (aDictionary.containsKey($("height"))) {
			heightField = new JunVrmlSFFloatField(aDictionary.get($("height")));
		}

		if (aDictionary.containsKey($("width"))) {
			widthField = new JunVrmlSFFloatField(aDictionary.get($("width")));
		}
	}

	/**
	 * Answer the default value of depth.
	 * 
	 * @return float
	 */
	public static final float DefaultDepth() {
		return 2;
	}

	/**
	 * Answer the default value of height.
	 * 
	 * @return float
	 */
	public static final float DefaultHeight() {
		return 2;
	}

	/**
	 * Answer the default value of width.
	 * 
	 * @return float
	 */
	public static final float DefaultWidth() {
		return 2;
	}

	/**
	 * Convert to a JunOpenGL3dObject.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 */
	public JunOpenGL3dObject asJunOpenGL3dObject() {
		Jun3dPoint origin = new Jun3dPoint(this.width() / -2, this.height() / -2, this.depth() / -2);
		Jun3dPoint extent = new Jun3dPoint(this.width(), this.height(), this.depth());

		return JunOpenGL3dObject.Origin_extent_(origin, extent);
	}

	/**
	 * Answer the depth.
	 * 
	 * @return float
	 */
	public float depth() {
		return this.depthField().value();
	}

	/**
	 * Answer the height.
	 * 
	 * @return float
	 */
	public float height() {
		return this.heightField().value();
	}

	/**
	 * Process myself with the generator.
	 * 
	 * @param aVisitor jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor
	 */
	public void nodeDo_(JunVrmlNodeVisitor aVisitor) {
		try {
			aVisitor.perform_with_("doCube_", this);
		} catch (Exception e) {
			super.nodeDo_(aVisitor);
		}
	}

	/**
	 * Answer the width.
	 * 
	 * @return float
	 */
	public float width() {
		return this.widthField().value();
	}

	/**
	 * Answer the depth.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFFloatField
	 */
	protected JunVrmlSFFloatField depthField() {
		if (depthField == null) {
			depthField = new JunVrmlSFFloatField(DefaultDepth());
		}

		return depthField;
	}

	/**
	 * Answer the height.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFFloatField
	 */
	protected JunVrmlSFFloatField heightField() {
		if (heightField == null) {
			heightField = new JunVrmlSFFloatField(DefaultHeight());
		}

		return heightField;
	}

	/**
	 * Answer the width.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFFloatField
	 */
	protected JunVrmlSFFloatField widthField() {
		if (widthField == null) {
			widthField = new JunVrmlSFFloatField(DefaultWidth());
		}

		return widthField;
	}
}
