package jp.co.sra.jun.vrml.node.geometry20;

import java.util.*;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.objects.*;
import jp.co.sra.jun.vrml.field.mf.JunVrmlMFInt32Field;
import jp.co.sra.jun.vrml.field.sf.JunVrmlSFBoolField;
import jp.co.sra.jun.vrml.node.abstracts.*;
import jp.co.sra.jun.vrml.node.property20.*;
import jp.co.sra.jun.vrml.support.*;

/**
 * JunVrmlIndexedLineSetNode20 class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   2000/04/14 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlIndexedLineSetNode20.java,v 8.10 2008/02/20 06:33:16 nisinaka Exp $
 */
public class JunVrmlIndexedLineSetNode20 extends JunVrmlAbstractGeometryNode {
	protected JunVrmlColorNode color;
	protected JunVrmlCoordinateNode coord;
	protected JunVrmlMFInt32Field colorIndexField;
	protected JunVrmlSFBoolField colorPerVertexField;
	protected JunVrmlMFInt32Field coordIndexField;

	/**
	 * Create a new instance of JunVrmlIndexedLineSetNode20 and initialize it.
	 * 
	 * @param aDictionary java.util.Hashtable
	 */
	public JunVrmlIndexedLineSetNode20(Hashtable aDictionary) {
		if (aDictionary.containsKey($("color"))) {
			this.color_((JunVrmlColorNode) aDictionary.get($("color")));
		}

		if (aDictionary.containsKey($("coord"))) {
			this.coord_((JunVrmlCoordinateNode) aDictionary.get($("coord")));
		}

		if (aDictionary.containsKey($("colorIndex"))) {
			colorIndexField = new JunVrmlMFInt32Field(aDictionary.get($("colorIndex")));
		}

		if (aDictionary.containsKey($("colorPerVertex"))) {
			colorPerVertexField = new JunVrmlSFBoolField(aDictionary.get($("colorPerVertex")));
		}

		if (aDictionary.containsKey($("coordIndex"))) {
			coordIndexField = new JunVrmlMFInt32Field(aDictionary.get($("coordIndex")));
		}
	}

	/**
	 * Answer the default value of colorIndex.
	 * 
	 * @return int[]
	 */
	public static final int[] DefaultColorIndex() {
		return new int[] {
		};
	}

	/**
	 * Answer the default value of colorPerVertex.
	 * 
	 * @return boolean
	 */
	public static final boolean DefaultColorPerVertex() {
		return true;
	}

	/**
	 * Answer the default value of coordIndex.
	 * 
	 * @return final java.lang.Integer[]
	 */
	public static final Integer[] DefaultCoordIndex() {
		return new Integer[0];
	}

	/**
	 * Convert to a JunOpenGL3dObject.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 */
	public JunOpenGL3dObject asJunOpenGL3dObject() {
		JunVrmlCoordinateNode aCoordinateNode = this.coord();

		if (aCoordinateNode == null) {
			return null;
		}

		Jun3dPoint[] pointArray = aCoordinateNode.pointAs3dPoints();
		int[][] coordIndexAsPointArray = this.coordIndexAsPointArray();
		JunOpenGL3dObject[] objects = new JunOpenGL3dObject[coordIndexAsPointArray.length];

		for (int i = 0; i < coordIndexAsPointArray.length; i++) {
			int[] indexes = coordIndexAsPointArray[i];
			Jun3dPoint[] vertexes = new Jun3dPoint[indexes.length];

			for (int j = 0; j < indexes.length; j++) {
				vertexes[j] = pointArray[indexes[j]];
			}

			objects[i] = new JunOpenGL3dPolyline(vertexes);
		}

		if (objects.length == 0) {
			return null;
		}

		if (objects.length == 1) {
			return (JunOpenGL3dObject) objects[0];
		}

		return new JunOpenGL3dCompoundObject(objects);
	}

	/**
	 * Answer the color node.
	 * 
	 * @return jp.co.sra.jun.vrml.node.property20.JunVrmlColorNode
	 */
	public JunVrmlColorNode color() {
		return color;
	}

	/**
	 * Set the color node.
	 * 
	 * @param aNode jp.co.sra.jun.vrml.node.property20.JunVrmlColorNode
	 */
	public void color_(JunVrmlColorNode aNode) {
		color = aNode;
	}

	/**
	 * Answer the colorIndex.
	 * 
	 * @return int[]
	 */
	public int[] colorIndex() {
		return this.colorIndexField().value();
	}

	/**
	 * Answer the colorPerVertex.
	 * 
	 * @return boolean
	 */
	public boolean colorPerVertex() {
		return this.colorPerVertexField().value();
	}

	/**
	 * Answer the coordinate node.
	 * 
	 * @return jp.co.sra.jun.vrml.node.property20.JunVrmlCoordinateNode
	 */
	public JunVrmlCoordinateNode coord() {
		return coord;
	}

	/**
	 * Set the coordinate node.
	 * 
	 * @param aJunVrmlCoordinateNode
	 *        jp.co.sra.jun.vrml.node.property20.JunVrmlCoordinateNode
	 */
	public void coord_(JunVrmlCoordinateNode aJunVrmlCoordinateNode) {
		coord = aJunVrmlCoordinateNode;
	}

	/**
	 * Answer the coordIndex.
	 * 
	 * @return int[]
	 */
	public int[] coordIndex() {
		return this.coordIndexField().value();
	}

	/**
	 * Answer the point array of the coordIndex.
	 * 
	 * @return int[][]
	 */
	public int[][] coordIndexAsPointArray() {
		return this.coordIndexField().asPointArray();
	}

	/**
	 * Process myself with the generator.
	 * 
	 * @param aVisitor jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor
	 */
	public void nodeDo_(JunVrmlNodeVisitor aVisitor) {
		try {
			aVisitor.perform_with_("doIndexedLineSet_", this);
		} catch (Exception e) {
			super.nodeDo_(aVisitor);
		}
	}

	/**
	 * Answer the colorIndex field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.mf.JunVrmlMFInt32Field
	 */
	protected JunVrmlMFInt32Field colorIndexField() {
		if (colorIndexField == null) {
			colorIndexField = new JunVrmlMFInt32Field(DefaultColorIndex());
		}

		return colorIndexField;
	}

	/**
	 * Answer the colorPerVertex field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFBoolField
	 */
	protected JunVrmlSFBoolField colorPerVertexField() {
		if (colorPerVertexField == null) {
			colorPerVertexField = new JunVrmlSFBoolField(DefaultColorPerVertex());
		}

		return colorPerVertexField;
	}

	/**
	 * Answer the coordIndex field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.mf.JunVrmlMFInt32Field
	 */
	protected JunVrmlMFInt32Field coordIndexField() {
		if (coordIndexField == null) {
			coordIndexField = new JunVrmlMFInt32Field(DefaultCoordIndex());
		}

		return coordIndexField;
	}
}
