package jp.co.sra.jun.vrml.node.geometry20;

import java.util.Hashtable;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.vrml.field.mf.*;
import jp.co.sra.jun.vrml.field.sf.JunVrmlSFFloatField;
import jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractGeometryNode;
import jp.co.sra.jun.vrml.node.property20.JunVrmlFontStyleNode20;

/**
 * JunVrmlTextNode class
 * 
 *  @author    nisinaka
 *  @created   2003/09/30 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlTextNode.java,v 8.10 2008/02/20 06:33:16 nisinaka Exp $
 */
public class JunVrmlTextNode extends JunVrmlAbstractGeometryNode {

	protected JunVrmlMFStringField stringField;
	protected JunVrmlFontStyleNode20 fontStyle;
	protected JunVrmlMFFloatField lengthField;
	protected JunVrmlSFFloatField maxExtentField;

	/**
	 * Create a new instance of JunVrmlTextNode and initialize it.
	 * 
	 * @param aDictionary java.util.Hashtable
	 * @category Instance creation
	 */
	public JunVrmlTextNode(Hashtable aDictionary) {
		if (aDictionary.containsKey($("string"))) {
			stringField = new JunVrmlMFStringField(aDictionary.get($("string")));
		}

		if (aDictionary.containsKey($("fontStyle"))) {
			fontStyle = (JunVrmlFontStyleNode20) aDictionary.get($("fontStyle"));
		}

		if (aDictionary.containsKey($("length"))) {
			lengthField = new JunVrmlMFFloatField(aDictionary.get($("length")));
		}

		if (aDictionary.containsKey($("maxExtent"))) {
			maxExtentField = new JunVrmlSFFloatField(aDictionary.get($("maxExtent")));
		}
	}

	/**
	 * Answer the default value of string field.
	 * 
	 * @return java.lang.String[]
	 * @category Defaults
	 */
	public static final String[] DefaultString() {
		return new String[0];
	}

	/**
	 * Answer the default node of fontStyle field.
	 * 
	 * @return jp.co.sra.jun.vrml.node.property20.JunVrmlFontStyleNode20
	 * @category Defaults
	 */
	public static final JunVrmlFontStyleNode20 DefaultFontStyle() {
		return null;
	}

	/**
	 * Ansewr the default value of length field.
	 * 
	 * @return float[]
	 * @category Defaults
	 */
	public static final float[] DefaultLength() {
		return new float[0];
	}

	/**
	 * Ansewr the default value of maxExtent field.
	 * 
	 * @return float
	 * @category Defaults
	 */
	public static final float DefaultMaxExtent() {
		return 0.0f;
	}

	/**
	 * Answer the value of the string field.
	 * 
	 * @return java.lang.String[]
	 * @category accessing
	 */
	public String[] string() {
		return this.stringField().value();
	}

	/**
	 * Answer the string field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.mf.JunVrmlMFStringField
	 * @category accessing
	 */
	protected JunVrmlMFStringField stringField() {
		if (stringField == null) {
			stringField = new JunVrmlMFStringField(DefaultString());
		}
		return stringField;
	}

	/**
	 * Answer the default node of fontStyle field.
	 * 
	 * @return jp.co.sra.jun.vrml.node.property20.JunVrmlFontStyleNode20
	 */
	public JunVrmlFontStyleNode20 fontStyle() {
		if (fontStyle == null) {
			fontStyle = DefaultFontStyle();
		}
		return fontStyle;
	}

	/**
	 * Answer the value of the maxExtent field.
	 * 
	 * @return float
	 * @category accessing
	 */
	public float maxExtent() {
		return this.maxExtentField().value();
	}

	/**
	 * Answer the maxExtent field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFFloatField
	 * @category accessing
	 */
	protected JunVrmlSFFloatField maxExtentField() {
		if (maxExtentField == null) {
			maxExtentField = new JunVrmlSFFloatField(DefaultMaxExtent());
		}
		return maxExtentField;
	}

	/**
	 * Convert the geometry node as a JunOpenGL3dObject.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @see jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractGeometryNode#asJunOpenGL3dObject()
	 * @category code generation
	 */
	public JunOpenGL3dObject asJunOpenGL3dObject() {
		// Does not support now.
		return null;
	}

}
