package jp.co.sra.jun.vrml.node.property10;

import java.awt.Color;
import java.util.Hashtable;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.vrml.field.mf.*;
import jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor;

/**
 * JunVrmlMaterialNode10 class
 * 
 *  @author    nisinaka
 *  @created   2000/04/14 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlMaterialNode10.java,v 8.10 2008/02/20 06:33:16 nisinaka Exp $
 */
public class JunVrmlMaterialNode10 extends jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractPropertyNode {
	protected JunVrmlMFColorField ambientColorField;
	protected JunVrmlMFColorField diffuseColorField;
	protected JunVrmlMFColorField specularColorField;
	protected JunVrmlMFColorField emissiveColorField;
	protected JunVrmlMFFloatField shininessField;
	protected JunVrmlMFFloatField transparencyField;

	/**
	 * Create a new instance of JunVrmlMaterialNode10 and initialize it.
	 * 
	 * @param aDictionary java.util.Hashtable
	 */
	public JunVrmlMaterialNode10(Hashtable aDictionary) {
		if (aDictionary.containsKey($("ambientColor"))) {
			ambientColorField = new JunVrmlMFColorField(aDictionary.get($("ambientColor")));
		}

		if (aDictionary.containsKey($("diffuseColor"))) {
			diffuseColorField = new JunVrmlMFColorField(aDictionary.get($("diffuseColor")));
		}

		if (aDictionary.containsKey($("specularColor"))) {
			specularColorField = new JunVrmlMFColorField(aDictionary.get($("specularColor")));
		}

		if (aDictionary.containsKey($("emissiveColor"))) {
			emissiveColorField = new JunVrmlMFColorField(aDictionary.get($("emissiveColor")));
		}

		if (aDictionary.containsKey($("shininess"))) {
			shininessField = new JunVrmlMFFloatField(aDictionary.get($("shininess")));
		}

		if (aDictionary.containsKey($("transparency"))) {
			transparencyField = new JunVrmlMFFloatField(aDictionary.get($("transparency")));
		}
	}

	/**
	 * Answer the default value of ambient color.
	 * 
	 * @return float[]
	 */
	public static final float[] DefaultAmbientColor() {
		return new float[] { 0.2f, 0.2f, 0.2f };
	}

	/**
	 * Answer the default value of diffuse color.
	 * 
	 * @return float[]
	 */
	public static final float[] DefaultDiffuseColor() {
		return new float[] { 0.8f, 0.8f, 0.8f };
	}

	/**
	 * Answer the default value of emissive color.
	 * 
	 * @return float[]
	 */
	public static final float[] DefaultEmissiveColor() {
		return new float[] { 0, 0, 0 };
	}

	/**
	 * Answer the default value of shininess.
	 * 
	 * @return float[]
	 */
	public static final float[] DefaultShininess() {
		return new float[] { 0.2f };
	}

	/**
	 * Answer the default value of specular color.
	 * 
	 * @return float[]
	 */
	public static final float[] DefaultSpecularColor() {
		return new float[] { 0, 0, 0 };
	}

	/**
	 * Answer the default value of transparency.
	 * 
	 * @return float[]
	 */
	public static final float[] DefaultTransparency() {
		return new float[] { 0 };
	}

	/**
	 * Answer the ambient color.
	 * 
	 * @return float[]
	 */
	public float[] ambientColor() {
		return this.ambientColorField().value();
	}

	/**
	 * Answer the diffuse color.
	 * 
	 * @return float[]
	 */
	public float[] diffuseColor() {
		return this.diffuseColorField().value();
	}

	/**
	 * Answer the diffuse color as an instance of Color.
	 * 
	 * @return java.awt.Color
	 */
	public Color diffuseColorAsColor() {
		return (this.diffuseColorField().asColors())[0];
	}

	/**
	 * Answer the emissive color.
	 * 
	 * @return float[]
	 */
	public float[] emissiveColor() {
		return this.emissiveColorField().value();
	}

	/**
	 * Process myself with the generator.
	 * 
	 * @param aVisitor jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor
	 */
	public void nodeDo_(JunVrmlNodeVisitor aVisitor) {
		try {
			aVisitor.perform_with_("doMaterial_", this);
		} catch (Exception e) {
			super.nodeDo_(aVisitor);
		}
	}

	/**
	 * Set my properties on the JunOpenGL3dObject.
	 * 
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 */
	public void propertyOn_(JunOpenGL3dObject a3dObject) {
		a3dObject.paint_(this.diffuseColorAsColor());
	}

	/**
	 * Answer the shininess.
	 * 
	 * @return float[]
	 */
	public float[] shininess() {
		return this.shininessField().value();
	}

	/**
	 * Answer the specular color.
	 * 
	 * @return float[]
	 */
	public float[] specularColor() {
		return this.specularColorField().value();
	}

	/**
	 * Answer the transparency.
	 * 
	 * @return float[]
	 */
	public float[] transparency() {
		return this.transparencyField().value();
	}

	/**
	 * Answer the ambientColor field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.mf.JunVrmlMFColorField
	 */
	protected JunVrmlMFColorField ambientColorField() {
		if (ambientColorField == null) {
			ambientColorField = new JunVrmlMFColorField(DefaultAmbientColor());
		}

		return ambientColorField;
	}

	/**
	 * Answer the diffuseColor field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.mf.JunVrmlMFColorField
	 */
	protected JunVrmlMFColorField diffuseColorField() {
		if (diffuseColorField == null) {
			diffuseColorField = new JunVrmlMFColorField(DefaultDiffuseColor());
		}

		return diffuseColorField;
	}

	/**
	 * Answer the emissiveColor field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.mf.JunVrmlMFColorField
	 */
	protected JunVrmlMFColorField emissiveColorField() {
		if (emissiveColorField == null) {
			emissiveColorField = new JunVrmlMFColorField(DefaultEmissiveColor());
		}

		return emissiveColorField;
	}

	/**
	 * Answer the shininess field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.mf.JunVrmlMFFloatField
	 */
	protected JunVrmlMFFloatField shininessField() {
		if (shininessField == null) {
			shininessField = new JunVrmlMFFloatField(DefaultShininess());
		}

		return shininessField;
	}

	/**
	 * Answer the specularColor field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.mf.JunVrmlMFColorField
	 */
	protected JunVrmlMFColorField specularColorField() {
		if (specularColorField == null) {
			specularColorField = new JunVrmlMFColorField(DefaultSpecularColor());
		}

		return specularColorField;
	}

	/**
	 * Answer the transparency field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.mf.JunVrmlMFFloatField
	 */
	protected JunVrmlMFFloatField transparencyField() {
		if (transparencyField == null) {
			transparencyField = new JunVrmlMFFloatField(DefaultTransparency());
		}

		return transparencyField;
	}
}
