package jp.co.sra.jun.vrml.node.property20;

import java.awt.Color;
import java.util.Hashtable;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.vrml.field.mf.JunVrmlMFColorField;
import jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractPropertyNode;
import jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor;

/**
 * JunVrmlColorNode class
 * 
 *  @author    nisinaka
 *  @created   2000/03/29 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlColorNode.java,v 8.10 2008/02/20 06:33:17 nisinaka Exp $
 */
public class JunVrmlColorNode extends JunVrmlAbstractPropertyNode {

	protected JunVrmlMFColorField colorField;

	/**
	 * The default constructor.
	 * 
	 * @category Instance creation
	 */
	public JunVrmlColorNode() {
	}

	/**
	 * Create a new instance of JunVrmlColorNode and initialize it.
	 * 
	 * @param aDictionary java.util.Hashtable
	 * @category Instance creation
	 */
	public JunVrmlColorNode(Hashtable aDictionary) {
		if (aDictionary.containsKey($("color"))) {
			colorField = new JunVrmlMFColorField(aDictionary.get($("color")));
		}
	}

	/**
	 * Answer the default value of color.
	 * 
	 * @return float[]
	 * @category Defaults
	 */
	public static final float[] DefaultColor() {
		return new float[] {
		};
	}

	/**
	 * Answer the color value.
	 * 
	 * @return float[]
	 * @category accessing
	 */
	public float[] color() {
		return this.colorField().value();
	}

	/**
	 * Answer the color field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.mf.JunVrmlMFColorField
	 * @category accessing
	 */
	protected JunVrmlMFColorField colorField() {
		if (colorField == null) {
			colorField = new JunVrmlMFColorField(DefaultColor());
		}
		return colorField;
	}

	/**
	 * Set my properties on the JunOpenGL3dObject.
	 * 
	 * @param anOpenGL3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category code generation
	 */
	public void propertyOn_(JunOpenGL3dObject anOpenGL3dObject) {
		anOpenGL3dObject.paint_(this.colorField().asColors()[0]);
	}

	/**
	 * Answer the color field values as an array of Color.
	 * 
	 * @return java.awt.Color
	 * @category code generation
	 */
	public Color[] colorAsColors() {
		return this.colorField().asColors();
	}

	/**
	 * Process myself with the generator.
	 * 
	 * @param aVisitor jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor
	 * @category enumerating
	 */
	public void nodeDo_(JunVrmlNodeVisitor aVisitor) {
		try {
			aVisitor.perform_with_("doColor_", this);
		} catch (Exception e) {
			super.nodeDo_(aVisitor);
		}
	}

}
