package jp.co.sra.jun.vrml.node.property20;

import java.awt.Color;
import java.util.Hashtable;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayLight;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.vrml.field.sf.*;
import jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractPropertyNode;
import jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor;

/**
 * JunVrmlPointLightNode20 class
 * 
 *  @author    nisinaka
 *  @created   2003/11/27 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlPointLightNode20.java,v 8.10 2008/02/20 06:33:17 nisinaka Exp $
 */
public class JunVrmlPointLightNode20 extends JunVrmlAbstractPropertyNode {

	protected JunVrmlSFFloatField ambientIntensityField;
	protected JunVrmlSFVec3fField attenuationField;
	protected JunVrmlSFColorField colorField;
	protected JunVrmlSFFloatField intensityField;
	protected JunVrmlSFVec3fField locationField;
	protected JunVrmlSFBoolField onField;
	protected JunVrmlSFFloatField radiusField;

	/**
	 * Create a new instance of JunVrmlPointLightNode20 and initialize it.
	 * 
	 * @param aDictionary java.util.Hashtable
	 * @category Instance creation
	 */
	public JunVrmlPointLightNode20(Hashtable aDictionary) {
		if (aDictionary.containsKey($("ambientIntensity"))) {
			ambientIntensityField = new JunVrmlSFFloatField(aDictionary.get($("ambientIntensity")));
		}

		if (aDictionary.containsKey($("attenuation"))) {
			attenuationField = new JunVrmlSFVec3fField(aDictionary.get($("attenuation")));
		}

		if (aDictionary.containsKey($("color"))) {
			colorField = new JunVrmlSFColorField(aDictionary.get($("color")));
		}

		if (aDictionary.containsKey($("intensity"))) {
			intensityField = new JunVrmlSFFloatField(aDictionary.get($("intensity")));
		}

		if (aDictionary.containsKey($("location"))) {
			locationField = new JunVrmlSFVec3fField(aDictionary.get($("location")));
		}

		if (aDictionary.containsKey($("on"))) {
			onField = new JunVrmlSFBoolField(aDictionary.get($("on")));
		}

		if (aDictionary.containsKey($("radius"))) {
			radiusField = new JunVrmlSFFloatField(aDictionary.get($("radius")));
		}
	}

	/**
	 * Answer the default value of ambientIntensity.
	 * 
	 * @return float
	 * @category Defaults
	 */
	public static final float DefaultAmbientIntensity() {
		return 0;
	}

	/**
	 * Answer the default value of attenuation.
	 * 
	 * @return float[]
	 * @category Defaults
	 */
	public static final float[] DefaultAttenuation() {
		return new float[] { 1, 0, 0 };
	}

	/**
	 * Answer the default value of color.
	 * 
	 * @return float[]
	 * @category Defaults
	 */
	public static final float[] DefaultColor() {
		return new float[] { 1, 1, 1 };
	}

	/**
	 * Answer the default value of intensity.
	 * 
	 * @return float
	 * @category Defaults
	 */
	public static final float DefaultIntensity() {
		return 1;
	}

	/**
	 * Answer the default value of location.
	 * 
	 * @return float[]
	 * @category Defaults
	 */
	public static final float[] DefaultLocation() {
		return new float[] { 0, 0, 0 };
	}

	/**
	 * Answer the default value of on.
	 * 
	 * @return boolean
	 * @category Defaults
	 */
	public static final boolean DefaultOn() {
		return true;
	}

	/**
	 * Answer the default value of radius.
	 * 
	 * @return float
	 * @category Defaults
	 */
	public static final float DefaultRadius() {
		return 100;
	}

	/**
	 * Answer the value of the ambientIntensity field.
	 * 
	 * @return float
	 * @category accessing
	 */
	public float ambientIntensity() {
		return this.ambientIntensityField().value();
	}

	/**
	 * Answer the ambientIntensity field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFFloatField
	 * @category accessing
	 */
	protected JunVrmlSFFloatField ambientIntensityField() {
		if (ambientIntensityField == null) {
			ambientIntensityField = new JunVrmlSFFloatField(DefaultAmbientIntensity());
		}
		return ambientIntensityField;
	}

	/**
	 * Answer the value of the attenuation field.
	 * 
	 * @return float[]
	 * @category accessing
	 */
	public float[] attenuation() {
		return this.attenuationField().value();
	}

	/**
	 * Answer the attenuation field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFVec3fField
	 * @category accessing
	 */
	protected JunVrmlSFVec3fField attenuationField() {
		if (attenuationField == null) {
			attenuationField = new JunVrmlSFVec3fField(DefaultAttenuation());
		}
		return attenuationField;
	}

	/**
	 * Answer the value of the color field.
	 * 
	 * @return float[]
	 * @category accessing
	 */
	public float[] color() {
		return this.colorField().value();
	}
	/**
	 * Answer the color field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFColorField
	 * @category accessing
	 */
	protected JunVrmlSFColorField colorField() {
		if (colorField == null) {
			colorField = new JunVrmlSFColorField(DefaultColor());
		}
		return colorField;
	}

	/**
	 * Answer the value of the intensity field.
	 * 
	 * @return float
	 * @category accessing
	 */
	public float intensity() {
		return this.intensityField().value();
	}

	/**
	 * Answer the intensity field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFFloatField
	 * @category accessing
	 */
	protected JunVrmlSFFloatField intensityField() {
		if (intensityField == null) {
			intensityField = new JunVrmlSFFloatField(DefaultIntensity());
		}
		return intensityField;
	}

	/**
	 * Answer the value of the location field.
	 * 
	 * @return float[]
	 * @category accessing
	 */
	public float[] location() {
		return this.locationField().value();
	}

	/**
	 * Answer the location field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFVec3fField
	 * @category accessing
	 */
	protected JunVrmlSFVec3fField locationField() {
		if (locationField == null) {
			locationField = new JunVrmlSFVec3fField(DefaultLocation());
		}
		return locationField;
	}

	/**
	 * Answer the value of the on field.
	 * 
	 * @return boolean
	 * @category accessing
	 */
	public boolean on() {
		return this.onField().value();
	}

	/**
	 * Answer the on field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFBoolField
	 * @category accessing
	 */
	protected JunVrmlSFBoolField onField() {
		if (onField == null) {
			onField = new JunVrmlSFBoolField(DefaultOn());
		}
		return onField;
	}

	/**
	 * Answer the value of the radius field.
	 * 
	 * @return float
	 * @category accessing
	 */
	public float radius() {
		return this.radiusField().value();
	}

	/**
	 * Answer the radius field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFFloatField
	 * @category accessing
	 */
	protected JunVrmlSFFloatField radiusField() {
		if (radiusField == null) {
			radiusField = new JunVrmlSFFloatField(DefaultRadius());
		}
		return radiusField;
	}

	/**
	 * Process myself with the generator.
	 * 
	 * @param aVisitor jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor
	 * @see jp.co.sra.jun.vrml.node.abstracts.JunVrmlNode#nodeDo_(jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor)
	 * @category enumerating
	 */
	public void nodeDo_(JunVrmlNodeVisitor aVisitor) {
		try {
			aVisitor.perform_with_("doPointLight_", this);
		} catch (Exception e) {
			super.nodeDo_(aVisitor);
		}
	}

	/**
	 * Set my properties on the JunOpenGL3dObject.
	 * No properties on a JunOpenGL3dObject, but on a JunOpenGL3dLight.
	 * 
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @see jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractPropertyNode#propertyOn_(jp.co.sra.jun.opengl.objects.JunOpenGL3dObject)
	 * @category code generation
	 */
	public void propertyOn_(JunOpenGL3dObject a3dObject) {
	}

	/**
	 * Convert to a JunOpenGLDisplayLight.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayLight
	 * @category code generation
	 */
	public JunOpenGLDisplayLight asJunOpenGLDisplayLight() {
		Color color = this.colorField().asColor();
		return JunOpenGLDisplayLight.PointLight_color_position_(this.on(), color, this.locationField().as3dPoint());
	}

}
