package jp.co.sra.jun.vrml.support;

import java.util.Hashtable;
import jp.co.sra.jun.vrml.node.geometry.JunVrmlSphereNode;
import jp.co.sra.jun.vrml.node.geometry20.*;
import jp.co.sra.jun.vrml.node.grouping20.*;
import jp.co.sra.jun.vrml.node.property.JunVrmlNormalNode;
import jp.co.sra.jun.vrml.node.property20.*;

/**
 * JunVrmlSyntaxTreeBuilder20 class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlSyntaxTreeBuilder20.java,v 8.10 2008/02/20 06:33:17 nisinaka Exp $
 */
public class JunVrmlSyntaxTreeBuilder20 extends JunVrmlSyntaxTreeBuilder {
	/** The node type table of VRML2.0. */
	protected static Hashtable NodeTypeTable = null;

	//
	static {
		_InitializeNodeTypeTable();
	}

	/**
	 * Initialize the NodeTypeTable of VRML2.0.
	 */
	protected static void _InitializeNodeTypeTable() {
		NodeTypeTable = new Hashtable();
		NodeTypeTable.put($("Appearance"), JunVrmlAppearanceNode.class);
		NodeTypeTable.put($("Background"), JunVrmlBackgroundNode.class);
		NodeTypeTable.put($("Box"), JunVrmlBoxNode.class);
		NodeTypeTable.put($("Color"), JunVrmlColorNode.class);
		NodeTypeTable.put($("Coordinate"), JunVrmlCoordinateNode.class);
		NodeTypeTable.put($("Group"), JunVrmlGroupNode.class);
		NodeTypeTable.put($("Material"), JunVrmlMaterialNode20.class);
		NodeTypeTable.put($("NavigationInfo"), JunVrmlNavigationInfoNode.class);
		NodeTypeTable.put($("Normal"), JunVrmlNormalNode.class);
		NodeTypeTable.put($("IndexedFaceSet"), JunVrmlIndexedFaceSetNode20.class);
		NodeTypeTable.put($("IndexedLineSet"), JunVrmlIndexedLineSetNode20.class);
		NodeTypeTable.put($("PixelTexture"), JunVrmlPixelTextureNode.class);
		NodeTypeTable.put($("Shape"), JunVrmlShapeNode.class);
		NodeTypeTable.put($("Sphere"), JunVrmlSphereNode.class);
		NodeTypeTable.put($("TextureCoordinate"), JunVrmlTextureCoordinateNode.class);
		NodeTypeTable.put($("Transform"), JunVrmlTransformNode.class);
		NodeTypeTable.put($("Viewpoint"), JunVrmlViewpointNode.class);
		NodeTypeTable.put($("WorldInfo"), JunVrmlWorldInfoNode.class);
	}

	/**
	 * Answer a node type table.
	 * 
	 * @return java.util.Hashtable
	 */
	public Hashtable nodeTypeTable() {
		return NodeTypeTable;
	}
}
