package jp.co.sra.qt4jun;

import java.awt.Color;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.jun.system.support.*;

/**
 * JunQTInterfaceTestExamples class
 * 
 *  @author    NISHIHARA Satoshi
 *  @created   2001/01/11 (by NISHIHARA Satoshi)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunQTInterfaceTestExamples.java,v 8.10 2008/02/20 06:33:17 nisinaka Exp $
 */
public class JunQTInterfaceTestExamples extends JunTestExamples {

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		JunQTInterface anInterface = JunQTInterface.Interface();
		int movie = anInterface.openMovie();

		if (movie != 0) {
			int grafPtr = 0;
			anInterface.qtSetMovieGWorld(movie, grafPtr, 0);
			anInterface.qtStartMovie(movie);

			while (!anInterface.isMovieDone(movie)) {
				anInterface.qtMoviesTask(movie, 0);
			}

			anInterface.qtStopMovie(movie);
			anInterface.qtDisposeMovie(movie);
			anInterface.destroyPortAssociation(grafPtr);
		}

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		JunQTInterface anInterface = JunQTInterface.Interface();
		int movie = anInterface.openMovie();

		byte[] data = null;
		if (movie != 0) {
			int duration = anInterface.qtGetMovieDuration(movie);
			data = anInterface.convertMovieToSoundData(movie, 0, duration);
		}

		if (data != null) {
			int width = 640, height = 256, color = Color.black.getRGB();
			int[][] array = anInterface.compactSoundData(data, width);
			StImage image = new StImage(width, height);
			for (int i = 0; i < width; ++i) {
				int high = array[0][i], low = array[1][i];
				for (int j = low; j <= high; ++j) {
					image.setPixel(i, j, color);
				}
			}
			image._display();
		}

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunQTInterfaceTestExamples();
	}
}
