package jp.co.sra.smalltalk;

import java.lang.reflect.Method;

/**
 * SmalltalkTestExamples class
 * 
 *  @author    nisinaka
 *  @created   1999/03/12 (by nisinaka)
 *  @updated   2003/03/17 (by nisinaka)
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: SmalltalkTestExamples.java,v 8.10 2008/02/20 06:33:17 nisinaka Exp $
 */
public abstract class SmalltalkTestExamples extends StObject {

	/**
	 * Execute all the methods which name begins with "Example".
	 * 
	 * @category Examples
	 */
	public SmalltalkTestExamples() {
		ExecuteMethods(this.getClass(), "Example");
	}

	/**
	 * Execute all the methods specified with the String.
	 * 
	 * @param aString java.lang.String
	 * @category Examples
	 */
	public SmalltalkTestExamples(String aString) {
		ExecuteMethods(this.getClass(), aString);
	}

	/**
	 * Execute all methods specified with the method name.
	 * 
	 * @param aClass java.lang.Class
	 * @param methodName java.lang.String
	 * @throws jp.co.sra.smalltalk.SmalltalkException
	 * @category Examples
	 */
	public static final void ExecuteMethods(Class aClass, String methodName) {
		try {
			Method[] methodList = aClass.getDeclaredMethods();

			for (int i = 0; i < methodList.length; i++) {
				Method method = methodList[i];

				if (method.getName().startsWith(methodName)) {
					System.out.println(method.getName());

					Boolean result = (Boolean) method.invoke(null, (Object[]) null);

					System.out.println("-> " + result);
				}
			}
		} catch (Exception e) {
			throw new SmalltalkException(e);
		}
	}
}
