package jp.co.sra.smalltalk;

import java.awt.Frame;
import java.awt.Window;

import jp.co.sra.smalltalk.menu.StMenuBarView;

/**
 * StApplicationWindow interface
 * 
 *  @author    nisinaka
 *  @created   2005/02/22 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StApplicationWindow.java,v 8.9 2008/02/20 06:33:17 nisinaka Exp $
 */
public interface StApplicationWindow extends DependentListener {

	/**
	 * Answer my current application.
	 * 
	 * @return jp.co.sra.smalltalk.StApplicationModel
	 * @category accessing
	 */
	public StApplicationModel application();

	/**
	 * Set my new application.
	 * 
	 * @param anApplication jp.co.sra.smalltalk.StApplication
	 * @category accessing
	 */
	public void application_(StApplicationModel anApplication);

	/**
	 * Answer my current view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @category accessing
	 */
	public StView view();

	/**
	 * Set my new view.
	 * 
	 * @param aView jp.co.sra.smalltalk.StView
	 * @category accessing
	 */
	public void view_(StView aView);

	/**
	 * Answer my current menu bar view.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StMenuBarView
	 * @category accessing
	 */
	public StMenuBarView menuBarView();

	/**
	 * Convert to Window.
	 * 
	 * @return java.awt.Window
	 * @category converting
	 */
	public Window toWindow();

	/**
	 * Convert to Frame.
	 * 
	 * @return java.awt.Frame
	 * @category converting
	 */
	public Frame toFrame();

	/**
	 * Update the window title.
	 * 
	 * @return boolean
	 * @category updating
	 */
	public boolean updateWindowTitle();

	/**
	 * Update the menu bar.
	 * 
	 * @return boolean
	 * @category updating
	 */
	public boolean updateMenuBar();

}
