package jp.co.sra.smalltalk;

import java.awt.Button;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;

/**
 * StDialog class
 * 
 *  @author    Hirotsugu Kondo
 *  @created   1998/11/11 (by Hirotsugu Kondo)
 *  @updated   1999/07/02 (by nisinaka)
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StDialog.java,v 8.10 2008/02/20 06:33:18 nisinaka Exp $
 */
public class StDialog implements ActionListener {
	protected static String lastDirectory = null;
	protected Dialog dialog;
	protected boolean accepted;
	protected String value;
	protected TextField textField;

	/**
	 * Create a new instance of <code>StDialog</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public StDialog() {
		this(SystemResourceSupport.getFrame());
	}

	/**
	 * Create a new instance of <code>StDialog</code> and initialize it.
	 * 
	 * @param aFrame java.awt.Frame
	 * @category Instance creation
	 */
	public StDialog(Frame aFrame) {
		super();
		dialog = new Dialog(aFrame, "", true);
	}

	/**
	 * Show the dialog for confirming.
	 * 
	 * @param messageString java.lang.String
	 * @return boolean
	 * @category Utilities
	 */
	public static boolean Confirm_(String messageString) {
		return Confirm_(messageString, _getDefaultPoint());
	}

	/**
	 * Show the dialog for confirming.
	 * 
	 * @param messageString java.lang.String
	 * @param point java.awt.Point
	 * @return boolean
	 * @category Utilities
	 */
	public static boolean Confirm_(String messageString, Point point) {
		return Confirm_(messageString, true, point);
	}

	/**
	 * Show the dialog for confirming.
	 * 
	 * @param messageString java.lang.String
	 * @param initialAnswer boolean
	 * @return boolean
	 * @category Utilities
	 */
	public static boolean Confirm_(String messageString, boolean initialAnswer) {
		return Confirm_(messageString, initialAnswer, _getDefaultPoint());
	}

	/**
	 * Show the dialog for confirming.
	 * 
	 * @param messageString java.lang.String
	 * @param initialAnswer boolean
	 * @param point java.awt.Point
	 * @return boolean
	 * @category Utilities
	 */
	public static boolean Confirm_(String messageString, boolean initialAnswer, Point point) {
		StDialog aDialog = new StDialog();
		return aDialog.confirm_(messageString, initialAnswer, point);
	}

	/**
	 * Show the file dialog.
	 * 
	 * @return java.io.File
	 * @category Utilities
	 */
	public static File OpenFileDialog() {
		return OpenFileDialog_default_("", null);
	}

	/**
	 * Show the file dialog.
	 * 
	 * @param messageString java.lang.String
	 * @return java.io.File
	 * @category Utilities
	 */
	public static File OpenFileDialog_(String messageString) {
		return OpenFileDialog_default_(messageString, null);
	}

	/**
	 * Show the file dialog.
	 * 
	 * @param messageString java.lang.String
	 * @param defaultFilename java.lang.String
	 * @return java.io.File
	 * @category Utilities
	 */
	public static File OpenFileDialog_default_(String messageString, String defaultFilename) {
		FileDialog fileDialog = new FileDialog(SystemResourceSupport.getFrame(), messageString);

		if (lastDirectory != null) {
			fileDialog.setDirectory(lastDirectory);
		}

		if ((defaultFilename != null) && (defaultFilename.length() > 0)) {
			fileDialog.setFile(defaultFilename);
		}

		fileDialog.setVisible(true);
		String directory = fileDialog.getDirectory();
		String filename = fileDialog.getFile();
		if ((directory == null) || (filename == null)) {
			return null;
		}
		lastDirectory = directory;
		return new File(directory, filename);
	}

	/**
	 * Show the dialog for requesting a user input.
	 * 
	 * @param messageString java.lang.String
	 * @return java.lang.String
	 * @category Utilities
	 */
	public static String Request_(String messageString) {
		return Request_(messageString, _getDefaultPoint());
	}

	/**
	 * Show the dialog for requesting a user input.
	 * 
	 * @param messageString java.lang.String
	 * @param point java.awt.Point
	 * @return java.lang.String
	 * @category Utilities
	 */
	public static String Request_(String messageString, Point point) {
		return Request_(messageString, "", point);
	}

	/**
	 * Show the dialog for requesting a user input.
	 * 
	 * @param messageString java.lang.String
	 * @param initialAnswer java.lang.String
	 * @return java.lang.String
	 * @category Utilities
	 */
	public static String Request_(String messageString, String initialAnswer) {
		return Request_(messageString, initialAnswer, _getDefaultPoint());
	}

	/**
	 * Show the dialog for requesting a user input.
	 * 
	 * @param messageString java.lang.String
	 * @param initialAnswer java.lang.String
	 * @param point java.awt.Point
	 * @return java.lang.String
	 * @category Utilities
	 */
	public static String Request_(String messageString, String initialAnswer, Point point) {
		StDialog aDialog = new StDialog();
		return aDialog.request_(messageString, initialAnswer, point);
	}

	/**
	 * Show the save file dialog.
	 * 
	 * @return java.io.File
	 * @category Utilities
	 */
	public static File SaveFileDialog() {
		return SaveFileDialog_default_("", null);
	}

	/**
	 * Show the save file dialog.
	 * 
	 * @param messageString java.lang.String
	 * @return java.io.File
	 * @category Utilities
	 */
	public static File SaveFileDialog_(String messageString) {
		return SaveFileDialog_default_(messageString, null);
	}

	/**
	 * Show the save file dialog.
	 * 
	 * @param messageString java.lang.String
	 * @param defaultFilename java.lang.String
	 * @return java.io.File
	 * @category Utilities
	 */
	public static File SaveFileDialog_default_(String messageString, String defaultFilename) {
		FileDialog fileDialog = new FileDialog(SystemResourceSupport.getFrame(), "", FileDialog.SAVE);

		if (lastDirectory != null) {
			fileDialog.setDirectory(lastDirectory);
		}

		if ((defaultFilename != null) && (defaultFilename.length() > 0)) {
			fileDialog.setFile(defaultFilename);
		}

		fileDialog.setVisible(true);
		String directory = fileDialog.getDirectory();
		String filename = fileDialog.getFile();
		if ((directory == null) || (filename == null)) {
			return null;
		}
		lastDirectory = directory;
		return new File(directory, filename);
	}

	/**
	 * Show the dialog for warning.
	 * 
	 * @param messageString java.lang.String
	 * @category Utilities
	 */
	public static void Warn_(String messageString) {
		Warn_(messageString, _getDefaultPoint());
	}

	/**
	 * Show the dialog for warning.
	 * 
	 * @param messageString java.lang.String
	 * @param point java.awt.Point
	 * @category Utilities
	 */
	public static void Warn_(String messageString, Point point) {
		StDialog aDialog = new StDialog();
		aDialog.warn_(messageString, point);
	}

	/**
	 * Answer the center point of the screen.
	 * 
	 * @return java.awt.Point
	 * @category private
	 */
	protected static Point _getCenterPoint() {
		Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
		return new Point(dimension.width / 2, dimension.height / 2);
	}

	/**
	 * Answer the default point to show the dialog.
	 * 
	 * @return java.awt.Point
	 * @category private
	 */
	protected static Point _getDefaultPoint() {
		Point point = null;

		try {
			point = SystemInterface._MousePoint();
		} catch (UnsatisfiedLinkError e) {
			point = new Point(0, 0);
		} catch (NoClassDefFoundError e) {
			point = new Point(0, 0);
		}

		return point;
	}

	/**
	 * Invoked when an action occurs.
	 * 
	 * @param e java.awt.event.ActionEvent
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 * @category events
	 */
	public void actionPerformed(ActionEvent e) {
		String buttonLabel = e.getActionCommand();
		if (buttonLabel.equals("Yes") || buttonLabel.equals("OK")) {
			accepted = true;
			value = (textField != null) ? textField.getText() : null;
		} else if (buttonLabel.equals("No") || buttonLabel.equals("Cancel")) {
			accepted = false;
		}
		dialog.dispose();
	}

	/**
	 * Show the dialog for confirming.
	 * 
	 * @param messageString java.lang.String
	 * @param initialAnswer boolean
	 * @return boolean
	 * @category utilities
	 */
	public boolean confirm_(String messageString, boolean initialAnswer, Point point) {
		dialog.add("Center", new Label(messageString, Label.CENTER));
		dialog.add("South", this._yesNoButtons());
		this._showDialog(point);
		return accepted;
	}

	/**
	 * Show the dialog for requesting a user input.
	 * 
	 * @param messageString java.lang.String
	 * @param initialAnswer java.lang.String
	 * @param point java.awt.Point
	 * @return java.lang.String
	 * @category utilities
	 */
	public String request_(String messageString, String initialAnswer, Point point) {
		dialog.setLayout(new GridLayout(3, 1));
		textField = new TextField(20);
		textField.setText(initialAnswer);
		dialog.add(new Label(messageString, Label.CENTER));
		dialog.add(textField);
		dialog.add(this._okCancelButtons());
		this._showDialog(point);
		return value;
	}

	/**
	 * Show the dialog for warning.
	 * 
	 * @param messageString java.lang.String
	 * @param point java.awt.Point
	 * @category utilities
	 */
	public void warn_(String messageString, Point point) {
		dialog.add("Center", new Label(messageString, Label.CENTER));
		dialog.add("South", this._closeOKButton());
		this._showDialog(point);
	}

	/**
	 * Answer the cansel button.
	 * 
	 * @return java.awt.Button
	 * @category buttons
	 */
	protected Button _closeCancelButton() {
		Button yesButton = new Button("Cancel");
		yesButton.addActionListener(this);
		return yesButton;
	}

	/**
	 * Answer the OK button.
	 * 
	 * @return java.awt.Button
	 * @category buttons
	 */
	protected Button _closeOKButton() {
		Button yesButton = new Button("OK");
		yesButton.addActionListener(this);
		return yesButton;
	}

	/**
	 * Answer the panel of ok/cancel buttons.
	 * 
	 * @return java.awt.Panel
	 * @category buttons
	 */
	protected Panel _okCancelButtons() {
		Button yesButton = new Button("OK");
		yesButton.addActionListener(this);

		Button noButton = new Button("Cancel");
		noButton.addActionListener(this);

		Panel panel = new Panel();
		panel.setLayout(new FlowLayout());
		panel.add(yesButton);
		panel.add(noButton);

		return panel;
	}

	/**
	 * Dialog standard handling for JAVA.
	 * 
	 * @param point java.awt.Point
	 * @category showing
	 */
	protected void _showDialog(Point point) {
		//dialog.setResizable(false);
		dialog.pack();

		Rectangle bounds = dialog.getBounds();
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		int originX = Math.max(0, Math.min(point.x - (bounds.width / 2), screenSize.width - bounds.width));
		int originY = Math.max(0, Math.min(point.y - (bounds.height / 2), screenSize.height - bounds.height));

		dialog.setBounds(originX, originY, bounds.width, bounds.height);
		dialog.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				e.getWindow().dispose();
			}
		});
		dialog.setVisible(true);
	}

	/**
	 * Answer the panel of yes/no buttons.
	 * 
	 * @return java.awt.Panel
	 * @category buttons
	 */
	protected Panel _yesNoButtons() {
		Button yesButton = new Button("Yes");
		yesButton.addActionListener(this);

		Button noButton = new Button("No");
		noButton.addActionListener(this);

		Panel panel = new Panel();
		panel.add("West", yesButton);
		panel.add("East", noButton);

		return panel;
	}
}
