package jp.co.sra.smalltalk;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

/**
 * StInputStateTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2005/02/16 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StInputStateTestExamples.java,v 8.10 2008/02/20 06:33:18 nisinaka Exp $
 */
public class StInputStateTestExamples extends SmalltalkTestExamples {

	/**
	 * Example1: wait until the specified key is pressed.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		final StValueHolder flag = new StValueHolder(true);

		Frame aFrame = new Frame();
		aFrame.setTitle("Testing StInputState");
		aFrame.setLayout(new BorderLayout());
		aFrame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				e.getWindow().dispose();
				flag.value_(false);
			}
		});

		Label aLabel = new Label("SHIFT key", Label.CENTER);
		aFrame.add(aLabel);
		aFrame.pack();
		StApplicationModel._ShowAtMousePoint(aFrame);

		Thread aThread = new Thread() {
			public void run() {
				boolean shiftDown = StInputState.Default().shiftDown();
				while (flag._booleanValue()) {
					if (shiftDown == false && StInputState.Default().shiftDown()) {
						System.out.println("SHIFT key pressed");
						shiftDown = true;
					} else if (shiftDown && StInputState.Default().shiftDown() == false) {
						System.out.println("SHIFT key released");
						shiftDown = false;
					}
				}
			}
		};
		aThread.start();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new StInputStateTestExamples();
	}

}
