package jp.co.sra.smalltalk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeMap;

/**
 * StSortedCollectionTestExamples class
 * 
 *  @author    nisinaka
 *  @created   1998/12/02 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StSortedCollectionTestExamples.java,v 8.12 2008/02/20 06:33:18 nisinaka Exp $
 */
public class StSortedCollectionTestExamples extends SmalltalkTestExamples {

	/**
	 * Example1: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static final boolean Example1() {
		StBlockClosure sortBlock = new StBlockClosure() {
			public Object value_value_(Object e1, Object e2) {
				return new Boolean(((Number) e1).intValue() <= ((Number) e2).intValue());
			}
		};

		StSortedCollection collection = new StSortedCollection(sortBlock);
		collection.add_(new Integer(0));
		collection.add_(new Integer(4));
		collection.add_(new Integer(5));
		collection.add_(new Integer(3));
		collection.add_(new Integer(2));
		collection.add_(new Integer(1));

		Object[] array = collection._asArray();
		for (int i = 0; i < array.length; i++) {
			System.out.println(i);

			if (((Number) array[i]).intValue() != i) {
				return false;
			}
		}
		return true;
	}

	/**
	 * Example2_double:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2_double() {
		int size = 100000;
		double[] values = new double[size];
		for (int i = 0; i < values.length; i++) {
			values[i] = Math.random();
		}

		// StSortedCollection
		long time = System.currentTimeMillis();
		StSortedCollection collection = new StSortedCollection(new StBlockClosure() {
			public Object value_value_(Object e1, Object e2) {
				return new Boolean(((Number) e1).doubleValue() <= ((Number) e2).doubleValue());
			}
		});
		for (int i = 0; i < values.length; i++) {
			collection.add_(new Double(values[i]));
		}
		System.out.println("StSortedCollection          : elapsed " + (System.currentTimeMillis() - time));

		// TreeMap
		time = System.currentTimeMillis();
		TreeMap aTreeMap = new TreeMap(new Comparator() {
			public int compare(Object arg0, Object arg1) {
				double d0 = ((Number) arg0).doubleValue();
				double d1 = ((Number) arg1).doubleValue();
				return (d0 == d1) ? 0 : (d0 < d1) ? -1 : 1;
			}
		});
		for (int i = 0; i < values.length; i++) {
			aTreeMap.put(new Double(values[i]), null);
		}
		System.out.println("TreeMap                     : elapsed " + (System.currentTimeMillis() - time));

		// Coolections.sort() with ArrayList
		time = System.currentTimeMillis();
		ArrayList aList = new ArrayList();
		for (int i = 0; i < values.length; i++) {
			aList.add(new Double(values[i]));
		}
		Collections.sort(aList, new Comparator() {
			public int compare(Object arg0, Object arg1) {
				double d0 = ((Number) arg0).doubleValue();
				double d1 = ((Number) arg1).doubleValue();
				return (d0 == d1) ? 0 : (d0 < d1) ? -1 : 1;
			}
		});
		System.out.println("Collesions.sort() with List : elapsed " + (System.currentTimeMillis() - time));

		// Arrays.sort() with ArrayList
		time = System.currentTimeMillis();
		aList = new ArrayList();
		for (int i = 0; i < values.length; i++) {
			aList.add(new Double(values[i]));
		}
		Arrays.sort(aList.toArray(), new Comparator() {
			public int compare(Object arg0, Object arg1) {
				double d0 = ((Number) arg0).doubleValue();
				double d1 = ((Number) arg1).doubleValue();
				return (d0 == d1) ? 0 : (d0 < d1) ? -1 : 1;
			}
		});
		System.out.println("Arrays.sort() with List     : elapsed " + (System.currentTimeMillis() - time));

		// Arrays.sort() with double[]
		time = System.currentTimeMillis();
		double[] sortedValues = new double[values.length];
		for (int i = 0; i < values.length; i++) {
			sortedValues[i] = values[i];
		}
		Arrays.sort(values);
		System.out.println("Arrays.sort() with double[] : elapsed " + (System.currentTimeMillis() - time));

		return true;
	}

	/**
	 * Example3_String:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3_String() {
		int size = 100000;
		String[] values = new String[size];
		for (int i = 0; i < values.length; i++) {
			values[i] = String.valueOf(Math.random());
		}

		// StSortedCollection
		long time = System.currentTimeMillis();
		StSortedCollection collection = new StSortedCollection(new StBlockClosure() {
			public Object value_value_(Object e1, Object e2) {
				int result = ((String) e1).compareTo(((String) e2));
				return new Boolean(result <= 0);
			}
		});
		for (int i = 0; i < values.length; i++) {
			collection.add_(values[i]);
		}
		System.out.println("StSortedCollection          : elapsed " + (System.currentTimeMillis() - time));

		// TreeMap
		time = System.currentTimeMillis();
		TreeMap aTreeMap = new TreeMap(new Comparator() {
			public int compare(Object arg0, Object arg1) {
				return ((String) arg0).compareTo(((String) arg1));
			}
		});
		for (int i = 0; i < values.length; i++) {
			aTreeMap.put(values[i], null);
		}
		System.out.println("TreeMap                     : elapsed " + (System.currentTimeMillis() - time));

		// Coolections.sort() with ArrayList
		time = System.currentTimeMillis();
		ArrayList aList = new ArrayList();
		for (int i = 0; i < values.length; i++) {
			aList.add(values[i]);
		}
		Collections.sort(aList, new Comparator() {
			public int compare(Object arg0, Object arg1) {
				return ((String) arg0).compareTo(((String) arg1));
			}
		});
		System.out.println("Collesions.sort() with List : elapsed " + (System.currentTimeMillis() - time));

		// Arrays.sort() with ArrayList
		time = System.currentTimeMillis();
		aList = new ArrayList();
		for (int i = 0; i < values.length; i++) {
			aList.add(values[i]);
		}
		Arrays.sort(aList.toArray(), new Comparator() {
			public int compare(Object arg0, Object arg1) {
				return ((String) arg0).compareTo(((String) arg1));
			}
		});
		System.out.println("Arrays.sort() with List     : elapsed " + (System.currentTimeMillis() - time));

		return true;
	}

	/**
	 * Execute all examles.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new StSortedCollectionTestExamples();
	}

}
