package jp.co.sra.smalltalk;

/**
 * StValueModel class
 * 
 *  @author    nisinaka
 *  @created   1998/10/09 (by nisinaka)
 *  @updated   2003/03/07 (by nisinaka)
 *  @updated   2006/04/18 (by nisinaka)
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StValueModel.java,v 8.10 2008/02/20 06:33:18 nisinaka Exp $
 */
public class StValueModel extends StModel implements StBlockValued {

	/**
	 * Create a new instance of StValueModel and initialize it.
	 *
	 * @category Instance creation
	 */
	public StValueModel() {
		this.initialize();
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @category initialize-release
	 */
	protected void initialize() {
		// nothing to do by default.
	}

	/**
	 * Remove references to objects that may refer to the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StObject#release()
	 * @category initialize-release
	 */
	public void release() {
		this.releaseParts();
		super.release();
	}

	/**
	 * Break the dependency links from any parts of myself to myself.
	 * Subclasses holding composite values will implement this in a non-trivial way.
	 * 
	 * @category initialize-release
	 */
	public void releaseParts() {
		// nothing to do by default.
	}

	/**
	 * Answer the currently stored value.
	 * 
	 * @return java.lang.Object
	 * @see jp.co.sra.smalltalk.StValued#value()
	 * @category accessing
	 */
	public Object value() {
		throw SmalltalkException.SubclassResponsibility();
	}

	/**
	 * Set the currently stored value, and notify dependents.
	 * 
	 * @param newValue java.lang.Object
	 * @category accessing
	 */
	public void value_(Object newValue) {
		this.setValue_(newValue);
		this.changed_($("value"));
	}

	/**
	 * Set the currently stored value, without notifying dependents.
	 * 
	 * @param newValue java.lang.Object
	 * @category accessing
	 */
	public void setValue_(Object newValue) {
		throw SmalltalkException.SubclassResponsibility();
	}

	/**
	 * Answer a StBlockValue that computes aBlock with the receiver's value as the argument.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return jp.co.sra.smalltalk.StBlockValue
	 * @category constructing
	 */
	public StBlockValue compute_(StBlockClosure aBlock) {
		return new StBlockValue(aBlock, this);
	}

	/**
	 * Convert this as StValueModel.
	 * 
	 * @return jp.co.sra.smalltalk.StValueModel
	 * @category converting
	 */
	public StValueModel asValue() {
		return this;
	}

	/**
	 * Arrange to receive a message with aSymbol when the value aspect changes on anObject.
	 * 
	 * @param aSymbol java.lang.String
	 * @param anObject jp.co.sra.smalltalk.StObject
	 * @category interests
	 */
	public void onChangeSend_to_(String aSymbol, StObject anObject) {
		this.expressInterestIn_for_sendBack_($("value"), anObject, aSymbol);
	}

	/**
	 * Undo a send of onChangeSend_to_().
	 * 
	 * @param anObject jp.co.sra.smalltalk.StObject
	 * @category interests
	 */
	public void retractInterestsFor_(StObject anObject) {
		this.retractInterestIn_for_($("value"), anObject);
	}

}
