package jp.co.sra.smalltalk.menu;

import java.awt.MenuBar;
import java.awt.MenuComponent;

/**
 * StMenuBarViewAwt class
 * 
 *  @author    nisinaka
 *  @created   2005/02/17 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StMenuBarViewAwt.java,v 8.9 2008/02/20 06:33:36 nisinaka Exp $
 */
public class StMenuBarViewAwt extends StMenuViewAwt implements StMenuBarView {

	/**
	 * Create a new instance of StMenuBarViewAwt and initialize it.
	 *
	 * @param aMenuBar jp.co.sra.smalltalk.menu.StMenuBar
	 * @category Instance creation
	 */
	public StMenuBarViewAwt(StMenuBar aMenuBar) {
		super(aMenuBar);
	}

	/**
	 * Answer my menu bar.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StMenuBar
	 * @see jp.co.sra.smalltalk.menu.StMenuBarView#getMenuBar()
	 * @category model accessing
	 */
	public StMenuBar getMenuBar() {
		return (StMenuBar) this.getMenu();
	}

	/**
	 * Answer the menu item view as Menu.
	 * 
	 * @return java.awt.MenuBar
	 * @category converting
	 */
	public MenuBar toMenuBar() {
		return (MenuBar) this.menuItemView();
	}

	/**
	 * Update the enabled of the menu item view.
	 * 
	 * @see jp.co.sra.smalltalk.menu.StMenuItemViewAwt#updateEnabled()
	 * @category updating
	 */
	protected void updateEnabled() {
		// nothing to do
	}

	/**
	 * Update the label of the menu item view.
	 * 
	 * @see jp.co.sra.smalltalk.menu.StMenuItemViewAwt#updateLabel()
	 * @category updating
	 */
	protected void updateLabel() {
		// nothing to do
	}

	/**
	 * Create a menu item view.
	 * 
	 * @return java.awt.MenuComponent
	 * @see jp.co.sra.smalltalk.menu.StMenuItemViewAwt#createMenuItemView()
	 * @category private
	 */
	protected MenuComponent createMenuItemView() {
		MenuBar aMenuBar = new MenuBar() {
			public void addNotify() {
				super.addNotify();
				initializeWithWindow();
			}
		};

		StMenu[] menus = this.getMenuBar().menus();
		for (int i = 0; i < menus.length; i++) {
			StMenuViewAwt aMenuView = (StMenuViewAwt) _New(menus[i]);
			menuItemViews.add(aMenuView);
			aMenuBar.add(aMenuView.toMenu());
		}

		return aMenuBar;
	}

}