package jp.co.sra.smalltalk.menu;

import javax.swing.JComponent;
import javax.swing.JMenuBar;

/**
 * StMenuBarViewSwing class
 * 
 *  @author    nisinaka
 *  @created   2005/02/17 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StMenuBarViewSwing.java,v 8.10 2008/02/20 06:33:36 nisinaka Exp $
 */
public class StMenuBarViewSwing extends StMenuViewSwing implements StMenuBarView {

	/**
	 * Create a new instance of StMenuBarViewSwing and initialize it.
	 *
	 * @param aMenuBar jp.co.sra.smalltalk.menu.StMenuBar
	 * @category Instance creation
	 */
	public StMenuBarViewSwing(StMenuBar aMenuBar) {
		super(aMenuBar);
	}

	/**
	 * Answer my menu bar.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StMenuBar
	 * @see jp.co.sra.smalltalk.menu.StMenuBarView#getMenuBar()
	 * @category model accessing
	 */
	public StMenuBar getMenuBar() {
		return (StMenuBar) this.getMenu();
	}

	/**
	 * Answer the menu item view as Menu.
	 * 
	 * @return java.awt.MenuBar
	 * @category converting
	 */
	public JMenuBar toMenuBar() {
		return (JMenuBar) this.menuItemView();
	}

	/**
	 * Update the enabled of the menu item view.
	 * 
	 * @see jp.co.sra.smalltalk.menu.StMenuItemViewAwt#updateEnabled()
	 * @category updating
	 */
	protected void updateEnabled() {
		// nothing to do
	}

	/**
	 * Update the label of the menu item view.
	 * 
	 * @see jp.co.sra.smalltalk.menu.StMenuItemViewAwt#updateLabel()
	 * @category updating
	 */
	protected void updateLabel() {
		// nothing to do
	}

	/**
	 * Update the label image of the menu item view.
	 * 
	 * @see jp.co.sra.smalltalk.menu.StMenuItemViewSwing#updateLabelImage()
	 * @category updating
	 */
	protected void updateLabelImage() {
		// nothing to do
	}

	/**
	 * Create a menu item view.
	 * 
	 * @return java.awt.MenuComponent
	 * @see jp.co.sra.smalltalk.menu.StMenuItemViewAwt#createMenuItemView()
	 * @category private
	 */
	protected JComponent createMenuItemView() {
		JMenuBar aMenuBar = new JMenuBar() {
			public void addNotify() {
				super.addNotify();
				initializeWithWindow();
			}
		};

		StMenu[] menus = this.getMenuBar().menus();
		for (int i = 0; i < menus.length; i++) {
			StMenuViewSwing aMenuView = (StMenuViewSwing) _New(menus[i]);
			menuItemViews.add(aMenuView);
			aMenuBar.add(aMenuView.toMenu());
		}

		return aMenuBar;
	}

	/**
	 * Set whether the menu is needed to be a light weight one or not.
	 * 
	 * @param aBoolean boolean
	 * @see jp.co.sra.smalltalk.menu.StMenuViewSwing#setLightWeightPopupEnabled(boolean)
	 * @category private
	 */
	public void setLightWeightPopupEnabled(boolean aBoolean) {
		if (menuItemView == null) {
			this.menuItemView(); // to create my menu item view.
		}

		for (int i = 0; i < menuItemViews.size(); i++) {
			StMenuItemViewSwing aMenuItemView = (StMenuItemViewSwing) menuItemViews.get(i);
			if (aMenuItemView instanceof StMenuViewSwing) {
				((StMenuViewSwing) aMenuItemView).setLightWeightPopupEnabled(aBoolean);
			}
		}
	}
}