package jp.co.sra.smalltalk.menu;

import java.awt.Frame;
import java.awt.Label;
import java.awt.PopupMenu;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;

import jp.co.sra.smalltalk.SmalltalkTestExamples;
import jp.co.sra.smalltalk.StApplicationModel;

/**
 * StMenuTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2005/02/17 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StMenuTestExamples.java,v 8.9 2008/02/20 06:33:36 nisinaka Exp $
 */
public class StMenuTestExamples extends SmalltalkTestExamples {

	protected static StMenuBar SampleMenuBar;
	protected static StPopupMenu SamplePopupMenu;

	static {
		StMenu fileMenu = new StMenu("File", $("fileMenuKey"));
		fileMenu.add(new StMenuItem("New", $("newMenuKey"), KeyEvent.VK_N, KeyEvent.CTRL_MASK));
		fileMenu.add(new StMenuItem("Open", $("openMenuKey"), KeyEvent.VK_O, KeyEvent.CTRL_MASK | KeyEvent.SHIFT_MASK));
		fileMenu.add(new StMenuItem("Save", KeyEvent.VK_S, KeyEvent.ALT_MASK | KeyEvent.SHIFT_MASK));

		StMenu subMenu = new StMenu("Open...");
		subMenu.add(new StMenuItem("VRML1.0"));
		subMenu.add(new StMenuItem("VRML97"));
		fileMenu.add(subMenu);

		fileMenu.addSeparator();
		fileMenu.add(new StCheckBoxMenuItem("CheckBox", $("checkBoxMenuKey"), false));
		fileMenu.add(new StCheckBoxMenuItem("CheckBox2", true));

		fileMenu.addSeparator();
		StRadioButtonGroup aGroup = new StRadioButtonGroup();
		fileMenu.add(new StRadioButtonMenuItem("RadioButton1", $("xrb1"), aGroup));
		fileMenu.add(new StRadioButtonMenuItem("RadioButton2", aGroup));
		fileMenu.add(new StRadioButtonMenuItem("RadioButton3", aGroup));

		fileMenu.addSeparator();
		fileMenu.addAll(new StRadioButtonGroup(new StRadioButtonMenuItem[] {
				new StRadioButtonMenuItem("RadioButton1", $("yrb1")),
				new StRadioButtonMenuItem("RadioButton2", $("yrb2")),
				new StRadioButtonMenuItem("RadioButton3", $("yrb3"))
		}).menuItems());

		// SampleMenuBar
		SampleMenuBar = new StMenuBar();
		SampleMenuBar.add(fileMenu);
		SampleMenuBar.add(new StMenu("Help"));

		// SamplePopupMenu
		SamplePopupMenu = new StPopupMenu();
		SamplePopupMenu.addAll(fileMenu.menuItems());
		SamplePopupMenu.addSeparator();
		SamplePopupMenu.add(new StMenuItem("Misc"));

		// 
		MenuListener menuListener = new MenuListener() {
			public void menuPerformed(MenuEvent aMenuEvent) {
				System.out.println(aMenuEvent);
			}
		};
		SampleMenuBar.atNameKey_($("openMenuKey")).addMenuListener(menuListener);
		SampleMenuBar.atNameKey_($("Save")).addMenuListener(menuListener);
		SampleMenuBar.atNameKey_($("checkBoxMenuKey")).addMenuListener(menuListener);
		SampleMenuBar.atNameKey_($("checkBoxMenuKey")).addMenuListener(new MenuListener() {
			public void menuPerformed(MenuEvent aMenuEvent) {
				StCheckBoxMenuItem aCheckBoxMenuItem = (StCheckBoxMenuItem) aMenuEvent.getMenuItem();
				SampleMenuBar.atNameKey_($("VRML1.0")).beEnabled(aCheckBoxMenuItem.isSelected());

			}
		});
		SampleMenuBar.atNameKey_($("VRML1.0")).disable();
		SampleMenuBar.atNameKey_($("xrb1")).addMenuListener(menuListener);
		SampleMenuBar.atNameKey_($("yrb1")).addMenuListener(menuListener);
	}

	/**
	 * Example1_AWT: 
	 * 
	 * @return boolean
	 */
	public static boolean Example1_AWT() {
		StApplicationModel.SetDefaultViewMode(StApplicationModel.VIEW_AWT);

		Frame aFrame = new Frame();
		aFrame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}
		});
		aFrame.setMenuBar((new StMenuBarViewAwt(SampleMenuBar)).toMenuBar());

		final PopupMenu aPopupMenu = (new StPopupMenuViewAwt(SamplePopupMenu)).toPopupMenu();
		final Label aLabel = new Label("click me", Label.CENTER);
		aLabel.add(aPopupMenu);
		aLabel.addMouseListener(new MouseAdapter() {
			public void mouseClicked(MouseEvent e) {
				StMenuItem openMenu = SampleMenuBar.atNameKey_($("openMenuKey"));
				openMenu.label_("Open???");
			}

			public void mouseReleased(MouseEvent e) {
				if (e.isPopupTrigger()) {
					aPopupMenu.show(aLabel, e.getX(), e.getY());
				}
			}
		});
		aFrame.add(aLabel);

		aFrame.pack();
		StApplicationModel._ShowAtMousePoint(aFrame);
		return true;
	}

	/**
	 * Example1_Swing: 
	 * 
	 * @return boolean
	 */
	public static boolean Example1_Swing() {
		StApplicationModel.SetDefaultViewMode(StApplicationModel.VIEW_SWING);

		JFrame aFrame = new JFrame();
		aFrame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}
		});
		aFrame.setJMenuBar((new StMenuBarViewSwing(SampleMenuBar)).toMenuBar());

		final JPopupMenu aPopupMenu = (new StPopupMenuViewSwing(SamplePopupMenu)).toPopupMenu();
		final JLabel aLabel = new JLabel("click me", JLabel.CENTER);
		aLabel.add(aPopupMenu);
		aLabel.addMouseListener(new MouseAdapter() {
			public void mouseClicked(MouseEvent e) {
				StMenuItem fileMenu = SampleMenuBar.atNameKey_($("fileMenuKey"));
				fileMenu.label_("File???");
			}

			public void mouseReleased(MouseEvent e) {
				if (e.isPopupTrigger()) {
					aPopupMenu.show(aLabel, e.getX(), e.getY());
				}
			}
		});
		aFrame.getContentPane().add(aLabel);

		aFrame.pack();
		StApplicationModel._ShowAtMousePoint(aFrame);
		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new StMenuTestExamples();
	}

}
