package jp.co.sra.smalltalk.menu;

import java.awt.MenuComponent;
import java.awt.PopupMenu;

/**
 * StPopupMenuViewAwt class
 * 
 *  @author    nisinaka
 *  @created   2005/02/18 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StPopupMenuViewAwt.java,v 8.9 2008/02/20 06:33:36 nisinaka Exp $
 */
public class StPopupMenuViewAwt extends StMenuViewAwt implements StPopupMenuView {

	/**
	 * Create a new instance of StPopupMenuViewAwt and initialize it.
	 *
	 * @param aPopupMenu jp.co.sra.smalltalk.menu.StPopupMenu
	 * @category Instance creation
	 */
	public StPopupMenuViewAwt(StPopupMenu aPopupMenu) {
		super(aPopupMenu);
	}

	/**
	 * Answer my popup menu.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StPopupMenu
	 * @see jp.co.sra.smalltalk.menu.StPopupMenuView#getPopupMenu()
	 * @category model accessing
	 */
	public StPopupMenu getPopupMenu() {
		return (StPopupMenu) this.getMenuItem();
	}

	/**
	 * Answer the menu item view as PopupMenu.
	 * 
	 * @return java.awt.PopupMenu
	 * @category converting
	 */
	public PopupMenu toPopupMenu() {
		return (PopupMenu) this.menuItemView();
	}

	/**
	 * Update the enabled of the menu item view.
	 * 
	 * @see jp.co.sra.smalltalk.menu.StMenuItemViewAwt#updateEnabled()
	 * @category updating
	 */
	protected void updateEnabled() {
		// nothing to do
	}

	/**
	 * Update the label of the menu item view.
	 * 
	 * @see jp.co.sra.smalltalk.menu.StMenuItemViewAwt#updateLabel()
	 * @category updating
	 */
	protected void updateLabel() {
		// nothing to do
	}

	/**
	 * Create a menu item view.
	 * 
	 * @return java.awt.MenuComponent
	 * @see jp.co.sra.smalltalk.menu.StMenuItemViewAwt#createMenuItemView()
	 * @category private
	 */
	protected MenuComponent createMenuItemView() {
		PopupMenu aPopupMenu = new PopupMenu() {
			public void addNotify() {
				super.addNotify();
				initializeWithWindow();
			}
		};

		StMenuItem[] items = this.getMenu().menuItems();
		for (int i = 0; i < items.length; i++) {
			if (items[i] == StMenu.Separator) {
				aPopupMenu.addSeparator();
			} else {
				StMenuItemViewAwt aMenuItemView = _New(items[i]);
				menuItemViews.add(aMenuItemView);
				aPopupMenu.add(aMenuItemView.toMenuItem());
			}
		}

		return aPopupMenu;
	}

}