{

  small script parser for borland/turbo pascal 7 & virtual pascal for os/2
  (c) 1997 dink - public domain.  if you use this, give me credit =]

  parse.pas - the main part / script engine
  str.pas   - misc. string functions to make coding a lot easier
  blah.scr  - sample script

}

uses crt, str;

procedure run_script(scriptname: string);
const maxParams = 10; { if your procedure contains more than 10 parameters }
var                   { you must change this :)                            }
  f: text;
  s, tmp, command: string;
  param: array[1..maxParams] of string;
  params: byte;
  line: integer;

  procedure scripterror(s: string; i: integer);
  begin
    textcolor(7);
    textbackground(0);
    writeln;
    writeln('error in script, line #', i, ' - ', s);
  end;

  procedure badparams(s: string; i: integer);
  begin
    scripterror(s+': incorrect parameters!', i);
  end;

begin
  assign(f, scriptname);
  {$I-} reset(f); {$I+}
  if ioresult<>0 then
    begin
      writeln('error: unable to open script ('+scriptname+')');
      exit;
    end;
  line:=0;
  repeat
    repeat
      inc(line);
      readln(f, s);
      s:=truncstr(s);
      if scmp(copy(s, 1, 3), 'REM') then s:='';
    until (s<>'') or eof(f);
    if eof(f) and (s='') then
      begin
        close(f);
        exit;
      end;
    command:=truncstr(token('(', s));
    params:=0;
    repeat
      inc(params);
      s:=truncstr(s);
      if (pos(',', s)=0) and (pos(')', s)<>0) then s:=token(')', s);
      if s[1]='"' then
        begin
          delete(s, 1, 1);
          param[params]:=token('"', s);
          token(',', s);
        end else
        begin
          param[params]:=truncstr(token(',', s));
        end;
    until ((pos(',', s)=0) and (pos(')', s)=0)) or (params+1>maxParams);
{

    add / change the procedures here

}
    if scmp(command, 'PRINT') then
      begin
        if (params<>1) then
          badparams('print()', line)
        else write(param[1]);
      end else
    if scmp(command, 'PRINTLN') then
      begin
        if (params<>1) then
          badparams('println()', line)
        else writeln(param[1]);
      end else
    if scmp(command, 'GOTOXY') then
      begin
        if (params<>2) then
          badparams('gotoxy()', line)
        else gotoxy(stoi(param[1]), stoi(param[2]));
      end else
    if scmp(command, 'CLS') then
      begin
        clrscr;
      end else
    if scmp(command, 'COLOR') then
      begin
        if (params<>2) then
          badparams('color()', line)
        else
          begin
            textcolor(stoi(param[1]));
            textbackground(stoi(param[2]));
          end;
      end else
    if scmp(command, 'DELAY') then
      begin
        if (params<>1) then
          badparams('delay()', line)
        else delay(stoi(param[1]));
      end else if command<>'' then scripterror('syntax error!', line);
  until eof(f);
  close(f);
end;

begin
  run_script('blah.scr');
end.
