	DEFINT A-Z
	'$DYNAMIC
        '$INCLUDE: 'SUPP.BI'
	'
	'Term% is 1 - ANSI                    3 - AVT/0
	'         2 - VT102 (fast scrolls)    4 - Full AVT/0+ (BEST)
	'
	'BTopRow%()   Buffer row number for top row of the window
	'BRow%()      Buffer row for current cursor row
	'Row%()       Relative current row to the screen.
	'Col%()       Current column for buffer and screen
	'ARow%,ACol%  Relative cursor positon on screen
	'
	'The below are QuickBASIC subroutines part of SuperChatter:
	DECLARE FUNCTION GetNumParameter$ (Parameter$)
	DECLARE FUNCTION StatusRequest% (Port%, RRow%, RCol%, STime%)
	DECLARE SUB SetupScreenParams ()
	DECLARE SUB CommandParms (ParameterString$, ReadFlag%)
	DECLARE SUB ScanAllOptions ()
	DECLARE SUB PageForSysop ()
	DECLARE SUB SetDefaultParms ()
	DECLARE SUB ShellToDos ()
	DECLARE SUB ChatInit ()
	DECLARE SUB ChatterSetup ()
	DECLARE SUB ChatColors ()

	DECLARE SUB WClock (CurFlag%)
	DECLARE SUB TWrite (Message$)
	DECLARE SUB DefaultDef ()

	DECLARE FUNCTION WGetKey$ ()
	DECLARE SUB WHelp (HelpFlag%)
	DECLARE SUB WOutput ()
	DECLARE SUB WBackSpace ()
	DECLARE SUB WDeleteChar (NumChars%)
	DECLARE SUB WInsertString (InsertStr$)
	DECLARE SUB WWordWrap ()
	DECLARE SUB WCursorControl ()
	DECLARE SUB WStartRedraw ()
	DECLARE SUB WStartScroll ()
	DECLARE SUB WStartLine ()
	DECLARE SUB WURedraw ()
	DECLARE SUB WUpdate ()
	DECLARE SUB WIndicators ()
	DECLARE SUB WEnter ()
	DECLARE SUB WMoveCursor (NewBRow%)
	DECLARE SUB WMoveView (NewBTopRow%)
	DECLARE SUB WMovePage (Direction%)
	DECLARE SUB WLocalFunctions ()

        '$INCLUDE: 'SCOMMON.BI'

	'-------------- constants, variable, and array declarations ---------------
	CONST Testingg% = 0

	DIM SHARED Programmer%, SyncPort%, SyncBps&, Cwin%', Erred%
	DIM SHARED Remote%, LocalFunc%, CurrLocalTyping%
	DIM SHARED Char$, Char%, NoWait%, WWrap%
	DIM SHARED FBuffMax%, Packet%, MinPacket%, WPacket%
	DIM SHARED NextWin%, LastKey%, StartFlag%, PageSysop%
	DIM SHARED ClockC%, DosMessageC%
	DIM SHARED DividerBar$, TitleBarRow%
	DIM SHARED ScrStep%, MaxScrollFrac&, RedrawTick&
	DIM SHARED ChatHtSet%, ChatWidSet%, TermSet%
	DIM SHARED PrevTime$, ExitNow%, Exiting%, ExitTick&
	DIM SHARED DoorInfo%
 
	DIM SHARED BarChar$, ArrowLeft$, ArrowRight$
	CONST ExitString$ = "TERMINATE", StopExit$ = "WAIT!"
	CONST ExitR$ = " [G'bye in 5 secs...]"
	CONST StopR$ = "     [TERMINATE Override]"
	CONST ShellDosMsg$ = "[Sysop in DOS Shell...]"
	CONST IndInsert$ = "INS"
	CONST IndKeyboard$ = "#"
	CONST ExitTicks& = 91, NameOffs% = 6
	CONST MaxWWrapLen% = 30, WWrapClear% = 0
	CONST ScrP% = 1, CurP% = 2, LineP% = 3
	CONST CurFlicker% = 0
	'0 for no flickering, 1 for allowing cursor updates during scroll updates.
	CONST PagingTime% = 2000
	CONST ConfigFile$ = "CHATTER.CFG"
							
	CONST CEscape% = 2, CDoorway% = 3
	CONST CBackspace% = 4, CEnter% = 5, CTab% = 6, CLeft% = 7, CRight% = 8
	CONST CUp% = 9, CDown% = 10, CHome% = 11, CEnd% = 12
	CONST CPageUp% = 13, CPageDn% = 14, CIns% = 15, CDel% = 16
	CONST CWordLt% = 17, CWordRt% = 18, CDelLine% = 19, CInsLine% = 20
	CONST CDelWordRt% = 21, CClear% = 22, CRedraw% = 23
	CONST CScrollUp% = 24, CScrollDn% = 25, CTop% = 26, CBottom% = 27
	CONST CClrEol% = 28, CHelp% = 29
	CONST LShell% = -1, LExit% = -2, LReset% = -3, LSwitch% = -4, LBeep% = -5

	CONST Black% = 0, Blue% = 1, Green% = 2, Cyan% = 3
	CONST Red% = 4, Magenta% = 5, Brown% = 6, White% = 7
	CONST BgBlack% = 0, BgBlue% = 16, BgGreen% = 32, BgCyan% = 48
	CONST BgRed% = 64, BgMagenta% = 80, BgBrown% = 96, BgWhite% = 112
	CONST Bold% = 8, Blink% = 128

'The following are related to screen/keyboard/logfile operations
	DIM SHARED WBarCol%(MaxWin%), WNameCol%(MaxWin%)
	DIM SHARED WInsCol%(MaxWin%), WKeyboardCol%, WHelpCol%, WTermCol%
	DIM SHARED WName$(MaxWin%)
	DIM SHARED WTitleBar$(4), WTitleBarC%(4)
	DIM SHARED TextLine$, CurrLine$
	DIM SHARED SaveLine$(MaxWin%)
	DIM SHARED ChatLog%
 
	DIM SHARED WTopRow%(MaxWin%), WHeight%(MaxWin%), WBotRow%(MaxWin%)
	DIM SHARED BTopRow%(MaxWin%), Row%(MaxWin%), Col%(MaxWin%)
	DIM SHARED WhoScrollUpdate%, LastScrollUpdate%
	DIM SHARED Scrolled%(MaxWin%), ScrollWin%(MaxWin%)
	DIM SHARED RdRow%, RdCol%, RdColor%, Redrawing%, RedrawBar%, RedrawPos%
	DIM SHARED RedrawTotalLines%, RedrawData$(20)
	DIM SHARED RDataRow%(20), RDataCol%(20), RDataColor%(20), RDataClrEol%(20)

	DIM SHARED IndStat%, IndInsertFlag%(MaxWin%), IndKeyboardFlag%
	DIM SHARED Stat%(MaxWin%), WActive%(MaxWin%), WActiveKey%(MaxWin%)
	DIM SHARED ScrollStep%(MaxWin%), WControl%(MaxWin%), InsMode%(MaxWin%)
	DIM SHARED LineFlag%(60), ScrLnStep%(60), ScrollCol%(60)
	DIM SHARED KeyTable%(255), KeyTable2%(255), KeyTable3%(255)

'The following are for the help text related stuff.
	DIM SHARED PrevHelp%(MaxWin%)
	DIM SBCurrLine$(MaxWin%), SBBottom%(MaxWin%)
	DIM SBRow%(MaxWin%), SBTopRow%(MaxWin%), SSRow%(MaxWin%), SSCol%(MaxWin%)

'The following are ANSI and AVATAR code constants.
	
	DIM SHARED AVTrepeat$, AVTend$, AVTins$, AVTdel$
	DIM SHARED AVTclearblock$, AVTscrollup$, AVTscrolldn$
	AVTend$ = AVT$ + CHR$(7)
	AVTins$ = AVT$ + CHR$(9):         AVTdel$ = AVT$ + CHR$(14)
	AVTscrollup$ = AVT$ + CHR$(10):   AVTscrolldn$ = AVT$ + CHR$(11)
	AVTclearblock$ = AVT$ + CHR$(12): AVTrepeat$ = CHR$(25)
	CONST ANSrevlf$ = "M", ANSrep$ = "[6n"
	CONST ANSend$ = "[K", ANScleartoend$ = "[J"

	DIM SHARED Aend$(4), ATermName$(4)
	Aend$(1) = ANSend$: Aend$(2) = ANSend$
	Aend$(3) = AVTend$: Aend$(4) = AVTend$
	ATermName$(1) = "ANSI"
	ATermName$(2) = "VT102"
	ATermName$(3) = "AVT/0"
	ATermName$(4) = "AVT/0+"

'*************************** END OF INITIALIZATION **************************

IF Testingg% THEN OPEN "TEST" FOR OUTPUT AS #12
ChatterSetup
IF ExitNow% THEN GOTO ExitThis
IF Term% = 0 THEN
	Term% = 1
	IF Remote% = 1 THEN
		TWrite CRLF$ + CHR$(12) + ProgName$ + " remote auto-detect fails to detect ANSI or AVATAR." + CRLF$
		TWrite "You need ANSI, AVATAR or at least VT102 to use " + ProgName$ + "." + CRLF$ + CRLF$
		GOTO ExitThis2
	ELSEIF Remote% = 0 THEN
		Term% = 4
	END IF
END IF
SetupScreen:
LocalFunc% = 0
ChatColors
ChatInit
LogInit ChatLog%, WName$()            'Initializes the chat logfile
CaptureBrk 1


'********************* This is the main chatting loop! **********************

PrevTime$ = LEFT$(TIME$, 5)
BInitialize
DO
	FOR Cwin% = 1 TO NumWin%: WOutput: NEXT Cwin%
	IF LocalFunc% THEN
		SELECT CASE LocalFunc%
		CASE LShell%: ShellToDos
		CASE LExit%:  EXIT DO
		CASE LReset%: EXIT DO
		CASE LSwitch: WLocalFunctions
		CASE LBeep%:
				IF TickPassed&(OldBeep&) THEN TWrite CHR$(7): OldBeep& = Tick&
		END SELECT
		LocalFunc% = 0
	END IF
	IF PrevTime$ <> LEFT$(TIME$, 5) THEN WClock 1
	IF Exiting% THEN IF TickPassed&(ExitTick&) > ExitTicks& THEN EXIT DO
LOOP
IF LocalFunc% = LReset% THEN
	BClose
	LogClose ChatLog%
	GOTO SetupScreen
END IF

ExitThis:
TWrite AClear$(Term%) + AColor$(12) + CRLF$ + CRLF$
TWrite " THANK YOU for using SuperChatter " + ProgVer$ + "!" + CRLF$
TWrite CRLF$
TWrite "The original SuperChatter can be obtained by Mark D. Rejhon via" + CRLF$
TWrite "marky@ottawa.com or at http://www.marky.com with redistributable source code." + CRLF$
TWrite CRLF$ + CRLF$
Delayy% = 400
END IF
BClose
LogClose ChatLog%
IF Remote% THEN
	Waitt& = Time&
	DO
	LOOP UNTIL TimePassed&(Waitt&) > Delayy% OR INKEY$ = esc$
END IF
ExitThis2:
Waitt& = Time&
FCloseAll WActive%()
COLOR 7, 0
CaptureBrk 0
END
 
ErrorOccur:
	Erred% = -1
	RESUME NEXT

REM $STATIC
SUB ChatColors
	'The following are the color defaults and scroll settings for
	'SuperChatter.

	BarChar$ = "="
	ArrowLeft$ = "> "
	ArrowRight$ = " <"
	WWrap% = ChatWid% - WWrapClear%
 
	IF LEN(WName$(1)) = 0 THEN
		IF WActive%(1) = 0 THEN
			WName$(1) = "Sysop"
			WName$(2) = "User"
			WName$(3) = "User 2"
		ELSEIF WActive%(2) = 0 THEN
			WName$(1) = "User"
			WName$(2) = "Sysop"
			WName$(3) = "User 2"
		ELSE
			WName$(1) = "User"
			WName$(2) = "User 2"
			WName$(3) = "Sysop"
		END IF
	END IF
	
	BaseBack% = BgMagenta%
 
	WColr%(1) = Red% + Bold%      'BgBlue% + White%'Brown% + Bold%
	WColr%(2) = Cyan%             'BgBlue% + White%'Cyan%
	WColr%(3) = Blue% + Bold%     'BgBlue% + White%'+ Bold%'Green%
 
	WNameCol%(1) = Green% + Bold%'White% + Bold%
	WNameCol%(2) = Green% + Bold%'White% + Bold%
	WNameCol%(3) = Green% + Bold%'White% + Bold%
 
	WTitleBarC%(1) = BaseBack% + Brown% + Bold%
	WTitleBarC%(2) = BaseBack% + Green% + Bold%
	WTitleBarC%(3) = BaseBack% + Green% + Bold%
	WTitleBarC%(4) = Magenta%'+ Bold%'BaseBack% + White%'Green% + Bold%'+ White%
 
	'WBarCol%(1) = BaseBack% + White% ' + Red% + Bold%'+ White%
	'WBarCol%(2) = BaseBack% + White%'Brown% + Bold%'+ White%
	'WBarCol%(3) = BaseBack% + White%'Magenta% + Bold%'+ White%
	WBarCol%(1) = Magenta%'+ Bold%' + Red% + Bold%'+ White%
	WBarCol%(2) = Magenta%'+ Bold%'Brown% + Bold%'+ White%
	WBarCol%(3) = Magenta%'+ Bold%'+ Bold%'+ White%
 
	WInsCol%(1) = Cyan%  '+ Bold%
	WInsCol%(2) = Cyan%  '+ Bold%
	WInsCol%(3) = Cyan%
 
	ClockC% = White% 'White% + Bold%
	WKeyboardCol% = Red% + Bold%
	WHelpCol% = BaseBack% + Bold%
	WTermCol% = White%
	DosMessageC% = Bold% + Red% + Blink%
END SUB

SUB ChatInit
	TitleBarRow% = 2
	FBuffMax% = ScrWid% + 20
	MinPacket% = 40
	Packet% = ScrWid% + 20
	IF MinPacket% > Packet% THEN Packet% = MinPacket%
	WPacket% = MinPacket%
	NextWin% = 1
	TextLine$ = ""
	WBotRow%(0) = TitleBarRow% - 1
	InitExcess% = (ChatHt% - NumWin% - TitleBarRow%) MOD NumWin%
	InitHeight% = INT((ChatHt% - NumWin% - TitleBarRow%) \ NumWin%) - 1
	Redrawing% = 0
	CurrLocalTyping% = 0
	IndStat% = 0
	FOR Clrr% = 1 TO ChatHt%
		LineFlag%(Clrr%) = 0
		ScrLnStep%(Clrr%) = 0
		ScrollCol%(Clrr%) = 0
	NEXT Clrr%
	FOR Init% = 1 TO NumWin%
		'The following resolves conflicts between windows.
		Temp% = WActive%(Init%)
		FOR Test% = 1 TO NumWin%
			IF Test% <> Init% AND WActive%(Test%) <> -1 THEN
				IF WActive%(Test%) = Temp% THEN WActive%(Test%) = -1
			END IF
		NEXT Test%
		WActiveKey%(Init%) = WActive%(Init%)
		Locked%(Init%) = 0
		BRow%(Init%) = 0
		BTopRow%(Init%) = 0
		IndInsertFlag%(Init%) = 0
		Stat%(Init%) = 0
		ScrollWin%(Init%) = 0
		ScrollStep%(Init%) = 0
		InsMode%(Init%) = -1
		BCurrLine$(Init%) = SPACE$(ChatWid%)
		WName$(Init%) = LTRIM$(RTRIM$(WName$(Init%)))
		WTopRow%(Init%) = WBotRow%(Init% - 1) + 2
		WHeight%(Init%) = InitHeight% + -(InitExcess% >= Init%)
		WBotRow%(Init%) = WTopRow%(Init%) + WHeight%(Init%)
		IF Term% <> 2 AND Term% <> 4 THEN
			IF ScrStep% * 100 < WHeight%(Init%) * MaxScrollFrac& THEN
				ScrollStep%(Init%) = ScrStep%
			ELSE
				ScrollStep%(Init%) = WHeight%(Init%) * MaxScrollFrac& \ 100
			END IF
			IF ScrollStep%(Init%) > WHeight%(Init%) + 1 THEN ScrollStep%(Init%) = WHeight%(Init%) + 1
		END IF
		Row%(Init%) = WTopRow%(Init%)
		Col%(Init%) = 1
	NEXT Init%
	Temp% = 0
	FOR Init% = 1 TO NumWin%
		IF WActive%(Init%) = 0 THEN Temp% = Init%: EXIT FOR
		IF WActive%(Init%) = -1 THEN IF Temp% = 0 THEN Temp% = WActive%(Init%)
	NEXT Init%
	IF Temp% THEN
		WActive%(Temp%) = 0
		WActiveKey%(Temp%) = 0
		CurrLocalTyping% = Temp%
	END IF
	WBotRow%(0) = 0
	DividerBar$ = STRING$(ChatWid% - 1, BarChar$)
	RedrawData$(1) = " " + ProgName$ + " " + ProgVer$ + "  Made " + ProgDate$ + " by Mark Rejhon!  http://www.marky.com"
	RDataColor%(1) = WTitleBarC%(1)
	RDataColor%(TitleBarRow%) = WTitleBarC%(4)
	RedrawData$(1) = LEFT$(RedrawData$(1), ChatWid% - 1)
	RedrawData$(TitleBarRow%) = DividerBar$
	MID$(RedrawData$(TitleBarRow%), 4) = "Hit Ctrl-N for Help"
	DividerBar$ = RTRIM$(DividerBar$)
	FOR TitleBars% = 1 TO TitleBarRow%
		RDataRow%(TitleBars%) = TitleBars%
		RDataCol%(TitleBars%) = 1
		RDataClrEol%(TitleBars%) = 1
		RedrawData$(TitleBars%) = RTRIM$(RedrawData$(TitleBars%))
	NEXT TitleBars%
	FOR Divider% = 1 TO NumWin%
		BarRow% = TitleBarRow% + Divider%
		RedrawData$(BarRow%) = DividerBar$
		RDataRow%(BarRow%) = WBotRow%(Divider%) + 1
		RDataCol%(BarRow%) = 1
		RDataColor%(BarRow%) = WBarCol%(Divider%)
		RDataClrEol%(BarRow%) = 1
		BarRow% = BarRow% + NumWin%
		RedrawData$(BarRow%) = LEFT$(ArrowLeft$ + LEFT$(WName$(Divider%), 32) + ArrowRight$, ScrWid% - NameOffs% - 4)
		RDataRow%(BarRow%) = WBotRow%(Divider%) + 1
		RDataCol%(BarRow%) = NameOffs%
		RDataColor%(BarRow%) = WNameCol%(Divider%)
	NEXT Divider%
	RedrawTotalLines% = BarRow%
	WStartRedraw
END SUB

SUB ChatterSetup

	'--------------------------------------------------------------------------
	'This procedure initializes some of the DIM shared variables and
	'lookup tables.
	DefaultDef

	'This calls the command-line parameters/configuration file reader.
	ScanAllOptions

	'This calls the FOSSIL Communications initialization routine.
	FInitAll WActive%()
	
	'This calls the screen-mode and the chat screen-size calculation/setup
	'routine.
	SetupScreenParams

	'The following pages for the sysop.
	IF PageSysop% THEN PageForSysop
 
	'The following initializes the necessary variables and lookup tables
	'used by the Aprint subroutine.
	AInit
	IF Remote% > 1 THEN TWrite STRING$(7, CHR$(13))
END SUB

SUB CommandParms (ParameterString$, ReadFlag%)
	Para$ = " " + LTRIM$(UCASE$(ParameterString$)) + " "
	Stuf$ = CHR$(255)
	Test% = INSTR(Para$, " ")
	DO WHILE Test%
		MID$(Para$, Test%) = Stuf$
		Test% = INSTR(Para$, " ")
	LOOP

	'************* This is the command line parameters interpreter. *************
	IF INSTR(Para$, "?") THEN
		PRINT "SUPERCHATTER " + ProgVer$ + " Command-Line options Help screen:"
		PRINT "Copyright 1993 by Mark Rejhon. For use only by " + UserName$ + "."
		PRINT
		PRINT "/?...............Displays this help screen."
		PRINT "/DOOR:<path>.....The path for DORINFO1.DEF. (This allows the BBS to tell"
		PRINT "                 SuperChatter of the sysop's and user's names and the COM port."
		PRINT "/Wn:xx...........n is the number of windows, and xx is the COM port numbers"
		PRINT "                 for each window. 0 represents the keyboard."
		PRINT "/LOG:<name>......Enables the logfile. (appends to the filename <file>)"
		PRINT "/LOG2:<name>.....Same as above but includes the logging of edited lines."
		PRINT "/NOLOG...........Disables the logfile. (default)"
		PRINT "/H25 /H43 /H50...Sets the video adaptor's screen height. (Default is 25)"
		PRINT "/W40 /W80........Sets the video adaptor's screen width.  (Default is 80)"
		PRINT "/CWnn............Sets active chat screen height, nn between 7 and 50 lines."
		PRINT "/CHnn............Sets active chat screen width, nn between 32 and 80 columns."
		PRINT "                 The active chat screen size will calculate actual screen size."
		PRINT "/PAGE............Page for sysop on startup ("; LTRIM$(STR$(PagingTime% \ 100)); " seconds)"
		PRINT "/PAGEB...........Same as above, but uses a simpler beep."
		PRINT "/SAVE............Saves the command-line to configuration file (must be in"
		PRINT "                 current directory) to be automatically loaded as new defaults."
		PRINT "/ANS /102........Force basic ANSI or use VT102 (ANSI with scroll zone support)"
		PRINT "/AV /AV+.........Force AVT/0 (no scrolling) or AVT/0+ (fast scrolling)"
		PRINT "/GRn.............For BBS shells: n is 0 or 1 for ANSI, 2 or 3 for AVATAR."
		PRINT "                 Remote ANSI/VT102/AVT detection supplements this option.";
		END
	END IF
	PDoor% = INSTR(Para$, "/DOOR:")
	PWin% = INSTR(Para$, "/WIN")
	PSave% = INSTR(Para$, "/SAVE")
	PChatWid% = INSTR(Para$, "/CW")
	PChatHt% = INSTR(Para$, "/CH")
	PNoLog% = INSTR(Para$, "/NOLOG")
	PLog% = INSTR(Para$, "/LOG")
	PLog2% = INSTR(Para$, "/LOG2")

	IF INSTR(Para$, "/H25") THEN ScrHt% = 25
	IF INSTR(Para$, "/H43") THEN ScrHt% = 43
	IF INSTR(Para$, "/H50") THEN ScrHt% = 50
	IF INSTR(Para$, "/W40") THEN ScrWid% = 40
	IF INSTR(Para$, "/W80") THEN ScrWid% = 80
	IF INSTR(Para$, "/ANS") THEN Term% = 1: TermSet% = -1
	IF INSTR(Para$, "/102") THEN Term% = 2: TermSet% = -1
	IF INSTR(Para$, "/AV") THEN Term% = 3: TermSet% = -1
	IF INSTR(Para$, "/AV+") THEN Term% = 4: TermSet% = -1
	IF INSTR(Para$, "/PAGE") THEN PageSysop% = -1
	IF INSTR(Para$, "/PAGEB") THEN PageSysop% = -2
	IF PDoor% THEN
		DoorInfo% = 0
		Posit% = INSTR(PDoor%, Para$, ":") + 1
		Posit2% = INSTR(Posit%, Para$, Stuf$)
		DorPath$ = MID$(Para$, Posit%, Posit2% - Posit%)
	ELSEIF PWin% THEN
		WName$(1) = ""
		WName$(2) = ""
		Remote% = 0
		SyncPort% = -1
		Posit% = PWin% + 4
		NumWin% = VAL(MID$(Para$, Posit%, 1))
		IF NumWin% < 1 THEN NumWin% = 2
		IF NumWin% > 5 THEN NumWin% = 5
		FOR ReadParm% = 1 TO NumWin%
			ParmChunk$ = MID$(Para$, Posit% + ReadParm% + 1, 1)
			IF ParmChunk$ = "-" THEN WActive%(ReadParm%) = -1 ELSE WActive%(ReadParm%) = VAL(ParmChunk$)
			IF SyncPort% < 0 THEN
				IF WActive%(ReadParm%) >= 1 AND WActive%(ReadParm%) <= 4 THEN
					SyncPort% = WActive%(ReadParm%) - 1
					Remote% = Remote% + 1
				END IF
			END IF
		NEXT ReadParm%
	END IF
	IF PLog% OR PLog2% THEN
		IF PLog2% THEN ChatLog% = 2 ELSE ChatLog% = 1
		Posit% = INSTR(PLog%, Para$, ":") + 1
		Posit2% = INSTR(Posit%, Para$, Stuf$)
		Logfile$ = MID$(Para$, Posit%, Posit2% - Posit%)
	END IF
	IF PNoLog% THEN ChatLog% = 0
	IF PChatWid% THEN
		ChatWid% = VAL(MID$(Para$, PChatWid% + 3, 2))
		ChatWidSet% = -1
	END IF
	IF PChatHt% THEN
		ChatHt% = VAL(MID$(Para$, PChatHt% + 3, 2))
		ChatHtSet% = -1
	END IF
	IF PSave% <> 0 AND ReadFlag% = 0 THEN
		Temp% = INSTR(Para$, SwSaveConfig$)
		Para$ = LEFT$(Para$, PSave% - 1) + MID$(Para$, PSave% + 5)
		OPEN ConfigFile$ FOR OUTPUT AS #11
		PRINT #11, Para$
		CLOSE #11
	END IF

	IF PDoor% THEN
		IF Exist2%(DorPath$) = 0 THEN
			IF RIGHT$(DorPath$, 1) <> "\" AND LEN(DorPath$) <> 0 THEN DorPath$ = DorPath$ + "\"
			DorPath$ = DorPath$ + "DORINFO1.DEF"
		END IF
		IF Exist2%(DorPath$) = 0 THEN
			DorPath$ = ENVIRON$("RA") + "\DORINFO1.DEF"
		END IF
		Erred% = 0
		ON ERROR GOTO ErrorOccur
		OPEN DorPath$ FOR INPUT AS #1
		IF Erred% THEN
			PRINT "Error: Could not find the DORINFO1.DEF file!"
			PRINT "       Make sure you specify a path for the /DOOR: switch."
			PRINT "       If specifying just /DOOR: it will first check the current directory."
			PRINT "       Next, it will check the RA environment variable as a last resort."
			PRINT
			PRINT "Wait 30 seconds or press a key to continue..."
			SLEEP 30
		ELSE
			LINE INPUT #1, BBSname$
			LINE INPUT #1, FirstSys$
			LINE INPUT #1, LastSys$
			LINE INPUT #1, Portt$
			LINE INPUT #1, Speed$
			LINE INPUT #1, Garb$
			LINE INPUT #1, FirstUser$
			LINE INPUT #1, LastUser$
			LINE INPUT #1, Location$
			LINE INPUT #1, Video$
			WName$(1) = UCASE$(FirstSys$ + " " + LastSys$)
			WName$(2) = UCASE$(FirstUser$ + " " + LastUser$)
			WActive%(1) = 0
			WActive%(2) = VAL(MID$(Portt$, 4))
			SyncPort% = WActive%(2) - 1
			SyncBps& = VAL(Speed$)
			Vid% = VAL(Video$)
			SELECT CASE Vid%
			CASE 0: Term% = 0
			CASE 1: Term% = 1
			CASE 2: Term% = 3
			CASE 3: Term% = 4
			END SELECT
			Remote% = 0
			keyboard% = -1
			DoorInfo% = -1
			IF WActive%(2) = 0 THEN NumWin% = 2 ELSE Remote% = 1
		END IF
	END IF
	IF INSTR(Para$, "/GR0") THEN Term% = 0
	IF INSTR(Para$, "/GR1") THEN Term% = 1
	IF INSTR(Para$, "/GR2") THEN Term% = 3
	IF INSTR(Para$, "/GR3") THEN Term% = 4
END SUB

SUB DefaultDef
 
	'The below keys are control code keypresses.
	KeyTable%(8) = CBackspace%    'Backspace key
	KeyTable%(9) = CTab%          'Tab key
	KeyTable%(13) = CEnter%       'Enter key
	KeyTable%(5) = CUp%           'ctrl-e up
	KeyTable%(19) = CLeft%        'ctrl-s left
	KeyTable%(4) = CRight%        'ctrl-d right
	KeyTable%(24) = CDown%        'ctrl-x down
	KeyTable%(15) = CHome%        'ctrl-o home
	KeyTable%(16) = CEnd%         'ctrl-p end
	KeyTable%(18) = CPageUp%      'ctrl-r page up
	KeyTable%(3) = CPageDn%       'ctrl-c page down
	KeyTable%(22) = CIns%         'ctrl-v insert
	KeyTable%(127) = CBackspace%  'Unix backspace key.
	KeyTable%(7) = CDel%          'ctrl-g delete
	KeyTable%(25) = CDelLine%     'ctrl-y del line
	KeyTable%(21) = CInsLine%     'ctrl-u ins line
	KeyTable%(20) = CDelWordRt%   'ctrl-t del word right
	KeyTable%(1) = CWordLt%       'ctrl-a word left
	KeyTable%(6) = CWordRt%       'ctrl-f word right
	KeyTable%(12) = CRedraw%      'ctrl-l redraw
	KeyTable%(11) = CClear%       'ctrl-k clear window
	KeyTable%(23) = CScrollUp%    'ctrl-w scroll up
	KeyTable%(26) = CScrollDn%    'ctrl-z scroll down
	KeyTable%(26) = CScrollDn%    'ctrl-z scroll down
	KeyTable%(14) = CHelp%        'ctrl-n Help screen
	KeyTable%(27) = 2             'Escape
	KeyTable%(0) = 3              'IBM keypress code (Doorway)
	KeyTable%(224) = 3            'Enhanced IBM keypress code (Doorway)

	'The below are Doorway Mode keypresses
	KeyTable2%(ASC("H")) = CUp%       'Up
	KeyTable2%(ASC("P")) = CDown%     'Down
	KeyTable2%(ASC("K")) = CLeft%     'Left
	KeyTable2%(ASC("M")) = CRight%    'Right
	KeyTable2%(ASC("G")) = CHome%     'Home
	KeyTable2%(ASC("O")) = CEnd%      'End
	KeyTable2%(ASC("I")) = CPageUp%   'Page Up
	KeyTable2%(ASC("Q")) = CPageDn%   'Page Down
	KeyTable2%(ASC("R")) = CIns%      'Insert
	KeyTable2%(ASC("S")) = CDel%      'Delete
	KeyTable2%(ASC("s")) = CWordLt%   'Ctrl-Left   Left one word
	KeyTable2%(ASC("t")) = CWordRt%   'Ctrl-Right  Right one word
	KeyTable2%(ASC("w")) = CClear%    'Ctrl-Home   Clear window
	KeyTable2%(ASC("u")) = CClrEol%   'Ctrl-End    Clear to end of line
	KeyTable2%(ASC("@")) = CClrEol%   'F6          Clear to end of line
	KeyTable2%(ASC("")) = CTop%      'Ctrl-PgUp   Top of text
	KeyTable2%(ASC("v")) = CBottom%   'Ctrl-PgDn   Bottom of text
	KeyTable2%(ASC(".")) = CClear%    'Alt-C       Clear window
	KeyTable2%(ASC(";")) = CHelp%     'F1          Help screen
	KeyTable2%(19) = CRedraw%         'Alt-R       Redraw
	KeyTable2%(224) = 3               'Enhanced keyboard doorway mode

	'The below are local only keypresses
	KeyTable%(17) = LSwitch%          'Ctrl-Q      Switch windows
	KeyTable2%(ASC("$")) = LShell%    'Alt-J       DOS shell
	KeyTable2%(ASC("-")) = LExit%     'Alt-X       Exit
	KeyTable2%(ASC("")) = LReset%    'Shift-Tab   Master Reset
	KeyTable2%(34) = LBeep%           'Alt-G       Send Beep to user

	'The below are ANSI code suffixes
	KeyTable3%(ASC("A")) = CUp%       'Up
	KeyTable3%(ASC("B")) = CDown%     'Down
	KeyTable3%(ASC("C")) = CRight%    'Left
	KeyTable3%(ASC("D")) = CLeft%     'Right
	KeyTable3%(ASC("H")) = CHome%     'Home
	KeyTable3%(ASC("K")) = CEnd%      'End

	Term% = 0
	NumWin% = 2
	Remote% = 1
	WActive%(1) = 0
	WActive%(2) = 1
	SyncPort% = 0
	LocalFunc% = 0
	ScrHt% = 25
	ScrWid% = 80
	ChatHt% = 24
	ChatWid% = 80
	ScrStep% = 100
	MaxScrollFrac& = 50
	FBuffMax% = 8     'No of chars left in xmit buffer before permitting more
	MinPacket% = 4    'Minimum amount of data to process at a time.
	Packet% = 20      'Amount of data to process at a time after a keypress.
END SUB

SUB PageForSysop
	Leng& = Time&
	Beeper& = Tick&
	VIEW PRINT 1 TO ScrHt%
	CLS
	COLOR 15, 0
	LOCATE 1
	PRINT ProgName$ + " "; ProgVer$; " Programmed by Mark Rejhon --- PAGING FOR SYSOP"
	LOCATE ScrHt%, , 0
	IF DoorInfo% THEN
		PRINT "User Paging: "; WName$(2);
		LOCATE , 42
		PRINT "   ";
	END IF
	PRINT "ESC to abort, Any OTHER KEY to Chat.";
	DO
		IF TickPassed&(Beeper&) > 27 THEN
			IF PageSysop% = -1 THEN PLAY "mbo4l10do3l10co2l10b" ELSE BEEP
			Beeper& = Tick&
		END IF
		IF TickPassed&(Flash&) > 2 THEN
			CO% = (CO% + 1) AND 7
			ScrollBlock 0, 0, 15, CO%, 2, 1, ScrHt% - 1, ScrWid%
			Flash& = Tick&
		END IF
		Keyy% = 0
		Regs.ax = &H100
		INTERRUPT &H16, Regs, Regs
		IF (Regs.flags AND 64) = 0 THEN Keyy% = Regs.ax AND 255: EXIT DO
	LOOP UNTIL TimePassed&(Leng&) > PagingTime%
	COLOR 7, 0
	CLS
	IF Keyy% = 27 OR TimePassed&(Leng&) > PagingTime% THEN Test$ = INKEY$: END
END SUB

SUB ScanAllOptions
	IF INSTR(COMMAND$, "?") THEN CommandParms COMMAND$, 0
	ON ERROR GOTO ErrorOccur
	Erred% = 0
	OPEN ConfigFile$ FOR INPUT AS #10
	IF Erred% = 0 THEN INPUT #10, Temp$: CommandParms Temp$, 1
	CLOSE #10
	CommandParms COMMAND$, 0
	ON ERROR GOTO 0

END SUB

SUB SetupScreenParams
	ON ERROR GOTO ErrorOccur
	IF ChatHt% > 50 THEN ChatHt% = 50: ScrHt% = 50
	IF ChatHt% > 43 THEN
		Erred% = 0
		WIDTH 80, 50
		IF Erred% THEN ScrHt% = 43: ChatHt% = 43 ELSE ScrHt% = 50
	END IF
	IF ChatHt% > 25 AND ScrHt% <> 50 THEN
		Erred% = 0
		WIDTH 80, 43
		IF Erred% THEN ScrHt% = 25: ChatHt% = 25 ELSE ScrHt% = 43
	END IF
	IF ChatWid% <= 40 THEN
		Erred% = 0
		WIDTH 40, 25
		IF Erred% THEN ScrWid% = 80 ELSE ScrWid% = 40
	ELSEIF ChatWid% > 80 THEN
		ScrWid% = 80
		ChatWid% = 80
	END IF
	IF Remote% = 1 THEN
		IF FCarrier%(SyncPort%) THEN
			StatReq% = -1
		ELSE
			IF Term% = 0 THEN Term% = 1
		END IF
	END IF
	IF StatReq% THEN
		COLOR 15, 0
		CLS
		PRINT "SuperChatter: Attempting to autodetect remote screen size..."
		FOutClear SyncPort%
		FSend SyncPort%, STRING$(6, CHR$(13)) + CHR$(12)
		FSend SyncPort%, escbr$ + "50H" + ANSrep$
		IF StatusRequest%(SyncPort%, RemHt%, RemWid%, 800) THEN
			IF NOT ChatHtSet% THEN
				IF RemHt% > ScrHt% THEN
					ChatHt% = ScrHt%
				ELSEIF RemHt% >= 20 THEN
					ChatHt% = RemHt%
				END IF
			END IF
			IF NOT TermSet% THEN
				PRINT "SuperChatter: Now autodetecting remote terminal emulation..."
				Term% = 1
				Test$ = Test$ + escbr$ + "0;30m" + escbr$ + "3;6r" + escbr$ + "4;2H" + CHR$(10) + ANSrevlf$
				Test$ = Test$ + ANSrevlf$ + ANSrevlf$ + ANSrep$ + escbr$ + "1r"
				Test$ = Test$ + escbr$ + "2;2H" + CHR$(25) + " " + CHR$(9) + ANSrep$
				Test$ = Test$ + CHR$(22) + CHR$(25) + CHR$(2) + "  " + CHR$(13) + ANSrep$
				FSend SyncPort%, Test$
				IF StatusRequest%(SyncPort%, RRow%, RCol%, 600) THEN
					IF StatusRequest%(SyncPort%, RRow2%, RCol2%, 200) THEN
						Stat% = StatusRequest%(SyncPort%, RRow3%, RCol3%, 200)
					END IF
				END IF
				IF RRow% = 3 AND RCol% = 2 THEN Term% = 2
				IF (RRow2% = 2 AND RCol2% = 11) OR (RRow2% = 11 AND RCol2% = 2) THEN
					IF Term% <> 2 THEN Term% = 3
					IF (RRow3% = 2 AND RCol3% = 37) THEN Term% = 4
				END IF
			END IF
		ELSE
			ANScompatible% = -1
		END IF
		CLS
	ELSE
		IF NOT ChatHtSet% THEN ChatHt% = ScrHt%
	END IF
	ON ERROR GOTO 0
	SetScrSize ScrWid%, ScrHt%
END SUB

SUB ShellToDos
	DIM ScreenStore AS STRING * 4000
	Old% = OldColor%
	TWrite ASaveLoc$(0) + ALocate$(OldRow%, OldCol%, TitleBarRow%, 4) + AColor$(DosMessageC%) + ShellDosMsg$ + ASaveLoc$(1) + AColor$(Old%)
	GetBlock VARSEG(ScreenStore), VARPTR(ScreenStore), 1, 1, ChatHt%, ChatWid%
	Regs.ax = &HF00
	INTERRUPT &H10, Regs, Regs
	OldMode% = Regs.ax AND 255
	COLOR 7, 0
	CLS
	SHELL
	Regs.ax = &HF00
	INTERRUPT &H10, Regs, Regs
	IF Regs.ax AND 255 <> OldMode% THEN Regs.ax = OldMode%: INTERRUPT &H10, Regs, Regs
	IF ScrWid% = 80 THEN WIDTH 40, 25 ELSE WIDTH 80, 25
	WIDTH ScrWid%, ScrHt%
	FInitAll WActive%()
	CLS
	LOCATE , , 1, 6, 7
	PutBlock VARSEG(ScreenStore), VARPTR(ScreenStore), 1, 1, ChatHt%, ChatWid%
	ForceLocate% = -1
	ForceColor% = -1
	TWrite ALocate$(0, 0, TitleBarRow%, 4) + AColor$(RDataColor%(TitleBarRow%)) + STRING$(LEN(ShellDosMsg$), BarChar$) + ASaveLoc$(1) + AColor$(Old%)
END SUB

FUNCTION StatusRequest% (Port%, RRow%, RCol%, STime%)
	Snap& = Time&
	RRow% = 0
	RCol% = 0
	Temp$ = ""
	DO
		TempChar$ = FInkey$(Port%)
		IF LEN(TempChar$) THEN
			SELECT CASE TempChar$
			CASE esc$
				IF Temp$ = "" THEN Temp$ = esc$
			CASE "["
				IF Temp$ = esc$ THEN Temp$ = Temp$ + "[" ELSE Temp$ = ""
			CASE "R"
				IF LEN(Temp$) >= 2 THEN
					StatusRequest% = -1
					Div% = INSTR(Temp$, ";")
					RCol% = VAL(MID$(Temp$, Div% + 1, 4))
					RRow% = VAL(MID$(Temp$, 3, 4))
					EXIT DO
				END IF
				Temp$ = ""
			CASE ELSE
				IF LEN(Temp$) >= 2 THEN Temp$ = Temp$ + TempChar$ ELSE Temp$ = ""
			END SELECT
		END IF
	LOOP UNTIL TimePassed&(Snap&) > STime%

END FUNCTION

SUB TWrite (Message$)
	FOR OutSources% = 1 TO NumWin%
		OutSend% = WActive%(OutSources%)
		IF OutSend% >= 1 AND OutSend% <= 4 THEN
			IF FCarrier%(OutSend% - 1) THEN FSend OutSend% - 1, Message$
		END IF
	NEXT OutSources%
	IF Testingg% THEN PRINT #12, Message$;
	Aprint Message$
END SUB

SUB WBackSpace
	IF Locked%(Cwin%) THEN EXIT SUB
	IF Col%(Cwin%) > 1 THEN
		Col%(Cwin%) = Col%(Cwin%) - 1
		MID$(BCurrLine$(Cwin%), Col%(Cwin%)) = " "
		IF InsMode%(Cwin%) THEN
			IF ScrLnStep%(Row(Cwin%)) THEN ScrollCol%(Row(Cwin%)) = Col%(Cwin%)
			WDeleteChar 1
			EXIT SUB
		END IF
		WStartLine
	ELSE
		IF BRow%(Cwin%) > 0 THEN
			WMoveCursor BRow%(Cwin%) - 1
			Col%(Cwin%) = LEN(RTRIM$(BCurrLine$(Cwin%))) + 1
		END IF
	END IF
END SUB

SUB WClock (CurFlag%)
	PrevTime$ = LEFT$(TIME$, 5)
	IF CurFlag% THEN
		Oldd% = OldColor%
		TWrite ASaveLoc$(0) + AColor$(ClockC%) + ALocate$(OldRow%, OldCol%, TitleBarRow%, ChatWid% - 5) + PrevTime$ + ASaveLoc$(1) + AColor$(Oldd%)
	ELSE
		TWrite AColor$(ClockC%) + ALocate$(OldRow%, OldCol%, TitleBarRow%, ChatWid% - 5) + PrevTime$
	END IF
END SUB

SUB WCursorControl STATIC
	IF WControl%(Cwin%) = 0 THEN
		IF KeyTable%(Char%) = 0 THEN EXIT SUB
		WControl%(Cwin%) = KeyTable%(Char%)
		IF WControl%(Cwin%) >= 1 AND WControl%(Cwin%) <= 3 THEN
			IF LEN(Char$) = 1 THEN Char% = 0: EXIT SUB
			WControl%(Cwin%) = KeyTable2%(ASC(RIGHT$(Char$, 1)))
		END IF
	ELSEIF WControl%(Cwin%) >= 1 AND WControl%(Cwin%) <= 3 THEN
		IF WControl%(Cwin%) = CDoorway% THEN
			IF KeyTable2%(Char%) = CDoorway% THEN Char% = 0: EXIT SUB
			WControl%(Cwin%) = KeyTable2%(Char%)
		ELSEIF WControl%(Cwin%) = CEscape% THEN
			IF Char$ = "[" THEN
				WControl%(Cwin%) = 1
				Char% = 0
				EXIT SUB
			ELSEIF LEN(Char$) = 2 THEN
				WControl%(Cwin%) = KeyTable2%(ASC(RIGHT$(Char$, 1)))
			ELSE
				IF Char% <> 27 THEN
					WControl%(Cwin%) = 0
				ELSEIF Locked%(Cwin%) THEN
					WHelp 0
					WControl%(Cwin%) = 0
				END IF
				EXIT SUB
			END IF
		ELSE  'is 1
			WControl%(Cwin%) = KeyTable3%(Char%)
			IF WControl%(Cwin%) = 0 THEN EXIT SUB
		END IF
	END IF
	SELECT CASE WControl%(Cwin%)
	CASE 0, CDoorway%: Char% = 0: EXIT SUB          'Unused keypress
	CASE CBackspace%: WBackSpace                    'Backspace
	CASE CEnter%:     WEnter                        'Enter
	CASE CLeft%                                     'Cursor left
		IF Col%(Cwin%) > 1 THEN
			Col%(Cwin%) = Col%(Cwin%) - 1
			IF LineFlag%(Row%(Cwin%)) < 3 THEN Stat%(Cwin%) = Stat%(Cwin%) OR 1
		END IF
	CASE CRight%                                    'Cursor right
		IF Col%(Cwin%) < WWrap% THEN
			Col%(Cwin%) = Col%(Cwin%) + 1
			IF LineFlag%(Row%(Cwin%)) < 3 THEN Stat%(Cwin%) = Stat%(Cwin%) OR 1
		END IF
	CASE CUp%:   WMoveCursor BRow%(Cwin%) - 1       'Cursor up
	CASE CDown%: WMoveCursor BRow%(Cwin%) + 1       'Cursor down
	CASE CDel%:  WDeleteChar 1                      'Delete char
	CASE CHome%                                     'Home
		Col%(Cwin%) = 1
		Stat%(Cwin%) = Stat%(Cwin%) OR 1
	CASE CEnd%                                      'End
		Col%(Cwin%) = LEN(RTRIM$(BCurrLine$(Cwin%))) + 1
		Stat%(Cwin%) = Stat%(Cwin%) OR 1
	CASE CTab%                                      'Tab
		Temp% = Col%(Cwin%) - ((Col%(Cwin%) - 1) MOD 8) + 8
		IF Temp% < WWrap% THEN
			Col%(Cwin%) = Temp%
		ELSE
			IF BRow%(Cwin%) < BBottom%(Cwin%) - 1 THEN WEnter
		END IF
		Stat%(Cwin%) = Stat%(Cwin%) OR 1
	CASE CWordLt%                                   'Left one word
		Temp% = Compare%(BCurrLine$(Cwin%), SPACE$(80), 1)
		IF Temp% >= Col%(Cwin%) THEN
			IF BRow%(Cwin%) > 0 THEN
				WMoveCursor BRow%(Cwin%) - 1
				Col%(Cwin%) = LEN(RTRIM$(BCurrLine$(Cwin%))) + 1
			END IF
		ELSE
			TempCol% = 1
			DO WHILE TempCol% < Col%(Cwin%)
				PrevPos% = TempCol%
				Old% = Contrast%(BCurrLine$(Cwin%), SPACE$(80), TempCol%)
				TempCol% = Compare%(BCurrLine$(Cwin%), SPACE$(80), Old%)
			LOOP
			Col%(Cwin%) = PrevPos%
		END IF
		Stat%(Cwin%) = Stat%(Cwin%) OR 1
	CASE CWordRt%                                   'Right one word
		CRow$ = RTRIM$(BCurrLine$(Cwin%))
		IF Col%(Cwin%) > LEN(CRow$) THEN
			IF BRow%(Cwin%) < BBottom%(Cwin%) - 1 THEN
				WMoveCursor BRow%(Cwin%) + 1
				Col%(Cwin%) = Compare%(RTRIM$(BCurrLine$(Cwin%)), SPACE$(80), 1)
			END IF
		ELSE
			Old% = Contrast%(CRow$, SPACE$(80), Col%(Cwin%))
			Col%(Cwin%) = Compare%(CRow$, SPACE$(80), Old%)
		END IF
		Stat%(Cwin%) = Stat%(Cwin%) OR 1
	CASE CDelWordRt%                                'Delete right word
		IF Locked%(Cwin%) = 0 THEN
			IF Col%(Cwin%) <= LEN(BCurrLine$(Cwin%)) THEN
				New% = Contrast%(BCurrLine$(Cwin%), SPACE$(ChatWid%), Col%(Cwin%))
				IF Col%(Cwin%) = New% THEN New% = Compare%(BCurrLine$(Cwin%), SPACE$(ChatWid%), New%)
				WDeleteChar New% - Col%(Cwin%)
			END IF
			WStartLine
		END IF
	CASE CPageUp%: WMovePage -WHeight%(Cwin%) - 1   'Page up
	CASE CPageDn%: WMovePage WHeight%(Cwin%) + 1    'Page down
	CASE CScrollUp%:                                'Scroll upwards
		IF BTopRow%(Cwin%) > 0 THEN
			IF Row%(Cwin%) < WBotRow%(Cwin%) THEN Row%(Cwin%) = Row%(Cwin%) + 1
			WMoveView BTopRow%(Cwin%) - 1
		END IF
	CASE CScrollDn%                                 'Scroll downwards
		IF BTopRow%(Cwin%) < BBottom%(Cwin%) THEN
			IF Row%(Cwin%) > WTopRow%(Cwin%) THEN Row%(Cwin%) = Row%(Cwin%) - 1
			WMoveView BTopRow%(Cwin%) + 1
		END IF
	CASE CClrEol%                                   'Clear to end of line
		IF Locked%(Cwin%) = 0 THEN
			MID$(BCurrLine$(Cwin%), Col%(Cwin%)) = SPACE$(ChatWid% - Col%(Cwin%))
			WStartLine
		END IF
	CASE CDelLine%                                  'Delete line
		IF LEN(RTRIM$(BCurrLine$(Cwin%))) THEN SaveLine$(Cwin%) = BCurrLine$(Cwin%)
		IF Locked%(Cwin%) = 0 THEN
			BCurrLine$(Cwin%) = SPACE$(ChatWid%)
			WStartLine
		END IF
	CASE CInsLine%                                  'Insert line
		IF Locked%(Cwin%) = 0 THEN
			MID$(BCurrLine$(Cwin%), 1) = SaveLine$(Cwin%)
			WStartLine
		END IF
	CASE CTop%                                      'Top of text
		Row%(Cwin%) = WTopRow%(Cwin%)
		WMoveView 0
	CASE CBottom%                                   'Bottom of text
		Row%(Cwin%) = WBotRow%(Cwin%)
		WMoveView BBottom%(Cwin%) - 1 - WHeight%(Cwin%)
	CASE CIns%                                      'Insert mode
		InsMode%(Cwin%) = InsMode%(Cwin%) = 0
		IndStat% = -1
	CASE CClear%                                    'Clear window
		IF BCurrSave$(Cwin%) <> BCurrLine$(Cwin%) THEN
			BLineWrite Cwin%, BRow%(Cwin%), BCurrLine$(Cwin%)
			IF ChatLog% = 2 THEN LogLine RTRIM$(BCurrLine$(Cwin%)), Cwin%
		END IF
		FOR ScanBuff% = BBottom%(Cwin%) - 1 TO 0 STEP -1
			IF RTRIM$(BLineRead$(Cwin%, ScanBuff%)) <> "" THEN EXIT FOR
		NEXT ScanBuff%
		IF ScanBuff% = BBottom%(Cwin%) - 1 THEN
			BRow%(Cwin%) = BBottom%(Cwin%) - 1
			BCurrLine$(Cwin%) = BLineRead$(Cwin%, BRow%(Cwin%))
			BCurrSave$(Cwin%) = BCurrLine$(Cwin%)
			WEnter
			BTopRow%(Cwin%) = BBottom%(Cwin%) - 1
			Row%(Cwin%) = WTopRow%(Cwin%)
		ELSE
			Row%(Cwin%) = WTopRow%(Cwin%)
			Col%(Cwin%) = 1
			WMoveView ScanBuff% + 1
		END IF
		ScrollWin%(Cwin%) = 0
		WStartScroll
		Scrolled%(Cwin%) = -2
	CASE CHelp%                                     'Toggle help
		WHelp 2
	CASE CRedraw%                                   'Redraw screen
		IF TickPassed&(RedrawTick&) > 18 THEN
			WStartRedraw
			RedrawTick& = Tick&
		END IF
	CASE IS < 0                                     'Sysop Functions
		IF WActiveKey%(Cwin%) <= 0 THEN LocalFunc% = WControl%(Cwin%)
	END SELECT
	WControl%(Cwin%) = 0
	Char% = 0
END SUB

SUB WDeleteChar (NumChars%)
	IF Locked%(Cwin%) THEN EXIT SUB
	Temp$ = MID$(BCurrLine$(Cwin%), Col%(Cwin%) + NumChars%) + SPACE$(NumChars%)
	MID$(BCurrLine$(Cwin%), Col%(Cwin%)) = Temp$
	CurrRow% = Row%(Cwin%)
	IF LEN(RTRIM$(Temp$)) THEN
		IF ScrLnStep%(CurrRow%) THEN
			IF Col%(Cwin%) > ScrollCol%(CurrRow%) THEN ScrollCol%(CurrRow%) = Col%(Cwin%)
			ScrLnStep%(CurrRow%) = ScrLnStep%(CurrRow%) - NumChars%
		ELSE
			ScrollCol%(CurrRow%) = Col%(Cwin%)
			ScrLnStep%(CurrRow%) = -NumChars%
		END IF
	ELSE
		ScrLnStep%(CurrRow%) = 0
		ScrollCol%(CurrRow%) = 0
	END IF
	WStartLine
END SUB

SUB WEnter STATIC
	IF Locked%(Cwin%) = 0 THEN
		Testtt$ = UCASE$(RTRIM$(BCurrLine$(Cwin%)))
		IF Testtt$ = ExitString$ THEN                      'SC commands
			MID$(BCurrLine$(Cwin%), LEN(ExitString$) + 1) = ExitR$
			WStartLine
			Exiting% = 1
			ExitTick& = Tick&
		ELSEIF Exiting% THEN
			IF Testtt$ = StopExit$ THEN
				MID$(BCurrLine$(Cwin%), LEN(StopExit$) + 1) = StopR$
				WStartLine
				Exiting% = 0
			END IF
		END IF
		IF BRow%(Cwin%) + 1 >= BBottom%(Cwin%) THEN
			IF ChatLog% = 1 THEN
				LogLine RTRIM$(BCurrLine$(Cwin%)), Cwin%
			ELSEIF ChatLog% = 2 THEN
				IF RTRIM$(BCurrLine$(Cwin%)) = "" THEN LogLine "", Cwin%
			END IF
			IF BBottom%(Cwin%) >= BuffLines% THEN
				Old% = BIndex%(Cwin%, 0)
				FOR Move% = 0 TO BuffLines% - 2
					BIndex%(Cwin%, Move%) = BIndex%(Cwin%, Move% + 1)
					BFlag%(Cwin%, Move%) = BFlag%(Cwin%, Move% + 1)
				NEXT Move%
				BIndex%(Cwin%, BuffLines% - 1) = Old%
				BFlag%(Cwin%, BuffLines% - 1) = 1
				BMemoryTop%(Cwin%) = BMemoryTop%(Cwin%) - 1
				BRow%(Cwin%) = BRow%(Cwin%) - 1
				BTopRow%(Cwin%) = BTopRow%(Cwin%) - 1
			ELSE
				BBottom%(Cwin%) = BBottom%(Cwin%) + 1
			END IF
		END IF
	END IF
	WMoveCursor BRow%(Cwin%) + 1
	Stat%(Cwin%) = Stat%(Cwin%) OR 1
	Col%(Cwin%) = 1
END SUB

FUNCTION WGetKey$
	'IF Cwin% = 2 THEN
	'  Test$ = CHR$(32 + INT(RND(1) * 224))
	'  IF Test$ = CHR$(224) THEN WGetKey$ = "!" ELSE WGetKey$ = Test$
	'  EXIT FUNCTION
	'END IF
	Temp% = WActiveKey%(Cwin%)
	IF Temp% >= 1 AND Temp% <= 4 THEN
		WGetKey$ = FInkey$(Temp% - 1)
	ELSEIF NOT Temp% THEN
		WGetKey$ = INKEY$
	END IF
END FUNCTION

SUB WHelp (HelpFlag%) STATIC
	'HelpFlag% = 0=turn off help, 1=display help, 2=toggle help
	IF HelpFlag% = 2 THEN
		IF PrevHelp%(Cwin%) = 0 THEN HelpFlag% = 1 ELSE HelpFlag% = 0
	END IF
	IF HelpFlag% <> 0 AND PrevHelp%(Cwin%) = 0 THEN
		Locked%(Cwin%) = -1
		SBCurrLine$(Cwin%) = BCurrLine$(Cwin%)
		SBBottom%(Cwin%) = BBottom%(Cwin%)
		SBRow%(Cwin%) = BRow%(Cwin%)
		SBTopRow%(Cwin%) = BTopRow%(Cwin%)
		SSRow%(Cwin%) = Row%(Cwin%)
		SSCol%(Cwin%) = Col%(Cwin%)

		BBottom%(Cwin%) = BHelpBuffLen%
		BRow%(Cwin%) = 0
		BTopRow%(Cwin%) = 0
		Row%(Cwin%) = WTopRow%(Cwin%)
		Col%(Cwin%) = 1
		BCurrLine$(Cwin%) = BLineRead$(Cwin%, 0)
		WStartScroll
	ELSEIF HelpFlag% = 0 AND PrevHelp%(Cwin%) <> 0 THEN
		Locked%(Cwin%) = 0
		BCurrLine$(Cwin%) = SBCurrLine$(Cwin%)
		BBottom%(Cwin%) = SBBottom%(Cwin%)
		BRow%(Cwin%) = SBRow%(Cwin%)
		BTopRow%(Cwin%) = SBTopRow%(Cwin%)
		Row%(Cwin%) = SSRow%(Cwin%)
		Col%(Cwin%) = SSCol%(Cwin%)
		WStartScroll
	END IF
	PrevHelp%(Cwin%) = HelpFlag%

END SUB

SUB WIndicators STATIC
	FOR Test% = 1 TO NumWin%
		IF IndInsertFlag%(Test%) <> InsMode%(Test%) THEN
			IF InsMode%(Test%) THEN
				TWrite AColor$(WInsCol%(Test%)) + ALocate$(OldRow%, OldCol%, WBotRow%(Test%) + 1, ChatWid% - 3) + IndInsert$
			ELSE
				TWrite AColor$(WBarCol%(Test%)) + ALocate$(OldRow%, OldCol%, WBotRow%(Test%) + 1, ChatWid% - 3) + STRING$(LEN(IndInsert$), BarChar$)
			END IF
			IndInsertFlag%(Test%) = InsMode%(Test%)
			Stat%(Test%) = Stat%(Test%) OR 1
			LastScrollUpdate% = 0
			EXIT SUB
		END IF
	NEXT Test%
	IF IndKeyboardFlag% <> CurrLocalTyping% THEN
		IF IndKeyboardFlag% THEN
			TWrite AColor$(WBarCol%(IndKeyboardFlag%)) + ALocate$(OldRow%, OldCol%, WBotRow%(IndKeyboardFlag%) + 1, 4) + STRING$(LEN(IndKeyboard$), BarChar$)
		END IF
		TWrite AColor$(WKeyboardCol%) + ALocate$(OldRow%, OldCol%, WBotRow%(CurrLocalTyping%) + 1, 4) + IndKeyboard$
		Stat%(CurrLocalTyping%) = Stat%(CurrLocalTyping%) OR 1
		IndKeyboardFlag% = CurrLocalTyping%
		LastScrollUpdate% = 0
		EXIT SUB
	END IF
	IndStat% = 0
END SUB

SUB WInsertString (InsertStr$)
	IF Locked%(Cwin%) THEN EXIT SUB
	Chunk$ = MID$(BCurrLine$(Cwin%), Col%(Cwin%), WWrap% - Col%(Cwin%) - LEN(InsertStr$))
	MID$(BCurrLine$(Cwin%), Col%(Cwin%)) = InsertStr$ + Chunk$
	CurrRow% = Row%(Cwin%)
	IF LEN(RTRIM$(Chunk$)) THEN
		IF ScrLnStep%(CurrRow%) THEN
			ScrollCol%(CurrRow%) = ScrollCol%(CurrRow%) + LEN(InsertStr$)
			ScrLnStep%(CurrRow%) = ScrLnStep%(CurrRow%) + LEN(InsertStr$)
		ELSE
			ScrollCol%(CurrRow%) = Col%(Cwin%) + LEN(InsertStr$)
			ScrLnStep%(CurrRow%) = LEN(InsertStr$)
		END IF
	ELSE
		ScrollCol%(CurrRow%) = 0
		ScrLnStep%(CurrRow%) = 0
	END IF
END SUB

SUB WLocalFunctions
	SELECT CASE LocalFunc%
	CASE LSwitch%
		CurrLocalTyping% = CurrLocalTyping% + 1
		IF CurrLocalTyping% > NumWin% THEN CurrLocalTyping% = 1
		FOR Test% = 1 TO NumWin%
			Temp% = WActive%(Test%)
			IF Temp% = 0 THEN Temp% = -1
			WActiveKey%(Test%) = Temp%
		NEXT Test%
		WActiveKey%(CurrLocalTyping%) = 0
		Stat%(CurrLocalTyping%) = Stat%(CurrLocalTyping%) OR 1
		IndStat% = -1
	END SELECT
END SUB

SUB WMoveCursor (NewBRow%)
	IF ChatLog% = 2 AND Locked%(Cwin%) = 0 THEN
		IF BCurrSave$(Cwin%) <> BCurrLine$(Cwin%) THEN LogLine RTRIM$(BCurrLine$(Cwin%)), Cwin%
	END IF
	New% = NewBRow%
	IF New% < 0 THEN New% = 0 ELSE IF New% > BBottom%(Cwin%) - 1 THEN New% = BBottom%(Cwin%) - 1
	IF New% = BRow%(Cwin%) THEN EXIT SUB
	NewRow% = Row%(Cwin%) - BRow%(Cwin%) + New%
	IF NewRow% < WTopRow%(Cwin%) THEN
		NewRow% = WTopRow%(Cwin%) + ScrollStep%(Cwin%)
		IF New% - NewRow% + WTopRow%(Cwin%) < 1 THEN NewRow% = WTopRow%(Cwin) + New%
	ELSEIF NewRow% > WBotRow%(Cwin%) THEN
		NewRow% = WBotRow%(Cwin%) - ScrollStep%(Cwin%)
	END IF
	Row%(Cwin%) = NewRow%
	NewBTopRow% = New% - NewRow% + WTopRow%(Cwin%)
	IF BTopRow%(Cwin%) <> NewBTopRow% THEN
		IF NOT ScrollStep%(Cwin%) THEN ScrollWin%(Cwin%) = ScrollWin%(Cwin%) + NewBTopRow% - BTopRow%(Cwin%)
		Scrolled%(Cwin%) = -2
	ELSE
		IF Stat%(Cwin%) = 0 THEN Stat%(Cwin%) = Stat%(Cwin%) OR 1
	END IF
	BTopRow%(Cwin%) = NewBTopRow%
	IF New% <> BRow%(Cwin%) THEN
		IF BCurrSave$(Cwin%) <> BCurrLine$(Cwin%) THEN
			BLineWrite Cwin%, BRow%(Cwin%), BCurrLine$(Cwin%)
		END IF
		BRow%(Cwin%) = New%
		BCurrLine$(Cwin%) = BLineRead$(Cwin%, New%)
		BCurrSave$(Cwin%) = BCurrLine$(Cwin%)
	END IF
END SUB

SUB WMovePage (Direction%)
	New% = BTopRow%(Cwin%) + Direction%
	IF New% < 0 THEN
		IF BTopRow%(Cwin%) = 0 THEN New% = 0: Row%(Cwin%) = WTopRow%(Cwin%)
	ELSEIF BRow%(Cwin%) + Direction% > BBottom%(Cwin%) - 1 THEN
		New% = BBottom%(Cwin%) - 1 + WTopRow%(Cwin%) - Row%(Cwin%)
	END IF
	WMoveView New%
END SUB

SUB WMoveView (NewBTopRow%)
	IF ChatLog% = 2 AND Locked%(Cwin%) = 0 THEN
		IF BCurrSave$(Cwin%) <> BCurrLine$(Cwin%) THEN LogLine RTRIM$(BCurrLine$(Cwin%)), Cwin%
	END IF
	New% = NewBTopRow%
	IF New% < 0 THEN New% = 0 ELSE IF New% > BBottom%(Cwin%) - 1 THEN New% = BBottom%(Cwin%) - 1
	IF New% = BTopRow%(Cwin%) THEN Stat%(Cwin%) = Stat%(Cwin%) OR 1 ELSE Scrolled%(Cwin%) = -2
	NewBRow% = New% + Row%(Cwin%) - WTopRow(Cwin%)
	IF NewBRow% > BBottom%(Cwin%) - 1 THEN
		Row%(Cwin%) = Row%(Cwin%) - NewBRow% + BBottom%(Cwin%) - 1
		NewBRow% = BBottom%(Cwin%) - 1
	END IF
	IF NOT ScrollStep%(Cwin%) THEN ScrollWin%(Cwin%) = ScrollWin%(Cwin%) + New% - BTopRow%(Cwin%)
	BTopRow%(Cwin%) = New%
	IF NewBRow% <> BRow%(Cwin%) THEN
		IF BCurrSave$(Cwin%) <> BCurrLine$(Cwin%) THEN
			BLineWrite Cwin%, BRow%(Cwin%), BCurrLine$(Cwin%)
		END IF
		BRow%(Cwin%) = NewBRow%
		BCurrLine$(Cwin%) = BLineRead$(Cwin%, NewBRow%)
		BCurrSave$(Cwin%) = BCurrLine$(Cwin%)
	END IF
	WhoScrollUpdate% = Cwin%
END SUB

SUB WOutput STATIC
	'IF Testingg% THEN FOR x = 1 TO 1000: WPacket% = 1: NEXT
	NumChars% = 0
	DO
		Char$ = WGetKey$
		IF LEN(Char$) = 0 THEN EXIT DO
		Char% = ASC(Char$)
		WCursorControl
		IF LocalFunc% THEN EXIT SUB
		IF Char% > 31 THEN
			IF Locked%(Cwin%) = 0 THEN
				WhoScrollUpdate% = Cwin%
				LastScrollUpdate% = 0
				IF Col%(Cwin%) >= WWrap% THEN
					WWordWrap
				ELSE
					IF InsMode%(Cwin%) THEN WInsertString Char$ ELSE MID$(BCurrLine$(Cwin%), Col%(Cwin%)) = Char$
					Col%(Cwin%) = Col%(Cwin%) + 1
					Stat%(Cwin%) = Stat%(Cwin%) OR 2
					LineFlag%(Row%(Cwin%)) = 3
				END IF
			ELSE
				IF Char% = 32 THEN WHelp 0
			END IF
		END IF
		NumChars% = NumChars% + 1
	LOOP UNTIL NumChars% >= Packet%
 
	IF Cwin% = NextWin% THEN
		NoWait% = -1
		IF Remote% THEN
			FBuffInfo SyncPort%, InBuffSize%, InBuffChars%, OutBuffSize%, OutBuffChars%
			IF OutBuffChars% > FBuffMax% THEN NoWait% = 0
		END IF
	END IF
	IF NoWait% THEN
		IF IndStat% THEN WIndicators
		IF Scrolled%(Cwin%) = -2 THEN WStartScroll
		IF Stat%(Cwin%) AND 2 THEN
			IF Stat%(Cwin%) AND 1 THEN
				WUpdate
				IF CurFlicker% OR (Stat%(Cwin%) AND 2) = 0 THEN TWrite ALocate$(OldRow%, OldCol%, Row%(Cwin%), Col%(Cwin%))
				Stat%(Cwin%) = Stat%(Cwin%) AND 2
			ELSE
				WUpdate
			END IF
		ELSEIF Stat%(Cwin%) THEN
			IF OldRow% <> Row%(Cwin%) OR OldCol% <> Col%(Cwin%) THEN
				IF Redrawing% = 0 OR CurFlicker% <> 0 THEN TWrite ALocate$(OldRow%, OldCol%, Row%(Cwin%), Col%(Cwin%))
			END IF
			IF WhoScrollUpdate% = Cwin% THEN WhoScrollUpdate% = (Cwin% MOD NumWin%) + 1
			Stat%(Cwin%) = 0
		END IF
		IF Redrawing% THEN IF Cwin% = 1 THEN WURedraw
		NextWin% = (Cwin% MOD NumWin%) + 1
	END IF
END SUB

SUB WStartLine
	WhoScrollUpdate% = Cwin%
	LastScrollUpdate% = 0
	LineFlag%(Row%(Cwin%)) = 3
	Stat%(Cwin%) = Stat%(Cwin%) OR 2
END SUB

SUB WStartRedraw
	FOR RedrawWin% = 1 TO NumWin%
		Stat%(RedrawWin%) = 0
		Scrolled%(RedrawWin%) = 0
	NEXT RedrawWin%
	FOR Lines% = 1 TO ChatHt%
		LineFlag%(Lines%) = 1
		ScrollCol%(Lines%) = 0
		ScrLnStep%(Lines%) = 0
	NEXT Lines%
	IndStat% = 0
	WhoScrollUpdate% = 1
	WPacket% = MinPacket%
	TWrite AClear$(Term%)
	IF Term% = 4 THEN         'AVATAR/0+
		FOR Each% = 1 TO NumWin%
			TWrite ALocate$(OldRow%, OldCol%, WTopRow%(Each%), 1) + Aend$(Term%)
			TWrite AVTclearblock$ + CHR$(WColr%(Each%)) + CHR$(WHeight%(Each%) + 1) + CHR$(ChatWid%)
		NEXT Each%
		OldColor% = 0
	ELSEIF Term% >= 3 THEN    'AVATAR/0
		FOR Each% = 1 TO NumWin%
			IF WColr%(Each%) AND 127 THEN
				TWrite AColor$(WColr%(Each%))
				FOR Linez% = WTopRow%(Each%) TO WBotRow%(Each%)
					TWrite ALocate$(OldRow%, OldCol%, Linez%, 1) + Aend$(Term%)
				NEXT Linez%
			END IF
		NEXT Each%
	ELSE                      'ANSI
		FOR Each% = 1 TO NumWin%
			TWrite AColor$(WColr%(Each%)) + ALocate$(OldRow%, OldCol%, WTopRow%(Each%), 1) + ANScleartoend$
		NEXT Each%
		IF WColr%(NumWin%) AND 112 THEN
			TWrite AColor$(7) + ALocate$(OldRow%, OldCol%, WBotRow%(NumWin%) + 1, 1) + ANScleartoend$
		END IF
	END IF
	RedrawBar% = 1
	RedrawPos% = 1
	RdRow% = RDataRow%(1)
	RdCol% = RDataCol%(1)
	RdColor% = RDataColor%(1)
	Redrawing% = 1
END SUB

SUB WStartScroll
	WhoScrollUpdate% = Cwin%
	LastScrollUpdate% = 0
	Stat%(Cwin%) = 2
	Scrolled%(Cwin%) = -1
	IF ScrollWin%(Cwin%) THEN
		IF Term% = 2 OR Term% = 4 THEN
			IF ABS(ScrollWin%(Cwin%)) < WHeight%(Cwin%) THEN
				ScrTemp% = ScrollWin%(Cwin%)
				IF SGN(ScrTemp%) = 1 THEN
					FOR Lines% = WTopRow%(Cwin%) TO WBotRow%(Cwin%) - ScrTemp%
						Temp% = LineFlag%(Lines% + ScrTemp%)
						IF Temp% = 1 THEN
							LineFlag%(Lines%) = 2
							ScrLnStep%(Lines%) = 0
							ScrollCol%(Lines%) = 0
						ELSE
							LineFlag%(Lines%) = Temp%
							ScrLnStep%(Lines%) = ScrLnStep%(Lines% + ScrTemp%)
							ScrollCol%(Lines%) = ScrollCol%(Lines% + ScrTemp%)
						END IF
					NEXT Lines%
					FOR Finish% = Lines% TO WBotRow%(Cwin%)
						LineFlag%(Finish%) = 2
						ScrLnStep%(Finish%) = 0
						ScrollCol%(Finish%) = 0
					NEXT Finish%
				ELSE
					FOR Lines% = WBotRow%(Cwin%) TO WTopRow%(Cwin%) - ScrTemp% STEP -1
						Temp% = LineFlag%(Lines% + ScrTemp%)
						IF Temp% = 1 THEN
							LineFlag%(Lines%) = 2
							ScrLnStep%(Lines%) = 0
							ScrollCol%(Lines%) = 0
						ELSE
							LineFlag%(Lines%) = Temp%
							ScrLnStep%(Lines%) = ScrLnStep%(Lines% + ScrTemp%)
							ScrollCol%(Lines%) = ScrollCol%(Lines% + ScrTemp%)
						END IF
					NEXT Lines%
					FOR Finish% = WTopRow%(Cwin%) TO Lines%
						LineFlag%(Finish%) = -2
						ScrLnStep%(Finish%) = 0
						ScrollCol%(Finish%) = 0
					NEXT Finish%
				END IF
				EXIT SUB
			END IF
		END IF
	END IF
	FOR Lines% = WTopRow%(Cwin%) TO WBotRow%(Cwin%)
		LineFlag%(Lines%) = 2
		ScrLnStep%(Lines%) = 0
		ScrollCol%(Lines%) = 0
	NEXT Lines%
END SUB

SUB WUpdate STATIC
	'This is the IntelliUpdate core subroutine, version II.
	IF ScrollWin%(Cwin%) THEN
		IF Term% = 2 OR Term% = 4 THEN
			IF ABS(ScrollWin%(Cwin%)) <= WHeight%(Cwin%) THEN
				IF ScanBlock%(WTopRow%(Cwin%), WBotRow%(Cwin%), ScrWid%) THEN
					IF Term% = 2 THEN
						Temp$ = ANSscrollzone$(WTopRow%(Cwin%), WBotRow%(Cwin%)) + AColor$(WColr%(Cwin%))
						IF SGN(ScrollWin%(Cwin%)) = 1 THEN
							Temp$ = Temp$ + ALocate$(OldRow%, OldCol%, WBotRow%(Cwin%), 1) + STRING$(ScrollWin%(Cwin%), CHR$(10))
						ELSE
							Temp$ = Temp$ + ALocate$(OldRow%, OldCol%, WTopRow%(Cwin%), 1)
							FOR Addit% = 1 TO -ScrollWin%(Cwin%): Temp$ = Temp$ + ANSrevlf$: NEXT Addit%
						END IF
					ELSE
						IF SGN(ScrollWin%(Cwin%)) = 1 THEN
							Temp$ = AColor$(WColr%(Cwin%)) + AVTscrollup$ + CHR$(ScrollWin%(Cwin%))
						ELSE
							Temp$ = AColor$(WColr%(Cwin%)) + AVTscrolldn$ + CHR$(-ScrollWin%(Cwin%))
						END IF
						Temp$ = Temp$ + CHR$(WTopRow%(Cwin%)) + CHR$(1) + CHR$(WBotRow%(Cwin%)) + CHR$(ChatWid%)
					END IF
					TWrite Temp$
					WhoScrollUpdate% = Cwin%
					ScrollWin%(Cwin%) = 0
					EXIT SUB
				END IF
			END IF
		END IF
		ScrollWin%(Cwin%) = 0
	END IF
	IF WhoScrollUpdate% <> Cwin% THEN             'Whose turn is it to update?
		IF Stat%(WhoScrollUpdate%) THEN EXIT SUB ELSE WhoScrollUpdate% = Cwin%
	END IF
	DO
		Priority% = 0           'The below finds priority text to update.
		CurrLine% = 0
		FOR CheckLine% = WTopRow%(Cwin%) TO WBotRow%(Cwin%)
			LineF% = LineFlag%(CheckLine%)
			IF SGN(LineF%) = 1 THEN
				IF LineF% > ABS(Priority%) OR LineF% = -Priority% THEN
					Priority% = LineF%
					CurrLine% = CheckLine%
				END IF
			ELSEIF -LineF% >= ABS(Priority%) THEN
				Priority% = LineF%
				CurrLine% = CheckLine%
			END IF
		NEXT CheckLine%
		Priority% = ABS(Priority%)
		IF Priority% < 2 THEN Stat%(Cwin%) = 1: EXIT SUB
		IF WhoScrollUpdate% <> LastScrollUpdate% THEN
			WPacket% = Packet%
			LastScrollUpdate% = WhoScrollUpdate%
		ELSE
			IF CurrLine% >= OldRow% AND CurrLine% <= OldRow% + 1 THEN
				WPacket% = MinPacket%
			ELSE
				WPacket% = Packet%
			END IF
		END IF
		TextLine$ = ScanScr$(CurrLine%, ScrWid%)
		IF BBottom%(Cwin%) <= BTopRow%(Cwin%) + CurrLine% - WTopRow%(Cwin%) THEN
			CurrLine$ = ""
		ELSE
			Ref% = BTopRow%(Cwin%) + CurrLine% - WTopRow%(Cwin%)
			IF Ref% = BRow%(Cwin%) THEN CurrLine2$ = BCurrLine$(Cwin%) ELSE CurrLine2$ = BLineRead$(Cwin%, Ref%)
			CurrLine$ = RTRIM$(CurrLine2$)
		END IF
		IF ScrLnStep%(CurrLine%) THEN    'Does line need left/right scroll first?
			IF LEN(RTRIM$(TextLine$)) > ScrollCol%(CurrLine%) THEN
				IF Term% = 4 THEN
					IF ABS(ScrLnStep%(CurrLine%)) <= WPacket% THEN
						IF LEN(RTRIM$(MID$(CurrLine$, ScrollCol%(CurrLine%)))) THEN
							IF SGN(ScrLnStep%(CurrLine%)) = -1 THEN
								Temp$ = AColor$(WColr%(Cwin%)) + ALocate$(OldRow%, OldCol%, CurrLine%, ScrollCol%(CurrLine%))
								FOR Add% = 1 TO -ScrLnStep%(CurrLine%)
									Temp$ = Temp$ + AVTdel$
								NEXT Add%
							ELSE
								Positt% = ScrollCol%(CurrLine%) - ScrLnStep%(CurrLine%)
								IF Positt% <= 0 THEN Positt% = 1
								Temp$ = AColor$(WColr%(Cwin%)) + ALocate$(OldRow%, OldCol%, CurrLine%, Positt%)
								IF OldInsert% = 0 THEN Temp$ = Temp$ + AVTins$
								Temp$ = Temp$ + MID$(CurrLine$, Positt%, ScrLnStep%(CurrLine%))
							END IF
							TWrite Temp$
							WhoScrollUpdate% = Cwin%
							ScrLnStep%(CurrLine%) = 0
							EXIT SUB
						END IF
					END IF
				ELSEIF Term% = 2 THEN
					IF ABS(ScrLnStep%(CurrLine%)) < WPacket% THEN
						IF LEN(RTRIM$(MID$(CurrLine$, ScrollCol%(CurrLine%)))) THEN
							IF SGN(ScrLnStep%(CurrLine%)) = -1 THEN
								Temp$ = AColor$(WColr%(Cwin%)) + ALocate$(OldRow%, OldCol%, CurrLine%, ScrollCol%(CurrLine%)) + escbr$
								IF ScrLnStep%(CurrLine%) = -1 THEN Temp$ = Temp$ + "P" ELSE Temp$ = Temp$ + LTRIM$(STR$(-ScrLnStep%(CurrLine%))) + "P"
							ELSE
								Temp$ = AColor$(WColr%(Cwin%)) + ALocate$(OldRow%, OldCol%, CurrLine%, ScrollCol%(CurrLine%) - ScrLnStep%(CurrLine%)) + escbr$
								IF ScrLnStep%(CurrLine%) = 1 THEN Temp$ = Temp$ + "@" ELSE Temp$ = Temp$ + LTRIM$(STR$(ScrLnStep%(CurrLine%))) + "@"
							END IF
							TWrite Temp$
							TextLine$ = ScanScr$(CurrLine%, ScrWid%)
							WhoScrollUpdate% = Cwin%
						END IF
					END IF
				END IF
			END IF
			ScrLnStep%(CurrLine%) = 0
			ScrollCol%(CurrLine%) = 0
		END IF
		IF CurrLine$ = RTRIM$(TextLine$) THEN     'Does it need an update?
			LineFlag%(CurrLine%) = 0
		ELSE
			LenCurr% = LEN(CurrLine$)
			IF OldCol% > LenCurr% THEN
				IF LenCurr% = 0 AND Term% = 4 THEN     'Can it do a AVT Block clear?
					IF CurrLine% < WBotRow%(Cwin%) THEN
						FOR TestIt% = CurrLine% + 1 TO WBotRow%(Cwin%)
							Temp% = BTopRow%(Cwin%) + TestIt% - WTopRow%(Cwin%)
							IF BBottom%(Cwin%) <= Temp% THEN TestIt% = WBotRow%(Cwin%) + 1: EXIT FOR
							IF Temp% = BRow%(Cwin%) THEN
								IF LEN(RTRIM$(BCurrLine$(Cwin%))) THEN EXIT FOR
							ELSE
								IF LEN(RTRIM$(BLineRead$(Cwin%, Temp%))) THEN EXIT FOR
							END IF
						NEXT TestIt%
						IF CurrLine% < TestIt% - 1 THEN
							IF ScanBlock%(CurrLine%, TestIt% - 1, ScrWid%) > 2 THEN
								Temp$ = ALocate$(OldRow%, OldCol%, CurrLine%, 1) + AVTclearblock$ + CHR$(WColr%(Cwin%)) + CHR$(TestIt% - CurrLine%) + CHR$(ChatWid%)
								TWrite Temp$
								OldColor% = WColr%(Cwin%)
								FOR ClearFlag% = CurrLine% TO TestIt% - 1
									LineFlag%(ClearFlag%) = 0
								NEXT ClearFlag%
								EXIT SUB
							END IF
						END IF
					END IF
				END IF
				IF OldRow% = CurrLine% THEN
					IF Compare%(CurrLine2$, TextLine$, 1) >= OldCol% THEN EXIT DO
				END IF
			END IF
			NextDiff% = Compare%(CurrLine$, TextLine$, 1)
			Temp$ = AColor$(WColr%(Cwin%))
			IF OldRow% = CurrLine% THEN
				IF NextDiff% <> OldCol% THEN
					Temp% = NextDiff% - OldCol%
					IF Temp% >= 1 AND Temp% <= 4 THEN
						Temp$ = Temp$ + MID$(CurrLine$, OldCol%, Temp%)
						OldCol% = OldCol% + Temp%
					ELSEIF Temp% = -1 THEN
						Temp$ = Temp$ + CHR$(8)
						OldCol% = OldCol% + Temp%
					ELSE
						Temp$ = Temp$ + ALocate$(OldRow%, OldCol%, CurrLine%, NextDiff%)
					END IF
				END IF
			ELSE
				Temp$ = Temp$ + ALocate$(OldRow%, OldCol%, CurrLine%, NextDiff%)
			END IF
			IF NextDiff% <= LenCurr% THEN
				NumChars% = 0
				'The below loops until no more characters. (There are some EXIT DO's)
				DO UNTIL NextDiff% > LenCurr%
					NextSame% = Contrast%(CurrLine$, TextLine$, NextDiff%) 'next loc equal
					IF Term% >= 3 THEN       'AVT/0/0+ with ^Y compression
						DO
							Repeat% = ScanChar%(CurrLine$, NextDiff%)
							IF Repeat% < 4 THEN
								Temp$ = Temp$ + MID$(CurrLine$, NextDiff%, Repeat%)
								NumChars% = NumChars% + Repeat%
							ELSE
								Temp$ = Temp$ + AVTrepeat$ + MID$(CurrLine$, NextDiff%, 1) + CHR$(Repeat%)
								NumChars% = NumChars% + 3
							END IF
							'OldCol% = OldCol% + Repeat%
							NextDiff% = NextDiff% + Repeat%
						LOOP UNTIL NumChars% >= WPacket% OR NextDiff% >= NextSame%
						IF NextDiff% > NextSame% THEN NextSame% = NextDiff%
					ELSE                     'ANSI or AVT without ^Y compression
						Leng% = NextSame% - NextDiff%  'How long does equal chars run on?
						IF NumChars% + Leng% >= WPacket% THEN     'Calculate how many chars.
							Poss% = WPacket% - NumChars%
							IF Poss% > 0 THEN Leng% = Poss% ELSE IF Leng% > 2 THEN Leng% = 2
						END IF
						Temp$ = Temp$ + MID$(CurrLine$, NextDiff%, Leng%)
						NumChars% = NumChars% + Leng%          'Add to counter
					END IF
					IF NumChars% >= (WPacket% - 5) THEN EXIT DO
					NextDiff% = Compare%(CurrLine$, TextLine$, NextSame%)
					IF LenCurr% < NextDiff% THEN EXIT DO
					Leng% = NextDiff% - NextSame%          'How long does it run on?
					IF Leng% < 5 THEN                      'Characters or cursor locate?
						New$ = MID$(CurrLine$, NextSame%, Leng%)
					ELSE
						New$ = ALocate$(CurrLine%, NextSame%, CurrLine%, NextSame% + Leng%)
					END IF
					IF NumChars% + LEN(New$) >= WPacket% THEN EXIT DO
					Temp$ = Temp$ + New$               'Add to Temp$ variable
					NumChars% = NumChars% + LEN(New$)
				LOOP
			END IF
			TWrite Temp$
			IF OldCol% > LenCurr% THEN EXIT DO ELSE EXIT SUB
		END IF   '(IF NextDiff% THEN)
	LOOP
	LenText% = LEN(RTRIM$(TextLine$))
	IF LenText% > LenCurr% THEN
		Temp$ = AColor$(WColr%(Cwin%))
		IF LenText% - LenCurr% = 1 THEN
			Temp$ = Temp$ + " "
		ELSE
			Temp$ = Temp$ + Aend$(Term%)
		END IF
		TWrite Temp$
	END IF
	IF LenCurr% <> 0 AND LineFlag%(CurrLine%) < 3 THEN WhoScrollUpdate% = (Cwin% MOD NumWin%) + 1
	LineFlag%(CurrLine%) = 0
	WPacket% = MinPacket%
END SUB

SUB WURedraw STATIC
	FOR CTest% = 1 TO NumWin%
		IF Stat%(CTest%) = 2 THEN StillUpd% = CTest% ELSE Stat%(CTest%) = Stat%(CTest%) AND 2
	NEXT CTest%
	IF StillUpd% = 0 THEN
		WPacket% = MinPacket%
	ELSEIF StillUpd% < 0 THEN
		StillUpd% = 0
		WPacket% = Packet%
	ELSEIF StillUpd% > 0 THEN
		StillUpd% = -1
		EXIT SUB
	END IF

	SELECT CASE Redrawing%
	CASE 1         'first executed
		Temp$ = ""
		TWrite AColor$(RdColor%) + ALocate$(OldRow%, OldCol%, RdRow%, RdCol%)
		IF Term% >= 3 THEN        'AVT/0/0+
			check$ = RedrawData$(RedrawBar%)
			LengLine% = LEN(check$)
			DO
				Repeat% = ScanChar%(check$, RedrawPos%)
				IF Repeat% < 4 THEN
					Temp$ = Temp$ + MID$(check$, RedrawPos%, Repeat%)
				ELSE
					Temp$ = Temp$ + AVTrepeat$ + MID$(check$, RedrawPos%, 1) + CHR$(Repeat%)
				END IF
				RedrawPos% = RedrawPos% + Repeat%
			LOOP UNTIL LEN(Temp$) >= WPacket% OR RedrawPos% > LengLine%
			TWrite Temp$
		ELSE                      'ANSI or AVT without ^Y compression
			TWrite MID$(RedrawData$(RedrawBar%), RedrawPos%, WPacket%)
			RedrawPos% = RedrawPos% + WPacket%
			LengLine% = LEN(RedrawData$(RedrawBar%))
		END IF
		IF RedrawPos% > LengLine% THEN
			IF RDataClrEol%(RedrawBar%) THEN TWrite Aend$(Term%)
			IF RedrawBar% = TitleBarRow% THEN WClock 0
			RedrawBar% = RedrawBar% + 1
			IF RedrawBar% > RedrawTotalLines% THEN Redrawing% = 2: EXIT SUB
			RedrawPos% = 1
			RdRow% = RDataRow%(RedrawBar%)
			RdCol% = RDataCol%(RedrawBar%)
			RdColor% = RDataColor%(RedrawBar%)
		ELSE
			RdRow% = OldRow%
			RdCol% = OldCol%
		END IF
	CASE 2        'Second last executed
		IndStat% = -1
		IndKeyboardFlag% = 0
		FOR Each% = 1 TO NumWin%
			IndInsertFlag%(Each%) = 0
		NEXT Each%
		DO
			WIndicators
		LOOP WHILE IndStat%
		TWrite AColor$(WTermCol%) + ALocate$(OldRow%, OldCol%, TitleBarRow%, 66) + ATermName$(Term%)
		Redrawing% = 3
	CASE 3        'Last executed
		Cursor% = 0
		FOR Each% = 1 TO NumWin%
			IF Scrolled%(Each%) = 0 THEN
				Stat%(Each%) = 2
				Scrolled%(Each%) = -1
				FOR Lines% = WTopRow%(Each%) TO WBotRow%(Each%)
					IF LineFlag%(Lines%) = 1 THEN LineFlag%(Lines%) = 2
				NEXT Lines%
			ELSEIF Stat%(Each%) AND 1 THEN
				Cursor% = -1
			END IF
		NEXT Each%
		IF NOT Cursor% THEN Stat%(NumWin%) = Stat%(NumWin%) OR 1
		Redrawing% = 0
	END SELECT
	
END SUB

SUB WWordWrap
	IF Char$ = " " THEN WEnter: EXIT SUB
	Temp$ = BCurrLine$(Cwin%)
	Length% = 0
	TempCol% = Col%(Cwin%)
	DO WHILE MID$(Temp$, TempCol% - 1, 1) <> " " AND Length% < MaxWWrapLen% AND TempCol% > 2
		TempCol% = TempCol% - 1
		Length% = Length% + 1
	LOOP
	IF Length% >= MaxWWrapLen% OR TempCol% <= 2 THEN
		Temp$ = Char$
	ELSE
		Temp$ = RTRIM$(MID$(BCurrLine$(Cwin%), TempCol%)) + Char$
		MID$(BCurrLine$(Cwin%), TempCol% - 1) = SPACE$(Length% + 1)
	END IF
	LineFlag%(Row%(Cwin%)) = 3
	WEnter
	LineFlag%(Row%(Cwin%)) = 3
	Stat%(Cwin%) = Stat%(Cwin%) OR 2
	IF InsMode%(Cwin%) THEN WInsertString Temp$ ELSE MID$(BCurrLine$(Cwin%), 1) = Temp$
	Col%(Cwin%) = LEN(Temp$) + 1
END SUB

