/**********************************************************************
  Copyright (c) 2000-2002, Michael Dillon
  All rights reserved.

  Redistribution and use in source and binary forms, with or without 
  modification, are permitted provided that the following conditions 
  are met:

       Redistributions of source code must retain the above copyright 
       notice, this list of conditions and the following disclaimer. 

       Redistributions in binary form must reproduce the above 
       copyright notice, this list of conditions and the following 
       disclaimer in the documentation and/or other materials provided 
       with the distribution. 

       Neither the name of Crystalline Realms, Midnight's Hour BBS,
       Elysium Software nor the names of their contributors may be 
       used to endorse or promote products derived from this software 
       without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
  STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
  OF THE POSSIBILITY OF SUCH DAMAGE.
 *********************************************************************/
/*********************************************************************
 ticlog.cpp - Logging functions for TinyTIC
 *********************************************************************/
#include "tinytic.h"
#include "ticlog.h"

const char EFLAGS[] = "!?";

int LogError = 0;
string szLogFile;

bool PutLog(const char *str, int code, int silence)
{
        ofstream        fLog;
        time_t          CurTime;
        string          Buffer;
        bool            _PutLogReturn = true;
       
        if (LogError != 0)
        {
                // Apparent previous error, abort
                return (false);
        }

        if (str == NULL)
        {
                // No string specified, leave.
                _PutLogReturn = false;
        }

        if (code < 0 || code > 1)
        {
                // Invalid code
                _PutLogReturn = false;
        }

        if (_PutLogReturn == true)
        {

                // Display the log error
                if (silence == 0)
                {
                        cout << str << endl;
                }

                if (VerifyFileUsable(szLogFile.c_str()) == false)
                {
                        szLogFile = "tinytic.log";
                }

                if (szLogFile == "")
                {
                        szLogFile = "tinytic.log";
                }


                // If there was a log file specified on the command line
                // use it instead.
                if (szCmdLogFile != "")
                {
                        fLog.open(szCmdLogFile.c_str(), ios::app);
                }
                else
                {
                        fLog.open(szLogFile.c_str(), ios::app);
                }

                if (!fLog)
                {
                        // Unable to open the logfile
                        LogError = 1;
                        cerr << "Unable to open the log file \'"
                                << Buffer.c_str()
                                << "\'... No more log entries will be attempted!"
                                << endl;

                        _PutLogReturn = false;
                }
                else
                {
                        time(&CurTime);

                        // Outputs in this format
                        // [<time>] <flag> <error>
                        Buffer = ctime(&CurTime);
                        Buffer.erase(Buffer.size() - 1);
                        fLog << "[" << Buffer.c_str() << "] " << EFLAGS[code] << " " << str << endl;

                        fLog.close();
                }
        }

        return (_PutLogReturn);
}    
