/**********************************************************************
  Copyright (c) 2000-2002, Michael Dillon
  All rights reserved.

  Redistribution and use in source and binary forms, with or without 
  modification, are permitted provided that the following conditions 
  are met:

       Redistributions of source code must retain the above copyright 
       notice, this list of conditions and the following disclaimer. 

       Redistributions in binary form must reproduce the above 
       copyright notice, this list of conditions and the following 
       disclaimer in the documentation and/or other materials provided 
       with the distribution. 

       Neither the name of Crystalline Realms, Midnight's Hour BBS,
       Elysium Software nor the names of their contributors may be 
       used to endorse or promote products derived from this software 
       without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
  STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
  OF THE POSSIBILITY OF SUCH DAMAGE.
 *********************************************************************/
/*********************************************************************
 tinytic.h - Master header for TinyTIC.
 *********************************************************************/#if !defined(MAIN_HEADER__H)
#define MAIN_HEADER__H 1

#include "headers.h"

#ifdef __GNUC__
# ifndef POSIX
#  define POSIX
# endif /* POSIX */
#endif /* __GNUC__ */

#if defined(__GNUC__) && defined(unix)
# ifndef BSD
#  define BSD
# endif /* BSD */
#endif /* __GNUC__ && unix */

/* System Types */
#undef SYS_TYPE_WINDOWS
#undef SYS_TYPE_DOS
#undef SYS_TYPE_OS2
#undef SYS_TYPE_UNIX
#undef SYS_TYPE_LINUX
#undef SYS_TYPE_OTHER

#if defined(_WIN32) || defined(_WINNT)
# define COMPTYPE "Windows"
# define SYS_TYPE_WINDOWS
#elif defined(DJGPP) || defined(__MSDOS__) || defined(__DOS__) || defined(MSDOS)
# ifdef __386__
#  define COMPTYPE "DOS32"
# else
#  define COMPTYPE "DOS"
# endif /* __386__ */
# define SYS_TYPE_DOS
#elif defined(linux)
# define COMPTYPE "Linux"
# define SYS_TYPE_LINUX
#elif defined(unix) || defined(BSD)
# define COMPTYPE "UNIX"
# define SYS_TYPE_UNIX
#elif defined(__OS2__)
# define COMPTYPE "OS/2"
# define SYS_TYPE_OS2
#else
# define COMPTYPE "Unknown"
# define SYS_TYPE_OTHER
#endif

#define VERSION      "0.0.5.3-r1"
#define PROGNAME     "TinyTic"
#define VERSION_STR  VERSION "-" COMPTYPE
#define AUTHOR       "Michael Dillon"
#define COPYR        "Copyright (C) 2000-2003 "
#define AFFIL        "This program was produced in affiliation with Elysium Software."

extern  string  szHomeDir;
extern  string  szCmdConfigFile;
extern  string  szCmdDataFile;
extern  string  szCmdLogFile;

// Usable outside the primary file
bool  VerifyFileUsable(const char *src, int io = 0);

#if defined(POSIX)
# define stricmp strcasecmp
#endif

#if defined(__GNUC__) || defined(POSIX)
# include <unistd.h>
#endif /* __GNUC__ || POSIX */

/* TinyTIC subsystem Types */
#undef __TINYTIC_WINDOWS
#undef __TINYTIC_POSIX
#undef __TINYTIC_OS2

#if defined(SYS_TYPE_WINDOWS)
# define __TINYTIC_WINDOWS
#elif defined(SYS_TYPE_UNIX) || defined(SYS_TYPE_LINUX) /* !SYS_TYPE_WINDOWS */
# define __TINYTIC_POSIX
#elif defined(SYS_TYPE_OS2) || defined(SYS_TYPE_DOS) /* !SYS_TYPE_UNIX && !SYS_TYPE_LINUX && !SYS_TYPE_WINDOWS */
# define __TINYTIC_OS2
#else /* Unknown Type */
# error "SYS_TYPE_* not defined.  Please Correct this."
#endif /* SYS_TYPE_WINDOWS */

#define UNUSED_PARAM(x) ((void)(x))

#endif
///
