(****************************************************************************

                        InterStellar Annihilation (ISA)
                                IGM UserIO Unit
                      Copyright(c) 1996-2002 Andy Stewart

Version  : 0.994
Compiler : Delphi 6 & 7 / Turbo Pascal 7.0
Updated  : 11.12.02

 ****************************************************************************)

Unit aISA;

INTERFACE

uses
  Crt;

type

ISAUserInfo = Record
  Name                   : string[35];  { User's Real Name }
  Alias                  : string[35];  { User's Empire Name }
  Pop                    : longint;     { User's Population }
  FoodStore              : longint;     { User's Food }
  Recons                 : longint;     { User's Recon Units }
  KnifeTroops            : longint;     { User's Knife Troops }
  GunTroops              : longint;     { User's Gun Troops }
  LaserTroops            : longint;     { User's Gun Troops }
  Fighters               : longint;     { User's Fighters }
  Bombers                : longint;     { User's Bombers }
  AntiGun                : longint;     { User's Anit-Aircraft Guns }
  AntiLaser              : longint;     { User's Anit-Aircraft Lasers }
  Ammo                   : longint;     { User's Ammo }
  Urban                  : longint;     { User's Urban Planets }
  Food                   : longint;     { User's Food Planets }
  Industrial             : longint;     { User's Industrial Planets }
  Camps                  : longint;     { User's Military Planets }
  Tourist                : longint;     { User's Tourist Planets }
  Mines                  : longint;     { User's Mining Planets }
  Peace                  : word;        { User's Peace % }
  Tax                    : word;        { User's Tax % }
  Draft                  : word;        { User's Draft % }
  ArmyFight              : word;        { User's Army Effectiveness % }
  Money                  : longint;     { User's Money on hand }
  Score                  : longint;     { User's Score }
  NewPlanets             : longint;     { User's New Planets Available }
  InBank                 : longint;     { User's Money in Bank }
  UGroundPass            : string[35];  { User's UnderGround Password }
  Plays                  : word;        { User's Plays Today }
  LocalAttacksSentToday  : word;        { User's LOCALAttacks Sent Today }
  RemoteAttacksSentToday : word;        { User's LOCALAttacks Sent Today }
  LocalReconsSentToday   : word;        { User's Recons Sent Today }
  RemoteReconsSentToday  : word;        { User's Recons Sent Today }
  MoneyTransfersSentToday: word;        { User's Money xfers sent Today }
end;

var
  ISAUser   : ISAUserInfo;        { Call ISAUser.Field - ie: ISAUser.Money }
  EmpireReal,                                            { User's BBS Name }
  EmpireName: array [1..20] of string[35];                   { Empire Name }
  EmpirePro : array [1..20] of boolean;         { Empire Protection Status }
  MaxTransferSize : Longint;   { Sysop defined maximum money transfer size }

Procedure NewPause;         { Pause routine used in ISA }
Procedure DrawStars;        { DrawStars routine used in ISA }
Procedure ReadUserOut;      { Reads USER????.OUT }
Procedure DisplayUserOut;   { Displays variables read from USER????.OUT }
Procedure WriteUserIn;      { Writes USER????.IN }
Procedure ReadEmpireDat;    { Reads EMPIRE.DAT into arrays }
Procedure DisplayEmpires;   { Displays Empires in EMPIRES.DAT }

IMPLEMENTATION

uses
  Angel;

Procedure NewPause;
{ Just a pause that I use in ISA }

var
 whx,
 why,
 fore,
 back,
 rndm: byte;

begin                   {  Pause  }
 fore := aGetFore;
 back := aGetBack;
 whx  := wherex;
 why  := wherey;
 rndm := random(6) + 1;
 AWriteIcc(charstr(#32,34) + '^\0'+cstr(rndm) + '^\'+cstr(rndm) +
                             'F Pause ^\0' + cstr(rndm) + '^\07');
 AReadkey;
 aSetcolor(1,0);
 AGotoxy(whx, why);
 aWrite(charstr(#32,49));
 aSetcolor(fore,back);
end;


procedure DrawStars;
{ Sets background to black, clears screen and randomly draws stars }
var
  rndm: byte;

begin
 ASetcolor(8,0);
 AClr;
 for rndm := 1 to 25 do
   begin
     AGotoxy(random(79) + 1,random(23) + 1);
     AWriteIcc('.');
   end;
 AGotoxy(random(79) + 1,random(23)+1);
 AWrite(#248);
 ASetcolor(7,0);
 for rndm := rndm to 25 do
   begin
     AGotoxy(random(79) + 1,random(23) + 1);
     AWrite(#249);
   end;
 AGotoxy(random(79) + 1,random(23) + 1);
 AWrite(#248);
 ASetcolor(15,0);
 for rndm := 1 to 25 do
   begin AGotoxy(random(79) + 1,random(23) + 1);
   AWrite(#250);
 end;
 AGotoxy(random(79) + 1,random(23) + 1);
 AWrite(#248);
 AGotoxy(1,1);
end; { DrawStars }


procedure ReadUserOut;
{ 06.07.01 - Reads DATA\USER????.OUT }

var
  UserOutFile : Text;
  UserOutStr,
  TempStr,
  TempBaud    : String;

begin
  if not FileExist(ParamStr(1) + ParamStr(2) + '.OUT') then
    begin
      AWriteICCln('^\LF^\LF^\LF^\0F! ^\0EError ^\0F!  ^\0B' + ParamStr(1) + ParamStr(2)  + '.OUT ^\03not found^\0B!');
      AWriteICCln('^\0F ^\03Please inform your SysOp of the problem^\0B!^\LF^\LF');
      NewPause;
      Exit;
    end;

  Assign(UserOutFile, ParamStr(1) + ParamStr(2) + '.OUT');
  Reset(UserOutFile);

  readln(UserOutFile,UserOutStr);
  BBS.Node := valuew(UserOutStr);

  readln(UserOutFile,BBS.SystemName);
  readln(UserOutFile,BBS.Sysop);
  readln(UserOutFile,BBS.Doorpath);

  if BBS.DoorPath[length(BBS.DoorPath)] <> '\' then
     BBS.DoorPath := BBS.DoorPath + '\';

  readln(UserOutFile,UserOutStr);
  if not AI.Local then BBS.Comport := valuew(UserOutStr);

  readln(UserOutFile,UserOutStr);
  if not AI.Local then BBS.BaudRate := value(UserOutStr);

  readln(UserOutFile,UserOutStr);
  if not AI.Local then BBS.LockedBaud := value(UserOutStr);

  readln(UserOutFile,userOutStr);
  if not AI.Local then if UserOutStr = 'Yes' then AI.Telnet := True
    else AI.Telnet := False;

  readln(UserOutFile,UserOutStr);
  if not AI.Local then BBS.TimeLeft := valuew(UserOutStr);

  readln(UserOutFile,ISAUser.Name);

  user.uName := ISAUser.Name;
  readln(UserOutFile,ISAUser.Alias);
  readln(UserOutFile,ISAUser.Pop);
  readln(UserOutFile,ISAUser.FoodStore);
  readln(UserOutFile,ISAUser.Recons);
  readln(UserOutFile,ISAUser.KnifeTroops);
  readln(UserOutFile,ISAUser.GunTroops);
  readln(UserOutFile,ISAUser.LaserTroops);
  readln(UserOutFile,ISAUser.Fighters);
  readln(UserOutFile,ISAUser.Bombers);
  readln(UserOutFile,ISAUser.AntiGun);
  readln(UserOutFile,ISAUser.AntiLaser);
  readln(UserOutFile,ISAUser.Ammo);
  readln(UserOutFile,ISAUser.Urban);
  readln(UserOutFile,ISAUser.Food);
  readln(UserOutFile,ISAUser.Industrial);
  readln(UserOutFile,ISAUser.Camps);
  readln(UserOutFile,ISAUser.Tourist);
  readln(UserOutFile,ISAUser.Mines);
  readln(UserOutFile,ISAUser.Peace);
  readln(UserOutFile,ISAUser.Tax);
  readln(UserOutFile,ISAUser.Draft);
  readln(UserOutFile,ISAUser.ArmyFight);
  readln(UserOutFile,ISAUser.Money);
  readln(UserOutFile,ISAUser.Score);
  readln(UserOutFile,ISAUser.Newplanets);
  readln(UserOutFile,ISAUser.InBank);
  readln(UserOutFile,ISAUser.UGroundPass);
  readln(UserOutFile,ISAUser.Plays);
  readln(UserOutFile,ISAUser.LocalAttacksSentToday);
  readln(UserOutFile,ISAUser.RemoteAttacksSentToday);
  readln(UserOutFile,ISAUser.LocalReconsSentToday);
  readln(UserOutFile,ISAUser.RemoteReconsSentToday);
  readln(UserOutFile,ISAUser.MoneyTransfersSentToday);
  readln(UserOutFile,MaxTransferSize);
  close(UserOutFile);
end; { ReadUserOut }

procedure DisplayUserOut;
{ 11.11.01 - Displays variable read from DATA\USER????.OUT }

begin
  aClr;

  aWriteln('BBS Node : ' + cstr(BBS.Node));
  aWriteln('BBS System Name : ' + BBS.SystemName);
  aWriteln('BBS Sysop Name : ' + BBS.Sysop);
  aWriteln('BBS Door Path : ' + BBS.Doorpath);
  aWriteln('BBS Comport : ' + cstr(BBS.Comport));
  aWriteln('BBS Baud Rate : ' + cstr(BBS.BaudRate));
  aWriteln('BBS Locked Baud Rate : ' + cstr(BBS.LockedBaud));
  aWrite('Telnet Session : ');
  if AI.Telnet then aWriteln('Yes') else aWriteln('No');
  aWriteln('BBS Time Left : ' + cstr(BBS.TimeLeft));
  aWriteln('User Name : ' + ISAUser.Name);
  aWriteln('Empire Name : ' + ISAUser.Alias);
  aWriteln('Population : ' + addcommas(cstrr(ISAUser.Pop,10)));
  aWriteln('Food Storage : ' + addcommas(cstrr(ISAUser.FoodStore,10)));
  aWriteln('Recon Units : ' + addcommas(cstrr(ISAUser.Recons,10)));
  aWriteln('Knife Troops : ' + addcommas(cstrr(ISAUser.KnifeTroops,10)));
  aWriteln('Gun Troops : ' + addcommas(cstrr(ISAUser.GunTroops,10)));
  aWriteln('Laser Troops : ' + addcommas(cstrr(ISAUser.LaserTroops,10)));
  aWriteln('Fighters : ' + addcommas(cstrr(ISAUser.Fighters,10)));
  aWriteln('Bombers : ' + addcommas(cstrr(ISAUser.Bombers,10)));
  aWriteln('Anti-Aircraft Guns : ' + addcommas(cstrr(ISAUser.AntiGun,10)));
  aWriteln('Anti-Aircraft Lasers : ' + addcommas(cstrr(ISAUser.AntiLaser,10)));
  aWriteln('Ammo : ' + addcommas(cstrr(ISAUser.Ammo,10)));
  aWriteln('Urban Planets : ' + addcommas(cstrr(ISAUser.Urban,10)));
  aWriteln('Food Planets : ' + addcommas(cstrr(ISAUser.Food,10)));
  aWriteln('Industrial Planets : ' + addcommas(cstrr(ISAUser.Industrial,10)));
  aWriteln('Military Planets : ' + addcommas(cstrr(ISAUser.Camps,10)));
  aWriteln('Tourist Planets : ' + addcommas(cstrr(ISAUser.Tourist,10)));
  aWriteln('Mining Planets : ' + addcommas(cstrr(ISAUser.Mines,10)));
  aWriteln('Peace Rating : ' + cstr(ISAUser.Peace) + ' %');
  aWriteln('Taxes : ' + cstr(ISAUser.Tax) + ' %');
  aWriteln('Draft : ' + cstr(ISAUser.Draft) + ' %');
  aWriteln('Army Effectiveness : ' + cstr(ISAUser.ArmyFight) + ' %');
  aWriteln('Money : $ ' + addcommas(cstrr(ISAUser.Money,10)));
  aWriteln('Score : ' + addcommas(cstrr(ISAUser.Score,10)));
  aWriteln('New Planets Available : ' + addcommas(cstrr(ISAUser.Newplanets,10)));
  aWriteln('Money in Bank : ' + addcommas(cstrr(ISAUser.InBank,10)));
  aWriteln('Underground Password : ' + ISAUser.UGroundPass);
  aWriteln('Plays : ' + addcommas(cstrr(ISAUser.Plays,10)));
  aWriteln('Local Attacks Sent Today : ' + addcommas(cstr(ISAUser.LocalAttacksSentToday)));
  aWriteln('Remote Attacks Sent Today : ' + addcommas(cstr(ISAUser.RemoteAttacksSentToday)));
  aWriteln('Local Recons Sent Today : ' + addcommas(cstr(ISAUser.LocalReconsSentToday)));
  aWriteln('Remote Recons Sent Today : ' + addcommas(cstr(ISAUser.RemoteReconsSentToday)));
  aWriteln('Money Transfers Sent Today : ' + addcommas(cstr(ISAUser.MoneyTransfersSentToday)));
  aWriteln('Maximum Money Transfer Size : ' + addcommas(cstrr(MaxTransferSize,10)));
  NewPause;
end; { DisplayUserOut }


procedure WriteUserIn;
{ 06.07.01 - Writes USER????.IN
  06.10.01 - USER???.IN should be created in the IGM's home directory.
             This is where ISA expects to find it.
}
var
  UserInFile : text;

begin
  assign(UserInFile, ParamStr(1) + ParamStr(2) + '.IN');
  rewrite(UserInFile);
  writeln(UserInFile,BBS.TimeLeft);
  writeln(UserInFile,ISAUser.Name);
  writeln(UserInFile,ISAUser.Alias);
  writeln(UserInFile,ISAUser.Pop);
  writeln(UserInFile,ISAUser.FoodStore);
  writeln(UserInFile,ISAUser.Recons);
  writeln(UserInFile,ISAUser.KnifeTroops);
  writeln(UserInFile,ISAUser.GunTroops);
  writeln(UserInFile,ISAUser.LaserTroops);
  writeln(UserInFile,ISAUser.Fighters);
  writeln(UserInFile,ISAUser.Bombers);
  writeln(UserInFile,ISAUser.AntiGun);
  writeln(UserInFile,ISAUser.AntiLaser);
  writeln(UserInFile,ISAUser.Ammo);
  writeln(UserInFile,ISAUser.Urban);
  writeln(UserInFile,ISAUser.Food);
  writeln(UserInFile,ISAUser.Industrial);
  writeln(UserInFile,ISAUser.Camps);
  writeln(UserInFile,ISAUser.Tourist);
  writeln(UserInFile,ISAUser.Mines);
  writeln(UserInFile,ISAUser.Peace);
  writeln(UserInFile,ISAUser.Tax);
  writeln(UserInFile,ISAUser.Draft);
  writeln(UserInFile,ISAUser.ArmyFight);
  writeln(UserInFile,ISAUser.Money);
  writeln(UserInFile,ISAUser.Score);
  writeln(UserInFile,ISAUser.NewPlanets);
  writeln(UserInFile,ISAUser.InBank);
  writeln(UserInFile,ISAUser.UGroundPass);
  writeln(UserInFile,ISAUser.Plays);
  writeln(UserInFile,ISAUser.LocalAttacksSentToday);
  writeln(UserInFile,ISAUser.RemoteAttacksSentToday);
  writeln(UserInFile,ISAUser.LocalReconsSentToday);
  writeln(UserInFile,ISAUser.RemoteReconsSentToday);
  writeln(UserInFile,ISAUser.MoneyTransfersSentToday);
  close(UserInFile);
end; { WriteUserIn }

Procedure ReadEmpireDat;
{ Reads EMPIRE.DAT into arrays }
var
  EmpDat : text;
  EmpNum : byte;
  TempStr: string;

begin
  if not FileExist(ParamStr(1) + 'EMPIRES.DAT') then exit;
  assign(EmpDat,ParamStr(1) + 'EMPIRES.DAT');
  reset(EmpDat);
  for EmpNum := 1 to 4 do readln(EmpDat,TempStr);
  EmpNum := 0;
  while not eof(EmpDat) do
    begin
      inc(EmpNum);
      readln(EmpDat,TempStr);
      if TempStr[1] <> ',' then
        begin
          EmpireReal[EmpNum] := Copy(TempStr, 1, Pos(',', TempStr) - 1);
          Delete(TempStr, 1, Pos(',', TempStr));
          EmpireName[EmpNum] := Copy(TempStr, 1, Pos(',', TempStr) - 1);
          Delete(TempStr, 1, Pos(',', TempStr));
          if UpStr(TempStr) = 'YES' then EmpirePro[EmpNum] := True
            else EmpirePro[EmpNum] := False;
        end;
    end;
  close(EmpDat);
end; { ReadEmpireDat }

Procedure DisplayEmpires;
var
  EmpNum,
  Loop : byte;

begin
  DrawStars;
  if EmpireReal[1] = '' then
    begin
      aWriteICCln('^\LF^\0E! ^\03Unable to display empires^\0B!^\LF');
      NewPause;
      exit;
    end;
  EmpNum := 0;
  aWriteICCln('^\01' + charstr('',65));
  For Loop := 1 to 20 do
    if EmpireReal[Loop] <> '' then
        begin
          inc(EmpNum);
          aWriteICC('^\01 (^\09' + chr(64 + EmpNum) + '^\01) ^\0F- ^\03' +
                     EmpireName[Loop]);
          if EmpirePro[Loop] then aWriteICCln('^\0B [^\09 Under Protection^\0B ]')
            else newln;
        end;
  aWriteICCln('^\01' + charstr('',65));
  newpause;
end;

END. { aISA.PAS }