/* byteord.c (emx+gcc) */

#include <stdio.h>
#include <sys/types.h>
#include <netinet/in.h>

static int rc;

static void fail (const char *fun)
{
  fprintf (stderr, "%s() failed\n", fun);
  rc = 1;
}

int main (void)
{
  rc = 0;
  if (htons (0x1234) != 0x3412) fail ("htons");
  if (ntohs (0x1234) != 0x3412) fail ("ntohs");
  if (htonl (0x12345678) != 0x78563412) fail ("htonl");
  if (ntohl (0x12345678) != 0x78563412) fail ("ntohl");
  return rc;
}
