/* Threads compatibily routines for libgcc2.  */
/* Compile this one with gcc.  */
/* Copyright (C) 1997 Free Software Foundation, Inc.

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

/* As a special exception, if you link this library with other files,
   some of which are compiled with GCC, to produce an executable,
   this library does not by itself cause the resulting executable
   to be covered by the GNU General Public License.
   This exception does not however invalidate any other reasons why
   the executable file might be covered by the GNU General Public License.  */

#ifndef __gthr_os2_h
#define __gthr_os2_h

/* The __MT__ symbol should be defined for multiple threads (-Zmt) */
#ifdef __MT__

#define __GTHREADS 1

/* OS/2 threads specific definitions */

#include <sys/builtin.h>
#include <sys/fmutex.h>
#include <malloc.h>
#include <stdlib.h>

typedef struct
{
  void *thread_data;
  void (*thread_dtor) (void *);
} __gthread_key_struct_t;

typedef __gthread_key_struct_t *__gthread_key_t;
typedef volatile signed char __gthread_once_t;
typedef _fmutex __gthread_mutex_t;

#define __GTHREAD_ONCE_INIT		0
#define __GTHREAD_MUTEX_INIT_FUNCTION	__gthread_mutex_init_function

static inline int
__gthread_active_p (void)
{
  return 1;
}

static inline int
__gthread_once (__gthread_once_t *once, void (*func) (void))
{
  if (__cxchg (once, 1) == 0)
    func ();
  return 0;
}

static inline void
__gthread_mutex_init_function (__gthread_mutex_t *mutex)
{
  _fmutex_create (mutex, 0);
}

static inline int
__gthread_mutex_lock (__gthread_mutex_t *mutex)
{
  return _fmutex_request (mutex, _FMR_IGNINT);
}

static inline int
__gthread_mutex_trylock (__gthread_mutex_t *mutex)
{
  return _fmutex_request (mutex, _FMR_IGNINT | _FMR_NOWAIT);
}

static inline int
__gthread_mutex_unlock (__gthread_mutex_t *mutex)
{
  return _fmutex_release (mutex);
}

#ifdef __cplusplus
#  define EXTERN_C extern "C"
#else
#  define EXTERN_C extern
#endif

/* rather than including os2.h we'll define the prototype here... */
EXTERN_C unsigned long DosAllocThreadLocalMemory (unsigned long dwords,
  unsigned long **ptr);
EXTERN_C unsigned long DosFreeThreadLocalMemory (unsigned long *ptr);

#undef EXTERN_C

/* @@@BUG: dtor is NEVER called when the thread exits; todo: modify EMX
   libc so that we have separate storage in current thread structure and
   _endthread() calls all the destructors we assign here... */
static inline int
__gthread_key_create (__gthread_key_t *key, void (*dtor) (void *))
{
  if (DosAllocThreadLocalMemory ((sizeof (__gthread_key_struct_t) + 3)/4,
        (unsigned long **)key))
    return -1;

  (*key)->thread_data = NULL;
  (*key)->thread_dtor = dtor;
  return 0;
}

static inline int
__gthread_key_dtor (__gthread_key_t key, void *ptr)
{
  key->thread_dtor (ptr);
  key->thread_dtor = NULL;
  return 0;
}

static inline int
__gthread_key_delete (__gthread_key_t key)
{
  return DosFreeThreadLocalMemory ((unsigned long *)key);
}

static inline void *
__gthread_getspecific (__gthread_key_t key)
{
  return key->thread_data;
}

static inline int
__gthread_setspecific (__gthread_key_t key, const void *ptr)
{
  key->thread_data = (void *)ptr;
  return 0;
}

#else /* __MT__ */

#include <bits/gthr-single.h>

#endif /* __MT__ */

#endif /* not __gthr_os2_h */
