/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_NUMBERFORMATEXCEPTION
#define __GLIB_NUMBERFORMATEXCEPTION

#include "glib/exceptions/GException.h"

/**
 * This exception can be thrown by various methods that tryes to parse a
 * string in order to convert it to a number, if the string is not possible
 * to convert to a number due to illegal characters, etc.
 *
 * @author  Leif Erik Larsen
 * @since   2000.01.23
 */
class GNumberFormatException : public GException
{
   public:

      explicit GNumberFormatException ( const char* msg = "" );
};

#endif


