/* --------------------------------------------------------------------------
 *
 * This file was part of the "More for C++" library.
 * Copyright (c) 1999-2003 by Thorsten Goertz.
 * The "More for C++" library is free software; you can
 * redistribute it and/or modify it under the terms of the license
 * that comes with http://www.morefor.org/.
 *
 * ------------------------------------------------------------------------ */

#ifndef SLICEDHEAPMANAGER_HPP
#define SLICEDHEAPMANAGER_HPP

#include "glib/gc/heapmanager.h"

class SlicedHeapManager: public HeapManager
{
public:
   SlicedHeapManager( );
   virtual void* createObject( size_t nSizeOfObject );
   virtual void destroyObject( void* pObject );
   virtual void compactHeap( );

private:
   class Slice
   {
      public:
      Slice ( size_t nSizeOfFirstObject, Slice* pNextSlice );
      void* createObject ( size_t nSizeOfObject );
      bool containsObject ( void* pObject ) const;
      void destroyObject ( void* pObject );
      bool isEmpty () const;
      void destroy ( Slice* pPreviousSlice );
      void compact ();
      Slice* getNext () const;

private:
      struct Chunk
      {
         bool    m_bInUse;
         Chunk*  m_pNextChunk;
         size_t  m_nSizeOfChunk;
      };

      typedef unsigned char* byte;

      size_t calcSizeOfChunk( size_t nSizeOfObject ) const;
      void splitChunk( Chunk* pChunk, size_t nRemainingSize );
      void joinChunks( Chunk* pFirstChunk );

      size_t  m_nSizeOfSlice;
      Slice*  m_pNextSlice;
      byte*   m_pBytes;
   };

   Slice* m_pFirstSlice;
};

#endif
