/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_CONTAINERWINDOW
#define __GLIB_CONTAINERWINDOW

#include "glib/gui/GWindow.h"

/**
 * The class that is used to form the parent window
 * of <i>GDecoratedWindow</i>.
 */
class GContainerWindow : public GWindow
{
   private:

      class GDecoratedWindow& client;

   public:

      GContainerWindow ( const GString& name,
                         const GString& constraints,
                         GDecoratedWindow& client,
                         GWindow* parentWin,
                         bool visible );

      virtual ~GContainerWindow ();

   private:

      /** Disable the copy constructor. */
      GContainerWindow ( const GContainerWindow& src ) : client(src.client) {}

      /** Disable the assignment operator. */
      GContainerWindow& operator= ( const GContainerWindow& ) { return *this; }

   protected:

      /**
       * Override {@link GWindow#handleWindowMessage} in order to handle
       * the WM_VSCROLL and the WM_HSCROLL events.
       */
      virtual GWindowMessage::Answer handleWindowMessage ( GWindowMessage& msg );

      /**
       * If both scroll bars are on then clear that little rectangle area
       * at the remaining space on the lower right corner where the two
       * scroll bars meets without touching each other. Don't simply clear
       * the whole rectangle area, because that woul cause some ugly
       * flashing in some situations.
       */
      virtual bool onPaint ( GGraphics& g, const GRectangle& rect );

   public:

      virtual void layout ();
};

#endif

