/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/gui/GFontMetrics.h"
#include "glib/gui/GGraphics.h"
#include "glib/util/GLog.h"

GFontMetrics::GFontMetrics ()
{
   memset(&data, 0, sizeof(data));
}

GFontMetrics::GFontMetrics ( const GFontMetrics& fm )
             :data(fm.data)
{
}

GFontMetrics::GFontMetrics ( const GGraphics& g )
{
   GGraphics::Handle gh = g.getHandle();
   if (gh == null)
   {
      memset(&data, 0, sizeof(data));
      return;
   }

   GpiQueryFontMetrics(gh, sizeof(data), &data);
}

GFontMetrics::GFontMetrics ( const GWindow& win )
{
   GGraphics g(win);
   GGraphics::Handle gh = g.getHandle();
   if (gh == null)
   {
      memset(&data, 0, sizeof(data));
      return;
   }

   GpiQueryFontMetrics(gh, sizeof(data), &data);
}

GFontMetrics& GFontMetrics::operator= ( const GFontMetrics& fm )
{
   this->data = fm.data;
   return *this;
}

int GFontMetrics::getHeight () const
{
   return data.lMaxBaselineExt;
}

int GFontMetrics::getAverageWidth () const
{
   return data.lAveCharWidth;
}
