/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_TOOLBARELEMENT
#define __GLIB_TOOLBARELEMENT

#include "glib/gui/GWindow.h"

/**
 * @author  Leif Erik Larsen
 * @since   2001.03.07
 */
class GToolbarElement : public GWindow
{
   protected:

      GToolbarElement ( const GString& name,
                        const GString& constraints,
                        GWindow& parentWin,
                        long winStyle = WS_VISIBLE,
                        int winStyle2 = WS2_OS2Y );

      virtual ~GToolbarElement ();

   private:

      /** Disable the copy constructor. */
      GToolbarElement ( const GToolbarElement& src ) {}

      /** Disable the assignment operator for this class. */
      GToolbarElement& operator= ( const GToolbarElement& ) { return *this; }

   public:

      virtual int getPreferredHeight () const = 0;

      virtual int getPreferredWidth () const = 0;

      /**
       * Return true if and only if "this" is the very first (leftmost)
       * toolbar element that is currently visible. Else return false.
       */
      bool isFirstVisibleToolbarElement () const;
};

#endif


