/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/gui/GToolbarSeparator.h"
#include "glib/gui/GGraphics.h"
#include "glib/util/GLog.h"

GToolbarSeparator::GToolbarSeparator ( GAbstractToolbarWindow& ownerTB, 
                                       const GString& constraints )
                  :GToolbarElement(GString::Empty, 
                                   constraints, 
                                   ownerTB,
                                   WS_VISIBLE,
                                   WS2_OS2Y | WS2_IGNORE_COLORS_AND_FONT_PROFILE),
                   ownerTB(ownerTB)
{
}

GToolbarSeparator::~GToolbarSeparator ()
{
}

bool GToolbarSeparator::onBackgroundColorChanged ( const GColor& color )
{
   // User has dropped a background color on a separator. Since the 
   // separator uses the same background color as of its owning toolbar
   // we can assume that the user want to change the background color 
   // of the toolbar as well. So do that.
   ownerTB.setBackgroundColor(color);
   return true;
}

bool GToolbarSeparator::onPaint ( GGraphics& g, const GRectangle& rect )
{
   GRectangle r = getWindowRect();
   g.setColor(ownerTB.getBackgroundColor());
   g.drawFilledRectangle(rect);

   // Paint vertical separator line only if the toolbar has "flat buttons".
   if (ownerTB.flatButtons)
   {
      g.setColor(GColor::DGRAY);
      int x = r.x + (r.width / 2);
      int y = r.y + 1;
      g.setPosition(x, y);
      y = r.y + r.height - 2;
      g.drawLineTo(x, y);
      g.setColor(GColor::WHITE);
      x += 1;
      g.setPosition(x, y);
      y = r.y + 1;
      g.drawLineTo(x, y);
   }

   return true;
}
