/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_DRAGDROPHANDLER
#define __GLIB_DRAGDROPHANDLER

#include "glib/primitives/GObject.h"

/**
 * This interface class declares the methods used to handle various 
 * Drag-N-Drop operations as delegated to the object specified by
 * a call to {@link GWindow#setDragDropHandler}.
 *
 * @author  Leif Erik Larsen
 * @since   2007.01.07
 */
class GDragDropHandler
{

public:

   virtual void handleBeginDrag ( int xpos, int ypos ) = 0;
   virtual void handleDragLeave ( class GDragInfo& di, class GGraphics& g ) = 0;
   virtual void handleDragOver ( class GDragInfo& di, class GGraphics& g, int xpos, int ypos, class GDragOverAnswer& answ ) = 0;
   virtual void handleDrop ( class GDragInfo& di, class GGraphics& g, int xpos, int ypos ) = 0;
};

#endif
